/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.conversion.es2tocsv;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openlca.olcatdb.ResourceFolder;
import org.openlca.olcatdb.conversion.AbstractConversionImpl;
import org.openlca.olcatdb.conversion.es2tocsv.ConversionUtils;
import org.openlca.olcatdb.datatypes.LangString;
import org.openlca.olcatdb.ecospold2.ES2Dataset;
import org.openlca.olcatdb.ecospold2.ES2EcoSpold;
import org.openlca.olcatdb.ecospold2.ES2ElementaryExchange;
import org.openlca.olcatdb.parsing.ContextObject;
import org.openlca.olcatdb.parsing.XmlContextParser;

public class ES2DatasetScanner
extends AbstractConversionImpl {
    private List<String> langs = new ArrayList<String>();
    private List<String> units = new ArrayList<String>();
    private Map<String, String[]> comparments = new HashMap<String, String[]>();
    private Set<String> geos = new HashSet<String>();
    private ScanMode mode;

    public ES2DatasetScanner(ScanMode mode, File sourceFile) {
        this.mode = mode;
        this.setSourceFile(sourceFile);
        this.monitorProgressText = "Scan";
    }

    public Map<String, String[]> getComparments() {
        return this.comparments;
    }

    public List<String> getLangs() {
        Collections.sort(this.langs);
        return this.langs;
    }

    public Set<String> getGeos() {
        return this.geos;
    }

    public List<String> getUnits() {
        Collections.sort(this.units);
        return this.units;
    }

    public void setMode(ScanMode mode) {
        this.mode = mode;
    }

    @Override
    public void run() {
        XmlContextParser parser = new XmlContextParser();
        while (this.hasNext()) {
            InputStream is = this.next();
            if (is == null) continue;
            try {
                ES2EcoSpold ecoSpold = parser.getContext(ES2EcoSpold.class, is);
                is.close();
                if (ecoSpold == null) continue;
                for (ES2Dataset dataset : ecoSpold.getDatasets()) {
                    switch (this.mode) {
                        case COMPARTMENTS: {
                            this.scanCompartments(dataset);
                            break;
                        }
                        case GEO: {
                            this.scanGeos(dataset);
                            break;
                        }
                        case LANG: {
                            this.scanLangs(dataset);
                            break;
                        }
                        case UNITS: {
                            this.scanUnits(dataset);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.flush();
    }

    @Override
    public ResourceFolder getResult() {
        return null;
    }

    private List<Object> getAllContextObjects(Object object) throws IllegalArgumentException, IllegalAccessException {
        ArrayList<Object> contextObjects = new ArrayList<Object>();
        for (Field field : object.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            if (field.getType().getSuperclass() != null && field.getType().getSuperclass().equals(ContextObject.class)) {
                contextObjects.add(field.get(object));
                continue;
            }
            if (field.getType() == null || !field.getType().equals(List.class)) continue;
            List list = (List)field.get(object);
            for (Object o : list) {
                if (!o.getClass().getSuperclass().equals(ContextObject.class)) continue;
                contextObjects.add(o);
            }
        }
        return contextObjects;
    }

    private void scanLangs(Object object) throws IllegalArgumentException, IllegalAccessException {
        if (object != null) {
            List<Object> contextObjects = this.getAllContextObjects(object);
            for (Field field : object.getClass().getDeclaredFields()) {
                if (field.getType() == null || !field.getType().equals(List.class)) continue;
                field.setAccessible(true);
                List list = (List)field.get(object);
                if (list.size() <= 0 || !list.get(0).getClass().equals(LangString.class)) continue;
                for (Object o : list) {
                    LangString langString = (LangString)LangString.class.cast(o);
                    if (langString.getLangCode() == null || this.langs.contains(langString.getLangCode())) continue;
                    this.langs.add(langString.getLangCode());
                }
            }
            for (Object e : contextObjects) {
                this.scanLangs(e);
            }
        }
    }

    private void scanUnits(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        if (object != null) {
            List<Object> contextObjects = this.getAllContextObjects(object);
            for (Method method : object.getClass().getMethods()) {
                List unitNames;
                String unit;
                if (!method.getName().equals("getUnitNames") || (unit = ConversionUtils.getLangEntry(unitNames = (List)method.invoke(object, new Object[0]))) == null || this.units.contains(unit)) continue;
                this.units.add(unit);
            }
            for (Object e : contextObjects) {
                this.scanUnits(e);
            }
        }
    }

    private void scanGeos(ES2Dataset dataset) throws IllegalArgumentException, IllegalAccessException {
        String geo = null;
        if (dataset.geography != null) {
            geo = ConversionUtils.getLangEntry(dataset.geography.getShortNames());
        }
        if (geo != null) {
            this.geos.add(geo);
        }
    }

    private void scanCompartments(ES2Dataset dataset) {
        for (ES2ElementaryExchange exchange : dataset.getElementaryExchanges()) {
            String compartment = ConversionUtils.getLangEntry(exchange.getCompartment());
            String subcompartment = ConversionUtils.getLangEntry(exchange.getSubCompartment());
            String key = compartment + subcompartment;
            String[] elem = new String[]{compartment, subcompartment};
            this.comparments.put(key, elem);
        }
    }

    public static enum ScanMode {
        LANG,
        COMPARTMENTS,
        GEO,
        UNITS;

    }
}

