/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.conversion.es2tocsv;

import com.greendeltatc.simapro.csv.model.types.Geography;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openlca.olcatdb.conversion.es2tocsv.CompartmentModel;
import org.supercsv.io.CsvListReader;
import org.supercsv.io.CsvListWriter;
import org.supercsv.prefs.CsvPreference;

public final class ES2MappingFileUtil {
    private static List<List<String>> readCSVFile(File file) throws IOException {
        List<String> line;
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        CsvListReader csvReader = new CsvListReader(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("UTF-8"))), CsvPreference.EXCEL_NORTH_EUROPE_PREFERENCE);
        while (null != (line = csvReader.read())) {
            ArrayList<String> temp = new ArrayList<String>();
            temp.addAll(line);
            list.add(temp);
        }
        csvReader.close();
        return list;
    }

    public static Map<String, Geography> readGeography(File file) throws IOException {
        List<List<String>> lines = ES2MappingFileUtil.readCSVFile(file);
        return ES2MappingFileUtil.readGeography(lines);
    }

    public static Map<String, Geography> readGeography(List<List<String>> lines) {
        HashMap<String, Geography> map = new HashMap<String, Geography>();
        for (List<String> line : lines) {
            map.put(line.get(0), Geography.getInstances().get(line.get(1)));
        }
        return map;
    }

    public static List<CompartmentModel> readCompartments(File file) throws IOException {
        List<List<String>> lines = ES2MappingFileUtil.readCSVFile(file);
        return ES2MappingFileUtil.readCompartments(lines);
    }

    public static List<CompartmentModel> readCompartments(List<List<String>> lines) {
        ArrayList<CompartmentModel> list = new ArrayList<CompartmentModel>();
        for (List<String> line : lines) {
            CompartmentModel model = new CompartmentModel();
            model.setEs2Compartment(line.get(0));
            model.setEs2Subcompartment(line.get(1));
            model.setSimaProElemType(line.get(2));
            model.setSimaProSubcompartment(line.get(3));
            list.add(model);
        }
        return list;
    }

    public static List<String> readElecricityUnits(File file) throws IOException {
        List<List<String>> lines = ES2MappingFileUtil.readCSVFile(file);
        return ES2MappingFileUtil.readElecricityUnits(lines);
    }

    public static List<String> readElecricityUnits(List<List<String>> lines) {
        ArrayList<String> list = new ArrayList<String>();
        for (List<String> line : lines) {
            list.add(line.get(0));
        }
        return list;
    }

    public static void writeCSVFile(File file, List<List<String>> rows) throws IOException {
        StringWriter stringWriter = new StringWriter();
        CsvListWriter csvWriter = new CsvListWriter(stringWriter, CsvPreference.EXCEL_NORTH_EUROPE_PREFERENCE);
        for (List<String> list : rows) {
            csvWriter.write(list);
        }
        csvWriter.close();
        PrintWriter printWriter = new PrintWriter(file);
        printWriter.println(stringWriter.toString());
        stringWriter.close();
        printWriter.close();
    }
}

