/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.conversion.es2tocsv;

import com.greendeltatc.simapro.csv.CSVWriter;
import com.greendeltatc.simapro.csv.model.SPDataEntry;
import com.greendeltatc.simapro.csv.model.SPDataSet;
import com.greendeltatc.simapro.csv.model.SPInputParameter;
import com.greendeltatc.simapro.csv.model.SPProcess;
import com.greendeltatc.simapro.csv.model.SPReferenceProduct;
import com.greendeltatc.simapro.csv.model.SPUnit;
import com.greendeltatc.simapro.csv.model.SPWasteSpecification;
import com.greendeltatc.simapro.csv.model.SPWasteTreatment;
import com.greendeltatc.simapro.csv.model.types.ElementaryFlowType;
import com.greendeltatc.simapro.csv.model.types.Geography;
import com.greendeltatc.simapro.csv.model.types.SubCompartment;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.openlca.olcatdb.ResourceFolder;
import org.openlca.olcatdb.conversion.AbstractConversionImpl;
import org.openlca.olcatdb.conversion.csv.resources.CSVFolder;
import org.openlca.olcatdb.conversion.es2tocsv.ActivityEntry;
import org.openlca.olcatdb.conversion.es2tocsv.ActivityType;
import org.openlca.olcatdb.conversion.es2tocsv.CompartmentModel;
import org.openlca.olcatdb.conversion.es2tocsv.Conversion;
import org.openlca.olcatdb.conversion.es2tocsv.ConversionComment;
import org.openlca.olcatdb.conversion.es2tocsv.ConversionUtils;
import org.openlca.olcatdb.conversion.es2tocsv.DataSetMerger;
import org.openlca.olcatdb.conversion.es2tocsv.ES2MappingFileUtil;
import org.openlca.olcatdb.conversion.es2tocsv.ProductNameSavePreferences;
import org.openlca.olcatdb.datatypes.DataSetReference;
import org.openlca.olcatdb.ecospold2.ES2Dataset;
import org.openlca.olcatdb.ecospold2.ES2EcoSpold;
import org.openlca.olcatdb.ecospold2.ES2ElementaryExchange;
import org.openlca.olcatdb.ecospold2.ES2IntermediateExchange;
import org.openlca.olcatdb.ecospold2.masterdata.ES2MDDataSet;
import org.openlca.olcatdb.parsing.XmlContextParser;
import org.openlca.olcatdb.swing.ES2CompartmentPanel;
import org.openlca.olcatdb.swing.ES2ElecMappingPanel;
import org.openlca.olcatdb.swing.ES2GeoMappingPanel;

public class ES2ToCSVSetUpConversion
extends AbstractConversionImpl {
    private CSVWriter writer = new CSVWriter('.');
    private SPDataSet generalData = new SPDataSet("");
    private boolean splitCSV = false;
    private CSVFolder folder;
    private Map<String, ActivityEntry> activityIndex = new HashMap<String, ActivityEntry>();
    private Map<String, SPInputParameter> paramterIndex = new HashMap<String, SPInputParameter>();
    private Map<String, CompartmentModel> compartments = new HashMap<String, CompartmentModel>();
    private Map<String, Geography> geoMap = new HashMap<String, Geography>();
    private Set<String> electricityUnits = new HashSet<String>();
    private ActivityType activityType;
    private ES2MDDataSet md = new ES2MDDataSet();
    ProductNameSavePreferences saves = null;
    private File masterDataZip;
    private boolean writeRef = false;
    private DataSetReference reference;
    private OverwriteFile overwriteFile = null;

    public ES2ToCSVSetUpConversion(boolean splitCSV, String lang, File masterDataZip) {
        this.splitCSV = splitCSV;
        ConversionUtils.lang = lang;
        this.masterDataZip = masterDataZip;
        this.saves = ProductNameSavePreferences.readDatabase();
    }

    public void setSplitFiles(boolean splitFiles) {
        this.splitCSV = splitFiles;
    }

    @Override
    public void createFolder(File targetDir) {
        this.folder = new CSVFolder(targetDir);
        this.logFile(this.folder);
    }

    @Override
    public ResourceFolder getResult() {
        return this.folder;
    }

    @Override
    public void run() {
        this.createFolder(this.targetDir);
        this.monitor.progress("Read the master data ...", 0);
        try {
            this.md.read(this.masterDataZip);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.monitor.progress("Indexing files ...", 0);
        this.createIndex();
        this.setMappings();
        XmlContextParser parser = new XmlContextParser();
        block6: while (this.hasNext()) {
            InputStream is = this.next();
            if (is == null) continue;
            try {
                ES2EcoSpold ecoSpold = parser.getContext(ES2EcoSpold.class, is);
                is.close();
                if (ecoSpold == null) continue;
                for (ES2Dataset dataset : ecoSpold.getDatasets()) {
                    DataSetReference reference;
                    if (this.overwriteFile == OverwriteFile.BREAK) continue block6;
                    this.monitor.progress("Convert " + dataset.description.id, 0);
                    DataSetMerger merger = new DataSetMerger();
                    if (dataset.isChildDataSet) {
                        merger.mergeChildAndParentDataset(dataset, this.activityIndex, this.masterDataZip, this.sourceZip, this.logger);
                    }
                    if ((reference = this.convert(dataset)) == null) continue;
                    this.createdFiles.add(reference);
                }
            }
            catch (Exception e) {
                this.logger.severe("Parse exception: " + e.getMessage());
                e.printStackTrace();
            }
        }
        if (!this.splitCSV) {
            try {
                this.writer.write(this.targetDir, new SPDataSet(""), true, true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.flush();
    }

    private void setMappings() {
        this.geoMap = ES2MappingFileUtil.readGeography(ES2GeoMappingPanel.getInstance().getRows());
        for (Geography geography : Geography.values()) {
            this.geoMap.put(geography.getValue(), geography);
        }
        for (CompartmentModel m : ES2MappingFileUtil.readCompartments(ES2CompartmentPanel.getInstance().getRows())) {
            this.compartments.put(m.getEs2Compartment() + m.getEs2Subcompartment(), m);
        }
        for (ElementaryFlowType flowType : ElementaryFlowType.values()) {
            CompartmentModel m = new CompartmentModel();
            String typeName = flowType.getValue();
            m.setSimaProElemType(typeName);
            m.setEs2Compartment(typeName);
            this.compartments.put(typeName, m);
            for (SubCompartment subCompartment : flowType.getSubCompartments()) {
                CompartmentModel m2 = new CompartmentModel();
                String subName = subCompartment.getValue();
                m2.setSimaProElemType(typeName);
                m2.setEs2Compartment(typeName);
                m2.setEs2Subcompartment(subName);
                m2.setSimaProSubcompartment(subName);
                this.compartments.put(m2.getEs2Compartment() + m2.getEs2Subcompartment(), m2);
            }
        }
        this.electricityUnits.addAll(ES2MappingFileUtil.readElecricityUnits(ES2ElecMappingPanel.getInstance().getRows()));
    }

    private void createIndex() {
        XmlContextParser parser = new XmlContextParser();
        try {
            if (this.sourceXml != null) {
                FileInputStream stream = new FileInputStream(this.sourceXml);
                ES2EcoSpold ecoSpold = parser.getContext(ES2EcoSpold.class, stream);
                if (ecoSpold != null) {
                    for (ES2Dataset dataset : ecoSpold.getDatasets()) {
                        this.addActivityToIndex(dataset);
                        this.createParameterIndex(dataset);
                    }
                }
            } else if (this.sourceZip != null) {
                ZipFile zf = this.sourceZip;
                Enumeration<? extends ZipEntry> entries = zf.entries();
                while (entries.hasMoreElements()) {
                    InputStream stream;
                    ES2EcoSpold ecoSpold;
                    ZipEntry entry = entries.nextElement();
                    if (!entry.getName().endsWith(".spold") || (ecoSpold = parser.getContext(ES2EcoSpold.class, stream = this.sourceZip.getInputStream(entry))) == null) continue;
                    for (ES2Dataset dataset : ecoSpold.getDatasets()) {
                        this.addActivityToIndex(dataset);
                        this.createParameterIndex(dataset);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.severe("Parse exception: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void createParameterIndex(ES2Dataset dataset) {
        SPInputParameter parameter;
        for (ES2IntermediateExchange eS2IntermediateExchange : dataset.getIntermediateExchanges()) {
            if (eS2IntermediateExchange.variableName == null || eS2IntermediateExchange.variableName.equals("")) continue;
            parameter = new SPInputParameter(eS2IntermediateExchange.variableName, eS2IntermediateExchange.amount);
            this.paramterIndex.put(eS2IntermediateExchange.variableName, parameter);
            parameter.setComment("From Activity: " + ConversionUtils.getLangEntry(dataset.description.getName()) + " Exchange: " + ConversionUtils.getLangEntry(eS2IntermediateExchange.getName()));
        }
        for (ES2ElementaryExchange eS2ElementaryExchange : dataset.getElementaryExchanges()) {
            if (eS2ElementaryExchange.variableName == null || eS2ElementaryExchange.variableName.equals("")) continue;
            parameter = new SPInputParameter(eS2ElementaryExchange.variableName, eS2ElementaryExchange.amount);
            this.paramterIndex.put(eS2ElementaryExchange.variableName, parameter);
            parameter.setComment("From Activity: " + ConversionUtils.getLangEntry(dataset.description.getName()) + " Exchange: " + ConversionUtils.getLangEntry(eS2ElementaryExchange.getName()));
        }
    }

    private void addActivityToIndex(ES2Dataset dataset) {
        ActivityEntry entry = new ActivityEntry();
        this.activityIndex.put(dataset.description.id, entry);
        entry.fileName = this.getCurrentFileName();
        boolean foundRefFlow = false;
        entry.id = dataset.description.id;
        if (entry.id == null || entry.id.equals("")) {
            throw new IllegalArgumentException("Null activity id in file: " + entry.fileName);
        }
        for (ES2IntermediateExchange exchange : dataset.getIntermediateExchanges()) {
            if (exchange.outputGroup == null || exchange.outputGroup != 0) continue;
            if (!foundRefFlow) {
                foundRefFlow = true;
                entry.refFlowId = exchange.id;
                entry.refFlowName = this.setFullRefFlowName(exchange, dataset);
                entry.refFlowUnit = new SPUnit(ConversionUtils.getLangEntry(exchange.getUnitNames()));
                entry.refFlowAmount = String.valueOf(exchange.amount);
                if (!(exchange.amount < 0.0)) continue;
                entry.activityType = ActivityType.WASTE_TREATMENT;
                continue;
            }
            entry.changeProducts.add(exchange.id);
        }
        if (!foundRefFlow) {
            this.logger.severe("For \"" + ConversionUtils.getLangEntry(dataset.description.getName()) + "\" no reference flow (outputGroup=0) exist.");
        }
    }

    private String setFullRefFlowName(ES2IntermediateExchange exchange, ES2Dataset dataset) {
        String name = ConversionUtils.getLangEntry(exchange.getName());
        String geo = ConversionUtils.getLangEntry(dataset.geography.getShortNames());
        String activityName = ConversionUtils.getLangEntry(dataset.description.getName());
        String systemModelName = null;
        if (dataset.representativeness != null) {
            systemModelName = ConversionUtils.getLangEntry(dataset.representativeness.getSystemModelName());
        }
        if (systemModelName == null) {
            systemModelName = "";
        }
        int t = dataset.description.type;
        String type = "";
        switch (t) {
            case 1: {
                type = "S";
                break;
            }
            case 2: {
                type = "U";
            }
        }
        return this.saves.getSortedName(name, geo, activityName, systemModelName, type);
    }

    private DataSetReference convert(ES2Dataset dataset) throws IOException, IllegalAccessException {
        ActivityEntry entry = this.activityIndex.get(dataset.description.id);
        if (entry == null) {
            throw new IllegalArgumentException("Activity \"" + ConversionUtils.getLangEntry(dataset.description.getName()) + "\" in index not found.");
        }
        this.activityType = entry.activityType;
        String project = this.splitCSV ? dataset.description.id : "ES2 Conversion";
        SPDataSet spDataSet = new SPDataSet(project);
        SPDataEntry dataEntry = null;
        switch (this.activityType) {
            case PROCESS: {
                SPProcess process;
                dataEntry = process = new SPProcess(new SPReferenceProduct(entry.refFlowName, entry.refFlowUnit, entry.refFlowAmount));
                break;
            }
            case WASTE_TREATMENT: {
                SPWasteTreatment wasteTreatment = new SPWasteTreatment(new SPWasteSpecification(entry.refFlowName, entry.refFlowUnit, entry.refFlowAmount));
                dataEntry = wasteTreatment;
            }
        }
        Conversion conversion = new Conversion(this.paramterIndex, this.activityType, this.logger);
        conversion.description(dataEntry, dataset);
        conversion.geography(dataEntry, dataset, this.geoMap);
        conversion.timePeriod(dataEntry, dataset);
        conversion.technology(dataEntry, dataset);
        conversion.paramter(dataEntry, dataset);
        conversion.intermediateExchanges(dataEntry, dataset, entry, this.electricityUnits);
        conversion.elementaryExchanges(dataEntry, dataset, this.compartments);
        ConversionComment.documentationComment(dataEntry, dataset);
        ConversionComment.verification(dataEntry, dataset);
        ConversionComment.record(dataEntry, dataset);
        ConversionComment.generator(dataEntry, dataset);
        ConversionComment.collectionMethodANDDataTreatment(dataEntry, dataset);
        ConversionComment.allocationRules(dataEntry, dataset);
        ConversionComment.literatureReference(dataEntry, dataset);
        switch (this.activityType) {
            case PROCESS: {
                spDataSet.add((SPProcess)dataEntry);
                break;
            }
            case WASTE_TREATMENT: {
                spDataSet.add((SPWasteTreatment)dataEntry);
            }
        }
        if (!this.writeRef) {
            this.reference = new DataSetReference();
            if (spDataSet.getProject() != null) {
                this.reference.setRefObjectId(spDataSet.getProject());
            }
            this.reference.setType("process data set");
            try {
                String uri = this.folder.getRootDir() + File.separator + spDataSet.getProject() + ".csv";
                this.reference.setUri(uri);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.reference.setName(spDataSet.getProject());
        } else {
            this.reference = null;
        }
        File outFile = new File(this.folder.getRootDir() + File.separator + project + ".csv");
        if (outFile.exists()) {
            if (!this.splitCSV) {
                if (this.overwriteFile != OverwriteFile.YES_TO_ALL) {
                    String message = "The file " + outFile.getAbsolutePath() + " already exists. Do you want to overwrite the file?";
                    Object[] buttons = new Object[]{"Yes", "No"};
                    int rc = JOptionPane.showOptionDialog(new JFrame(), message, "File exist", 0, 3, null, buttons, buttons[0]);
                    switch (rc) {
                        case 0: {
                            this.overwriteFile = OverwriteFile.YES_TO_ALL;
                            this.writeDataset(spDataSet);
                            break;
                        }
                        case 1: {
                            this.overwriteFile = OverwriteFile.BREAK;
                            this.reference = null;
                        }
                    }
                } else {
                    this.writeDataset(spDataSet);
                }
            } else if (this.overwriteFile == OverwriteFile.YES_TO_ALL) {
                this.writeDataset(spDataSet);
            } else if (this.overwriteFile == OverwriteFile.NO_TO_ALL) {
                this.reference = null;
            } else {
                String message = "The file " + outFile.getAbsolutePath() + " already exists. Do you want to overwrite the file?";
                Object[] buttons = new Object[]{"Yes", "Yes to all", "No", "No to all"};
                int rc = JOptionPane.showOptionDialog(new JFrame(), message, "File exist", 0, 3, null, buttons, buttons[0]);
                switch (rc) {
                    case -1: {
                        System.out.println("Dialog closed without clicking a button.");
                        break;
                    }
                    case 0: {
                        this.writeDataset(spDataSet);
                        break;
                    }
                    case 1: {
                        this.overwriteFile = OverwriteFile.YES_TO_ALL;
                        this.writeDataset(spDataSet);
                        break;
                    }
                    case 2: {
                        this.reference = null;
                        break;
                    }
                    case 3: {
                        this.overwriteFile = OverwriteFile.NO_TO_ALL;
                        this.reference = null;
                    }
                }
            }
        } else {
            this.writeDataset(spDataSet);
        }
        return this.reference;
    }

    private void writeDataset(SPDataSet spDataSet) throws IOException {
        if (this.splitCSV) {
            this.writer.write(this.folder.getRootDir(), spDataSet);
        } else {
            this.writer.write(this.folder.getRootDir(), spDataSet, true, false);
            this.writeRef = true;
        }
    }

    private static enum OverwriteFile {
        YES_TO_ALL,
        NO_TO_ALL,
        BREAK;

    }
}

