/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.database;

import java.sql.ResultSet;
import java.util.UUID;
import org.openlca.olcatdb.database.Database;
import org.openlca.olcatdb.database.ES2CompartmentRec;
import org.openlca.olcatdb.database.ES2UnitRec;
import org.openlca.olcatdb.datatypes.LangString;
import org.openlca.olcatdb.ecospold2.ES2ElementaryExchange;

public class ES2ElemFlowRec {
    private String id;
    private String cas;
    private String formula;
    private String name;
    private String unitId;
    private String compartmentId;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCas() {
        return this.cas;
    }

    public void setCas(String cas) {
        this.cas = cas;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUnitId() {
        return this.unitId;
    }

    public void setUnitId(String unitId) {
        this.unitId = unitId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public void setCompartmentId(String compartmentId) {
        this.compartmentId = compartmentId;
    }

    public static ES2ElemFlowRec forID(String id) {
        ES2ElemFlowRec rec = null;
        String query = "SELECT * FROM ES2_ELEM_FLOWS WHERE id='" + id + "'";
        try {
            ResultSet rs = Database.getInstance().query(query);
            if (rs.next()) {
                rec = new ES2ElemFlowRec();
                rec.cas = rs.getString("cas");
                rec.compartmentId = rs.getString("compartmentId");
                rec.formula = rs.getString("formula");
                rec.id = id;
                rec.name = rs.getString("name");
                rec.unitId = rs.getString("unitId");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rec;
    }

    public ES2ElementaryExchange toExchange() {
        ES2ElementaryExchange eExchange = new ES2ElementaryExchange();
        eExchange.casNumber = this.cas;
        eExchange.elementaryExchangeId = this.id;
        eExchange.id = UUID.randomUUID().toString();
        eExchange.unitId = this.unitId;
        eExchange.isCalculatedAmount = false;
        eExchange.getName().add(new LangString(this.name));
        ES2UnitRec rec = ES2UnitRec.forID(this.unitId);
        if (rec != null) {
            eExchange.getUnitNames().add(new LangString(rec.getName()));
        }
        eExchange.compartmentId = this.compartmentId;
        ES2CompartmentRec compRec = ES2CompartmentRec.forID(this.compartmentId);
        if (rec != null) {
            eExchange.getCompartment().add(new LangString(compRec.getCompartment()));
            if (compRec.getSubCompartment() != null) {
                eExchange.getSubCompartment().add(new LangString(compRec.getSubCompartment()));
            }
        }
        return eExchange;
    }
}

