/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.database;

import java.sql.ResultSet;
import org.openlca.olcatdb.database.Database;
import org.openlca.olcatdb.datatypes.DataSetReference;
import org.openlca.olcatdb.datatypes.LangString;
import org.openlca.olcatdb.ilcd.ILCDDataSetType;
import org.openlca.olcatdb.ilcd.ILCDFlowPropertyValue;

public class ILCDPropertyRec {
    private String id;
    private String name;
    private String unitGroupId;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUnitGroupId() {
        return this.unitGroupId;
    }

    public void setUnitGroupId(String unitGroupId) {
        this.unitGroupId = unitGroupId;
    }

    public static ILCDPropertyRec forID(String propId) {
        ILCDPropertyRec rec = null;
        String query = "SELECT * FROM ILCD_FLOW_PROPERTIES WHERE id='" + propId + "'";
        try {
            ResultSet set = Database.getInstance().query(query);
            if (set.next()) {
                rec = new ILCDPropertyRec();
                rec.id = set.getString("id");
                rec.name = set.getString("name");
                rec.unitGroupId = set.getString("unitGroupId");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rec;
    }

    public DataSetReference toReference() {
        DataSetReference ref = new DataSetReference();
        ref.setName(this.name);
        ref.setRefObjectId(this.id);
        ref.setType(ILCDDataSetType.FlowProperty.toString());
        ref.setUri("../flowproperties/" + this.id + ".xml");
        ref.setVersion("02.00.000");
        ref.getDescription().add(new LangString(this.name));
        return ref;
    }

    public ILCDFlowPropertyValue toValue() {
        ILCDFlowPropertyValue propValue = new ILCDFlowPropertyValue();
        propValue.flowPropertyDataSet = this.toReference();
        propValue.id = 0;
        propValue.meanValue = 1.0;
        return propValue;
    }

    public static String unit(String id) {
        String unit = null;
        String query = "SELECT u.refUnit AS unit FROM ILCD_FLOW_PROPERTIES p INNER JOIN ILCD_UNIT_GROUPS u ON p.unitGroupId = u.id WHERE p.id='" + id + "'";
        try {
            ResultSet rs = Database.getInstance().query(query);
            if (rs.next()) {
                unit = rs.getString("unit");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return unit;
    }
}

