/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.datatypes;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openlca.olcatdb.datatypes.LangString;
import org.openlca.olcatdb.ilcd.ILCDDataSetType;

public class DataSetReference {
    private String name;
    private Map<String, Object> extensions = new HashMap<String, Object>();
    private String refObjectId;
    private String type;
    private String uri;
    private String version;
    private List<String> subReferences = new ArrayList<String>();
    private List<LangString> description = new ArrayList<LangString>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRefObjectId() {
        return this.refObjectId;
    }

    public void setRefObjectId(String refObjectId) {
        this.refObjectId = refObjectId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public List<String> getSubReferences() {
        return this.subReferences;
    }

    public List<LangString> getDescription() {
        return this.description;
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public String toString() {
        return "DataSetReference [name=" + this.name + ", refObjectId=" + this.refObjectId + ", type=" + this.type + ", uri=" + this.uri + ", version=" + this.version + "]";
    }

    public DataSetReference copy() {
        DataSetReference copy = new DataSetReference();
        copy.description.addAll(this.description);
        copy.extensions.putAll(this.extensions);
        copy.name = this.name;
        copy.refObjectId = this.refObjectId;
        copy.subReferences.addAll(this.subReferences);
        copy.type = this.type;
        copy.uri = this.uri;
        copy.version = this.version;
        return copy;
    }

    public static Comparator<DataSetReference> comparator() {
        Comparator<DataSetReference> comparator = new Comparator<DataSetReference>(){

            private int rank(ILCDDataSetType type) {
                switch (type) {
                    case Process: {
                        return 0;
                    }
                    case Flow: {
                        return 1;
                    }
                    case FlowProperty: {
                        return 2;
                    }
                    case UnitGroup: {
                        return 3;
                    }
                    case Source: {
                        return 4;
                    }
                    case Contact: {
                        return 5;
                    }
                }
                return 6;
            }

            @Override
            public int compare(DataSetReference ref1, DataSetReference ref2) {
                int c = 0;
                ILCDDataSetType type1 = ILCDDataSetType.forName(ref1.getType());
                ILCDDataSetType type2 = ILCDDataSetType.forName(ref2.getType());
                if (type1 == null && type2 != null) {
                    c = 1;
                } else if (type1 != null && type2 == null) {
                    c = -1;
                } else if (type1 != null && type2 != null) {
                    c = this.rank(type1) - this.rank(type2);
                }
                if (c == 0) {
                    if (ref1.name == null && ref2.name != null) {
                        c = 1;
                    } else if (ref1.name != null && ref2.name == null) {
                        c = -1;
                    } else if (ref1.name != null && ref2.name != null) {
                        c = ref1.name.compareToIgnoreCase(ref2.name);
                    }
                }
                return c;
            }
        };
        return comparator;
    }
}

