/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.datatypes;

import java.util.Iterator;
import java.util.List;

public class LangString {
    private String langCode;
    private String value;
    private int index = 0;

    public LangString() {
        this.langCode = "en";
        this.value = "";
    }

    public LangString(String value) {
        this.langCode = "en";
        this.value = value;
    }

    public LangString(String langCode, String value) {
        this.langCode = langCode;
        this.value = value;
    }

    public String getLangCode() {
        return this.langCode;
    }

    public LangString setLangCode(String langCode) {
        this.langCode = langCode;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public LangString setValue(String value) {
        this.value = value;
        return this;
    }

    public static LangString getFirst(List<LangString> langStrings, String langCode) {
        LangString first = null;
        Iterator<LangString> it = langStrings.iterator();
        while (first == null && it.hasNext()) {
            LangString langString = it.next();
            if ((langCode != null || langString.langCode != null) && (langCode == null || !langCode.equals(langString.langCode))) continue;
            first = langString;
        }
        return first;
    }

    public static LangString getFirst(List<LangString> langStrings) {
        LangString first = null;
        if (!langStrings.isEmpty()) {
            first = langStrings.get(0);
        }
        return first;
    }

    public static String getFirstValue(List<LangString> langStrings, String langCode) {
        String v = null;
        LangString lString = LangString.getFirst(langStrings, langCode);
        if (lString != null) {
            v = lString.getValue();
        }
        return v;
    }

    public static String getFirstValue(List<LangString> langStrings) {
        String val = null;
        if (!langStrings.isEmpty()) {
            val = langStrings.get((int)0).value;
        }
        return val;
    }

    public static boolean contains(List<LangString> langStrings, String val) {
        boolean b = false;
        for (LangString lStr : langStrings) {
            if (val == null && lStr.value == null) {
                b = true;
                break;
            }
            if (lStr.value == null || !lStr.value.equals(val)) continue;
            b = true;
            break;
        }
        return b;
    }

    public static void concat(List<LangString> source, List<LangString> target, String separator) {
        for (LangString sourceString : source) {
            LangString targetString = LangString.getFirst(target, sourceString.langCode);
            if (targetString == null) {
                target.add(sourceString);
                continue;
            }
            if (targetString.value != null) {
                targetString.value = targetString.value.concat(separator).concat(sourceString.value);
                continue;
            }
            targetString.value = sourceString.value;
        }
    }

    public int getIndex() {
        return this.index;
    }

    public LangString setIndex(int index) {
        this.index = index;
        return this;
    }

    public String toString() {
        return "MultiLangString [index=" + this.index + ", " + (this.langCode != null ? "langCode=" + this.langCode + ", " : "") + (this.value != null ? "value=" + this.value : "") + "]";
    }

    public boolean equals(Object obj) {
        if (obj instanceof LangString && obj != null) {
            boolean codeIsEqual;
            LangString ls = (LangString)LangString.class.cast(obj);
            boolean valueIsEqual = ls.value != null && this.value != null && this.value.equals(ls.value) || this.value == null && ls.value == null;
            boolean bl = codeIsEqual = ls.langCode != null && this.langCode != null && this.langCode.equals(ls.langCode) || this.langCode == null && ls.langCode == null;
            return valueIsEqual && codeIsEqual;
        }
        return false;
    }
}

