/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.datatypes;

public enum ProcessType {
    UnitProcess("Unit process, single operation", 1),
    UnitProcessBlackBox("Unit process, black box", -1),
    LCIResult("LCI result", 2),
    PartlyTerminatedSystem("Partly terminated system", -1),
    AvoidedProductSystem("Avoided product system", -1),
    MultiOutputProcess("Unit process, black box", 5);

    private final String ilcdName;
    private final int ecoSpoldCode;

    private ProcessType(String ilcdName, int ecoSpoldCode) {
        this.ilcdName = ilcdName;
        this.ecoSpoldCode = ecoSpoldCode;
    }

    public int getEcoSpoldCode() {
        return this.ecoSpoldCode != -1 ? this.ecoSpoldCode : 1;
    }

    public String getILCDName() {
        return this.ilcdName;
    }

    public static ProcessType fromILCDName(String ilcdName) {
        ProcessType type = null;
        for (ProcessType t : ProcessType.values()) {
            if (!t.ilcdName.equals(ilcdName)) continue;
            type = t;
            break;
        }
        return type == null ? UnitProcessBlackBox : type;
    }

    public static ProcessType fromEcoSpoldCode(int code) {
        ProcessType type = null;
        for (ProcessType t : ProcessType.values()) {
            if (t.ecoSpoldCode != code) continue;
            type = t;
            break;
        }
        return type == null ? UnitProcess : type;
    }
}

