/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.ecospold1;

import java.util.ArrayList;
import java.util.List;
import org.openlca.olcatdb.ecospold1.ES1AllocationFactor;
import org.openlca.olcatdb.ecospold1.ES1DataEntryBy;
import org.openlca.olcatdb.ecospold1.ES1DataGeneratorAndPublication;
import org.openlca.olcatdb.ecospold1.ES1DataSetInformation;
import org.openlca.olcatdb.ecospold1.ES1Exchange;
import org.openlca.olcatdb.ecospold1.ES1Geography;
import org.openlca.olcatdb.ecospold1.ES1Person;
import org.openlca.olcatdb.ecospold1.ES1ReferenceFunction;
import org.openlca.olcatdb.ecospold1.ES1Representativeness;
import org.openlca.olcatdb.ecospold1.ES1Source;
import org.openlca.olcatdb.ecospold1.ES1Technology;
import org.openlca.olcatdb.ecospold1.ES1TimePeriod;
import org.openlca.olcatdb.ecospold1.ES1Validation;
import org.openlca.olcatdb.parsing.Context;
import org.openlca.olcatdb.parsing.ContextField;
import org.openlca.olcatdb.parsing.ContextObject;
import org.openlca.olcatdb.parsing.SubContext;

@Context(name="dataset", parentName="ecoSpold")
public class ES1Dataset
extends ContextObject {
    @ContextField(name="dataset", parentName="ecoSpold", isAttribute=true, attributeName="generator", isMultiple=false, type=ContextField.Type.Text)
    public String generator;
    @ContextField(name="dataset", parentName="ecoSpold", isAttribute=true, attributeName="number", isMultiple=false, type=ContextField.Type.Integer)
    public Integer number;
    @ContextField(name="dataset", parentName="ecoSpold", isAttribute=true, attributeName="timestamp", isMultiple=false, type=ContextField.Type.Text)
    public String timestamp;
    @ContextField(name="dataset", parentName="ecoSpold", isAttribute=true, attributeName="validCategories", isMultiple=false, type=ContextField.Type.Text)
    public String validCategories;
    @ContextField(name="dataset", parentName="ecoSpold", isAttribute=true, attributeName="validCompanyCodes", isMultiple=false, type=ContextField.Type.Text)
    public String validCompanyCodes;
    @ContextField(name="dataset", parentName="ecoSpold", isAttribute=true, attributeName="validRegionalCodes", isMultiple=false, type=ContextField.Type.Text)
    public String validRegionalCodes;
    @ContextField(name="dataset", parentName="ecoSpold", isAttribute=true, attributeName="validUnits", isMultiple=false, type=ContextField.Type.Text)
    public String validUnits;
    @SubContext(isMultiple=true, contextClass=ES1AllocationFactor.class)
    private List<ES1AllocationFactor> allocations = new ArrayList<ES1AllocationFactor>();
    @SubContext(isMultiple=false, contextClass=ES1DataEntryBy.class)
    public ES1DataEntryBy dataEntryBy;
    @SubContext(isMultiple=false, contextClass=ES1DataGeneratorAndPublication.class)
    public ES1DataGeneratorAndPublication dataGeneratorAndPublication;
    @SubContext(isMultiple=false, contextClass=ES1DataSetInformation.class)
    public ES1DataSetInformation dataSetInformation;
    @SubContext(isMultiple=true, contextClass=ES1Exchange.class)
    private List<ES1Exchange> exchanges = new ArrayList<ES1Exchange>();
    @SubContext(isMultiple=false, contextClass=ES1Geography.class)
    public ES1Geography geography;
    @SubContext(isMultiple=true, contextClass=ES1Person.class)
    private List<ES1Person> persons = new ArrayList<ES1Person>();
    @SubContext(isMultiple=false, contextClass=ES1ReferenceFunction.class)
    public ES1ReferenceFunction referenceFunction;
    @SubContext(isMultiple=false, contextClass=ES1Representativeness.class)
    public ES1Representativeness representativeness;
    @SubContext(isMultiple=true, contextClass=ES1Source.class)
    private List<ES1Source> sources = new ArrayList<ES1Source>();
    @SubContext(isMultiple=false, contextClass=ES1Technology.class)
    public ES1Technology technology;
    @SubContext(isMultiple=false, contextClass=ES1TimePeriod.class)
    public ES1TimePeriod timePeriod;
    @SubContext(isMultiple=false, contextClass=ES1Validation.class)
    public ES1Validation validation;

    public List<ES1AllocationFactor> getAllocationFactors() {
        return this.allocations;
    }

    public List<ES1Exchange> getExchanges() {
        return this.exchanges;
    }

    public List<ES1Person> getPersons() {
        return this.persons;
    }

    public List<ES1Source> getSources() {
        return this.sources;
    }

    public boolean isProcess() {
        return this.dataSetInformation != null && this.dataSetInformation.type != null && (this.dataSetInformation.type == 1 || this.dataSetInformation.type == 2 || this.dataSetInformation.type == 5);
    }

    public ES1Person getPerson(Integer id) {
        ES1Person p = null;
        for (ES1Person pers : this.getPersons()) {
            if (pers.number == null || !pers.number.equals(id)) continue;
            p = pers;
            break;
        }
        return p;
    }

    public ES1Source getSource(Integer id) {
        ES1Source s = null;
        for (ES1Source source : this.getSources()) {
            if (source.number == null || !source.number.equals(id)) continue;
            s = source;
            break;
        }
        return s;
    }
}

