/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.ecospold2;

import java.util.ArrayList;
import java.util.List;
import org.openlca.olcatdb.ecospold2.ES2ClassificationRef;
import org.openlca.olcatdb.ecospold2.ES2Description;
import org.openlca.olcatdb.ecospold2.ES2ElementaryExchange;
import org.openlca.olcatdb.ecospold2.ES2Entry;
import org.openlca.olcatdb.ecospold2.ES2FileAttributes;
import org.openlca.olcatdb.ecospold2.ES2GeographyRef;
import org.openlca.olcatdb.ecospold2.ES2IntermediateExchange;
import org.openlca.olcatdb.ecospold2.ES2MacroEconomicScenario;
import org.openlca.olcatdb.ecospold2.ES2Parameter;
import org.openlca.olcatdb.ecospold2.ES2Publication;
import org.openlca.olcatdb.ecospold2.ES2Representativeness;
import org.openlca.olcatdb.ecospold2.ES2Review;
import org.openlca.olcatdb.ecospold2.ES2Technology;
import org.openlca.olcatdb.ecospold2.ES2TimePeriod;
import org.openlca.olcatdb.parsing.Context;
import org.openlca.olcatdb.parsing.ContextField;
import org.openlca.olcatdb.parsing.ContextObject;
import org.openlca.olcatdb.parsing.SubContext;

@Context(name="activityDataset", parentName="ecoSpold")
public class ES2Dataset
extends ContextObject {
    @ContextField(name="isChildDataSet", isAttribute=true, type=ContextField.Type.Boolean)
    public boolean isChildDataSet = false;
    @SubContext(contextClass=ES2Description.class)
    public ES2Description description;
    @SubContext(contextClass=ES2ClassificationRef.class, isMultiple=true)
    protected List<ES2ClassificationRef> classifications = new ArrayList<ES2ClassificationRef>();
    @SubContext(contextClass=ES2GeographyRef.class)
    public ES2GeographyRef geography;
    @SubContext(contextClass=ES2Technology.class)
    public ES2Technology technology;
    @SubContext(isMultiple=false, contextClass=ES2TimePeriod.class)
    public ES2TimePeriod timePeriod;
    @SubContext(contextClass=ES2MacroEconomicScenario.class)
    public ES2MacroEconomicScenario macroEconomicScenario;
    @SubContext(contextClass=ES2IntermediateExchange.class, isMultiple=true)
    protected List<ES2IntermediateExchange> intermediateExchanges = new ArrayList<ES2IntermediateExchange>();
    @SubContext(contextClass=ES2ElementaryExchange.class, isMultiple=true)
    private List<ES2ElementaryExchange> elementaryExchanges = new ArrayList<ES2ElementaryExchange>();
    @SubContext(contextClass=ES2Parameter.class, isMultiple=true)
    protected List<ES2Parameter> parameters = new ArrayList<ES2Parameter>();
    @SubContext(contextClass=ES2Representativeness.class)
    public ES2Representativeness representativeness;
    @SubContext(contextClass=ES2Review.class, isMultiple=true)
    protected List<ES2Review> reviews = new ArrayList<ES2Review>();
    @SubContext(contextClass=ES2Entry.class)
    public ES2Entry dataEntryBy;
    @SubContext(contextClass=ES2Publication.class)
    public ES2Publication publication;
    @SubContext(contextClass=ES2FileAttributes.class)
    public ES2FileAttributes fileAttributes;

    public List<ES2ClassificationRef> getClassifications() {
        return this.classifications;
    }

    public List<ES2IntermediateExchange> getIntermediateExchanges() {
        return this.intermediateExchanges;
    }

    public List<ES2ElementaryExchange> getElementaryExchanges() {
        return this.elementaryExchanges;
    }

    public List<ES2Parameter> getParameters() {
        return this.parameters;
    }

    public List<ES2Review> getReviews() {
        return this.reviews;
    }

    public boolean isMultiFunctional() {
        int outputCount = 0;
        for (ES2IntermediateExchange exchange : this.getIntermediateExchanges()) {
            if (exchange.outputGroup == null) continue;
            ++outputCount;
        }
        return outputCount > 1;
    }
}

