/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.ecospold2;

import java.util.ArrayList;
import java.util.List;
import org.openlca.olcatdb.ecospold2.ES2ChildDataset;
import org.openlca.olcatdb.ecospold2.ES2Dataset;
import org.openlca.olcatdb.parsing.Context;
import org.openlca.olcatdb.parsing.ContextObject;
import org.openlca.olcatdb.parsing.SubContext;

@Context(name="ecoSpold")
public class ES2EcoSpold
extends ContextObject {
    private boolean fitDatasets = false;
    @SubContext(isMultiple=true, contextClass=ES2Dataset.class)
    private List<ES2Dataset> datasets = new ArrayList<ES2Dataset>();
    @SubContext(isMultiple=true, contextClass=ES2ChildDataset.class)
    private List<ES2ChildDataset> childDatasets = new ArrayList<ES2ChildDataset>();

    public List<ES2Dataset> getDatasets() {
        if (!this.fitDatasets) {
            this.fitDataSets();
        }
        return this.datasets;
    }

    public ES2Dataset makeDataset() {
        ES2Dataset d = new ES2Dataset();
        this.datasets.add(d);
        return d;
    }

    private void fitDataSets() {
        ArrayList<ES2Dataset> es2Datasets = new ArrayList<ES2Dataset>();
        es2Datasets.addAll(this.datasets);
        for (ES2ChildDataset childDataset : this.childDatasets) {
            childDataset.isChildDataSet = true;
            es2Datasets.add(childDataset);
        }
        this.datasets.clear();
        this.datasets.addAll(es2Datasets);
        this.fitDatasets = true;
    }
}

