/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.ecospold2.masterdata;

import java.util.ArrayList;
import java.util.List;
import org.openlca.olcatdb.datatypes.LangString;
import org.openlca.olcatdb.ecospold2.masterdata.ES2Classification;
import org.openlca.olcatdb.parsing.Context;
import org.openlca.olcatdb.parsing.ContextField;
import org.openlca.olcatdb.parsing.ContextObject;
import org.openlca.olcatdb.parsing.SubContext;

@Context(name="classificationSystem", parentName="validClassificationSystems")
public class ES2ClassificationSystem
extends ContextObject {
    @ContextField(name="classificationSystem", parentName="validClassificationSystems", isAttribute=true, attributeName="type", isRequired=true, type=ContextField.Type.Integer)
    public int type = 1;
    @ContextField(name="classificationSystem", parentName="validClassificationSystems", isAttribute=true, attributeName="id", isRequired=true)
    public String id;
    @ContextField(name="name", parentName="classificationSystem", isMultiple=true, isRequired=true, type=ContextField.Type.MultiLangText)
    private List<LangString> name = new ArrayList<LangString>();
    @SubContext(contextClass=ES2Classification.class, isMultiple=true)
    private List<ES2Classification> classifications = new ArrayList<ES2Classification>();

    public List<LangString> getName() {
        return this.name;
    }

    public List<ES2Classification> getClassifications() {
        return this.classifications;
    }

    public ES2Classification forName(String name) {
        ES2Classification clazz = null;
        for (ES2Classification c : this.classifications) {
            if (!LangString.contains(c.getName(), name)) continue;
            clazz = c;
            break;
        }
        return clazz;
    }
}

