/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.ecospold2.masterdata;

import java.util.ArrayList;
import java.util.List;
import org.openlca.olcatdb.datatypes.LangString;
import org.openlca.olcatdb.ecospold2.masterdata.ES2Person;
import org.openlca.olcatdb.parsing.Context;
import org.openlca.olcatdb.parsing.ContextField;
import org.openlca.olcatdb.parsing.ContextObject;
import org.openlca.olcatdb.parsing.SubContext;

@Context(name="validPersons")
public class ES2PersonList
extends ContextObject {
    @ContextField(name="validPersons", attributeName="contextId", isAttribute=true, isRequired=true, length=36)
    public String contextId;
    @ContextField(name="validPersons", attributeName="majorRelease", isAttribute=true, isRequired=true, type=ContextField.Type.Integer)
    public int majorRelease = 1;
    @ContextField(name="validPersons", attributeName="minorRelease", isAttribute=true, isRequired=true, type=ContextField.Type.Integer)
    public int minorRelease = 0;
    @ContextField(name="contextName", parentName="validPersons", isRequired=true, length=80, isMultiple=true, type=ContextField.Type.MultiLangText)
    private List<LangString> contextNames = new ArrayList<LangString>();
    @SubContext(contextClass=ES2Person.class, isMultiple=true)
    private List<ES2Person> persons = new ArrayList<ES2Person>();

    public List<LangString> getContextNames() {
        return this.contextNames;
    }

    public List<ES2Person> getPersons() {
        return this.persons;
    }

    public ES2Person getPerson(String id) {
        ES2Person person = null;
        for (ES2Person p : this.persons) {
            if (id == null && p.id == null) {
                person = p;
                break;
            }
            if (id == null || p.id == null || !id.equals(p.id)) continue;
            person = p;
            break;
        }
        return person;
    }
}

