/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.ecospold2.masterdata;

import java.util.ArrayList;
import java.util.List;
import org.openlca.olcatdb.datatypes.LangString;
import org.openlca.olcatdb.ecospold2.masterdata.ES2Source;
import org.openlca.olcatdb.parsing.Context;
import org.openlca.olcatdb.parsing.ContextField;
import org.openlca.olcatdb.parsing.ContextObject;
import org.openlca.olcatdb.parsing.SubContext;

@Context(name="validSources")
public class ES2SourceList
extends ContextObject {
    @ContextField(name="validSources", attributeName="contextId", isAttribute=true, isRequired=true, length=36)
    public String contextId;
    @ContextField(name="validSources", attributeName="majorRelease", isAttribute=true, isRequired=true, type=ContextField.Type.Integer)
    public int majorRelease = 1;
    @ContextField(name="validSources", attributeName="minorRelease", isAttribute=true, isRequired=true, type=ContextField.Type.Integer)
    public int minorRelease = 0;
    @ContextField(name="contextName", parentName="validSources", isRequired=true, length=80, isMultiple=true, type=ContextField.Type.MultiLangText)
    private List<LangString> contextNames = new ArrayList<LangString>();
    @SubContext(contextClass=ES2Source.class, isMultiple=true)
    private List<ES2Source> sources = new ArrayList<ES2Source>();

    public List<LangString> getContextNames() {
        return this.contextNames;
    }

    public List<ES2Source> getSources() {
        return this.sources;
    }

    public boolean contains(String id) {
        boolean b = false;
        for (ES2Source s : this.sources) {
            if (s.id == null || !s.id.equals(id)) continue;
            b = true;
            break;
        }
        return b;
    }

    public ES2Source getSource(String id) {
        ES2Source source = null;
        for (ES2Source s : this.sources) {
            if (id == null && s.id == null) {
                source = s;
                break;
            }
            if (id == null || s.id == null || !id.equals(s.id)) continue;
            source = s;
            break;
        }
        return source;
    }
}

