/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.ilcd;

public enum ILCDDataSetType {
    Source("source data set"),
    Process("process data set"),
    Flow("flow data set"),
    FlowProperty("flow property data set"),
    UnitGroup("unit group data set"),
    Contact("contact data set"),
    LCIAMethod("LCIA method data set"),
    Other("other external file");

    private final String ilcdName;

    private ILCDDataSetType(String ilcdName) {
        this.ilcdName = ilcdName;
    }

    public String toString() {
        return this.ilcdName;
    }

    public static ILCDDataSetType forName(String type) {
        if (type != null) {
            for (ILCDDataSetType t : ILCDDataSetType.values()) {
                if (!t.ilcdName.equalsIgnoreCase(type)) continue;
                return t;
            }
        }
        return null;
    }
}

