/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.ilcd;

import java.util.ArrayList;
import java.util.List;
import org.openlca.olcatdb.datatypes.DataSetReference;
import org.openlca.olcatdb.datatypes.LangString;
import org.openlca.olcatdb.ilcd.ILCDAllocationFactor;
import org.openlca.olcatdb.parsing.Context;
import org.openlca.olcatdb.parsing.ContextField;
import org.openlca.olcatdb.parsing.ContextObject;
import org.openlca.olcatdb.parsing.SubContext;

@Context(name="exchange", parentName="exchanges")
public class ILCDExchange
extends ContextObject {
    @ContextField(name="exchange", parentName="exchanges", attributeName="dataSetInternalID", isAttribute=true, type=ContextField.Type.Integer)
    public Integer id;
    @ContextField(name="referenceToFlowDataSet", parentName="exchange", type=ContextField.Type.DataSetReference)
    public DataSetReference flowDataSet;
    @ContextField(name="location", parentName="exchange")
    public String location;
    @ContextField(name="functionType", parentName="exchange")
    public String functionType;
    @ContextField(name="exchangeDirection", parentName="exchange")
    public String direction;
    @ContextField(name="referenceToVariable", parentName="exchange")
    public String variableReference;
    @ContextField(name="meanAmount", parentName="exchange", type=ContextField.Type.Double)
    public Double meanAmount;
    @ContextField(name="resultingAmount", parentName="exchange", type=ContextField.Type.Double)
    public Double resultingAmount;
    @ContextField(name="minimumAmount", parentName="exchange", type=ContextField.Type.Double)
    public Double minimumAmount;
    @ContextField(name="maximumAmount", parentName="exchange", type=ContextField.Type.Double)
    public Double maximumAmount;
    @ContextField(name="uncertaintyDistributionType", parentName="exchange")
    public String uncertaintyDistribution;
    @ContextField(name="relativeStandardDeviation95In", parentName="exchange", type=ContextField.Type.Double)
    public Double relStdDeviation95In;
    @SubContext(contextClass=ILCDAllocationFactor.class, isMultiple=true)
    private List<ILCDAllocationFactor> allocationFactors = new ArrayList<ILCDAllocationFactor>();
    @ContextField(name="dataSourceType", parentName="exchange")
    public String dataSourceType;
    @ContextField(name="dataDerivationTypeStatus", parentName="exchange")
    public String dataDerivationType;
    @ContextField(name="referenceToDataSource", parentName="referencesToDataSource", isMultiple=true, type=ContextField.Type.DataSetReference)
    private List<DataSetReference> dataSources = new ArrayList<DataSetReference>();
    @ContextField(name="generalComment", parentName="exchange", isMultiple=true, type=ContextField.Type.MultiLangText)
    private List<LangString> comment = new ArrayList<LangString>();

    public List<ILCDAllocationFactor> getAllocationFactors() {
        return this.allocationFactors;
    }

    public List<DataSetReference> getDataSources() {
        return this.dataSources;
    }

    public List<LangString> getComment() {
        return this.comment;
    }

    public boolean isInput() {
        return this.direction != null && this.direction.equals("Input");
    }

    public String toString() {
        return "ILCDExchange [flowDataSet=" + this.flowDataSet + ", id=" + this.id + "]";
    }
}

