/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.ilcd;

import java.util.ArrayList;
import java.util.List;
import org.openlca.olcatdb.datatypes.DataSetReference;
import org.openlca.olcatdb.datatypes.LangString;
import org.openlca.olcatdb.ilcd.ILCDCompliance;
import org.openlca.olcatdb.ilcd.ILCDFlowDescription;
import org.openlca.olcatdb.ilcd.ILCDFlowEntry;
import org.openlca.olcatdb.ilcd.ILCDFlowPropertyValue;
import org.openlca.olcatdb.ilcd.ILCDFlowTechnology;
import org.openlca.olcatdb.ilcd.ILCDPublication;
import org.openlca.olcatdb.parsing.Context;
import org.openlca.olcatdb.parsing.ContextField;
import org.openlca.olcatdb.parsing.ContextObject;
import org.openlca.olcatdb.parsing.SubContext;

@Context(name="flowDataSet")
public class ILCDFlow
extends ContextObject {
    @SubContext(contextClass=ILCDFlowDescription.class)
    public ILCDFlowDescription description;
    @ContextField(name="referenceToReferenceFlowProperty", parentName="quantitativeReference", type=ContextField.Type.Integer)
    public Integer referenceFlowProperty;
    @ContextField(name="locationOfSupply", parentName="geography", isMultiple=true, type=ContextField.Type.MultiLangText)
    private List<LangString> location = new ArrayList<LangString>();
    @SubContext(contextClass=ILCDFlowTechnology.class)
    public ILCDFlowTechnology technology;
    @ContextField(name="typeOfDataSet", parentName="LCIMethod")
    public String type;
    @SubContext(contextClass=ILCDCompliance.class, isMultiple=true)
    private List<ILCDCompliance> complianceDeclarations = new ArrayList<ILCDCompliance>();
    @SubContext(contextClass=ILCDFlowEntry.class)
    public ILCDFlowEntry entry;
    @SubContext(contextClass=ILCDPublication.class)
    public ILCDPublication publication;
    @SubContext(contextClass=ILCDFlowPropertyValue.class, isMultiple=true)
    private List<ILCDFlowPropertyValue> flowPropertyValues = new ArrayList<ILCDFlowPropertyValue>();

    public List<LangString> getLocation() {
        return this.location;
    }

    public List<ILCDCompliance> getComplianceDeclarations() {
        return this.complianceDeclarations;
    }

    public List<ILCDFlowPropertyValue> getFlowPropertyValues() {
        return this.flowPropertyValues;
    }

    public DataSetReference getReferenceProperty() {
        DataSetReference ref = null;
        if (this.referenceFlowProperty != null) {
            for (ILCDFlowPropertyValue v : this.flowPropertyValues) {
                if (v.id == null || !v.id.equals(this.referenceFlowProperty)) continue;
                ref = v.flowPropertyDataSet;
            }
        }
        return ref;
    }

    public boolean isElementary() {
        boolean b = false;
        if (this.type != null) {
            b = this.type.equals("Elementary flow");
        }
        return b;
    }

    public boolean isWaste() {
        boolean b = false;
        if (this.type != null) {
            b = this.type.equals("Waste flow");
        }
        return b;
    }

    public boolean isProduct() {
        boolean b = false;
        if (this.type != null) {
            b = this.type.equals("Product flow");
        }
        return b;
    }
}

