/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.ilcd.resources;

import java.io.File;
import org.openlca.olcatdb.ResourceFolder;
import org.openlca.olcatdb.datatypes.DataSetReference;
import org.openlca.olcatdb.ilcd.ILCDDataSetType;

public class ILCDFolder
extends ResourceFolder {
    public ILCDFolder(File rootDir) {
        super(new File(rootDir, "ILCD"));
    }

    @Override
    public void createContent() {
        File folder = new File(this.rootDir, "schemas");
        this.extract("schemas", folder);
        folder = new File(this.rootDir, "stylesheets");
        this.extract("stylesheets", folder);
        folder = new File(this.rootDir, "META-INF");
        this.extract("metainf", folder);
        File dataDir = new File(this.rootDir, "ILCD");
        this.extract("data", dataDir);
        folder = new File(dataDir, "contacts");
        this.extract("contacts", folder);
        folder = new File(dataDir, "external_docs");
        this.extract("external_docs", folder);
        folder = new File(dataDir, "flowproperties");
        this.extract("flowproperties", folder);
        folder = new File(dataDir, "flows");
        if (!folder.exists()) {
            folder.mkdir();
        }
        if (!(folder = new File(dataDir, "processes")).exists()) {
            folder.mkdir();
        }
        folder = new File(dataDir, "sources");
        this.extract("sources", folder);
        folder = new File(dataDir, "unitgroups");
        this.extract("unitgroups", folder);
    }

    public File getContactDir() {
        File dataDir = new File(this.rootDir, "ILCD");
        return new File(dataDir, "contacts");
    }

    public File getDataDir() {
        return new File(this.rootDir, "ILCD");
    }

    public File getExternalDocDir() {
        File dataDir = new File(this.rootDir, "ILCD");
        return new File(dataDir, "external_docs");
    }

    public File getFlowDir() {
        File dataDir = new File(this.rootDir, "ILCD");
        return new File(dataDir, "flows");
    }

    public File getFlowPropDir() {
        File dataDir = new File(this.rootDir, "ILCD");
        return new File(dataDir, "flowproperties");
    }

    public File getProcessDir() {
        File dataDir = new File(this.rootDir, "ILCD");
        return new File(dataDir, "processes");
    }

    public File getSchemaDir() {
        return new File(this.rootDir, "schemas");
    }

    public File getSourceDir() {
        File dataDir = new File(this.rootDir, "ILCD");
        return new File(dataDir, "sources");
    }

    public File getStyleDir() {
        return new File(this.rootDir, "stylesheets");
    }

    public File getUnitGroupDir() {
        File dataDir = new File(this.rootDir, "ILCD");
        return new File(dataDir, "unitgroups");
    }

    public boolean exists(DataSetReference ref) {
        File f = this.file(ref);
        return f != null && f.exists();
    }

    public File file(DataSetReference ref) {
        ILCDDataSetType type;
        File file = null;
        if (ref.getType() != null && ref.getVersion() != null && ref.getRefObjectId() != null && (type = ILCDDataSetType.forName(ref.getType())) != null) {
            File lookUpFolder = null;
            switch (type) {
                case Contact: {
                    lookUpFolder = this.getContactDir();
                    break;
                }
                case Flow: {
                    lookUpFolder = this.getFlowDir();
                    break;
                }
                case FlowProperty: {
                    lookUpFolder = this.getFlowPropDir();
                    break;
                }
                case Process: {
                    lookUpFolder = this.getProcessDir();
                    break;
                }
                case Source: {
                    lookUpFolder = this.getSourceDir();
                    break;
                }
                case UnitGroup: {
                    lookUpFolder = this.getUnitGroupDir();
                    break;
                }
                default: {
                    lookUpFolder = this.getExternalDocDir();
                }
            }
            file = new File(lookUpFolder, ref.getRefObjectId() + ".xml");
        }
        return file;
    }
}

