/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.parsing;

import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openlca.olcatdb.datatypes.DataSetReference;
import org.openlca.olcatdb.datatypes.ExtendedUrl;
import org.openlca.olcatdb.datatypes.LangString;
import org.openlca.olcatdb.datatypes.NamedString;
import org.openlca.olcatdb.datatypes.TextAndImage;
import org.openlca.olcatdb.parsing.Context;
import org.openlca.olcatdb.parsing.ContextField;
import org.openlca.olcatdb.parsing.SubContext;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlContextParser {
    private SAXParser parser;
    private Class<?> contextRootClass;

    public XmlContextParser() {
        try {
            this.parser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public <T> T getContext(Class<T> contextRootClass, InputStream is) {
        if (contextRootClass == null || !contextRootClass.isAnnotationPresent(Context.class)) {
            throw new IllegalArgumentException("The context root class must not be null and must be annotated with @Context");
        }
        this.contextRootClass = contextRootClass;
        Object t = null;
        try {
            XmlEventHandler xmlEventHandler = new XmlEventHandler();
            this.parser.parse(is, xmlEventHandler);
            t = xmlEventHandler.rootContextObject;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)t;
    }

    private class TextAndImageTray {
        private ContextField contextField;
        private TextAndImage textAndImage;
        private LangString text;
        private NamedString variable;
        private ExtendedUrl imageUrl;

        private TextAndImageTray() {
        }

        public void put(ContextField contextField, TextAndImage textAndImage) {
            this.contextField = contextField;
            this.textAndImage = textAndImage;
        }

        public void prepareTextEntry(String index, String langCode) {
            LangString langString = new LangString();
            langString.setLangCode(langCode);
            if (index != null) {
                try {
                    langString.setIndex(Integer.parseInt(index));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.text = langString;
        }

        public void prepareVariableEntry(String name) {
            NamedString var = new NamedString();
            var.setName(name);
            this.variable = var;
        }

        public void prepareImageEntry(String index) {
            ExtendedUrl url = new ExtendedUrl();
            if (index != null) {
                try {
                    url.setIndex(Integer.parseInt(index));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.imageUrl = url;
        }

        public void finishEntry(String value) {
            if (this.textAndImage != null) {
                if (this.text != null) {
                    this.text.setValue(value);
                    this.textAndImage.getText().add(this.text);
                    this.text = null;
                } else if (this.variable != null) {
                    this.variable.setValue(value);
                    this.textAndImage.getVariables().add(this.variable);
                    this.variable = null;
                } else if (this.imageUrl != null) {
                    this.imageUrl.setUrl(value);
                    this.textAndImage.getImages().add(this.imageUrl);
                    this.imageUrl = null;
                }
            }
        }

        public ContextField getContextField() {
            return this.contextField;
        }

        public boolean hasPreparedEntry() {
            return this.textAndImage != null && (this.text != null || this.variable != null || this.imageUrl != null);
        }

        public boolean isEmpty() {
            return this.textAndImage == null;
        }

        public void clear() {
            this.contextField = null;
            this.textAndImage = null;
            this.imageUrl = null;
            this.text = null;
            this.variable = null;
        }
    }

    private class DataSetReferenceTray {
        private DataSetReference dataSetReference;
        private ContextField contextField;
        private String currentLangCode;
        private boolean subRefOpen = false;
        private boolean descrOpen = false;

        private DataSetReferenceTray() {
        }

        public void put(DataSetReference dataSetReference, ContextField contextField) {
            this.dataSetReference = dataSetReference;
            this.contextField = contextField;
        }

        public boolean isEmpty() {
            return this.dataSetReference == null;
        }

        public String getCurrentLangCode() {
            return this.currentLangCode;
        }

        public void setCurrentLangCode(String currentLangCode) {
            this.currentLangCode = currentLangCode;
        }

        public boolean isSubRefOpen() {
            return this.subRefOpen;
        }

        public void setSubRefOpen(boolean subRefOpen) {
            this.subRefOpen = subRefOpen;
        }

        public boolean isDescrOpen() {
            return this.descrOpen;
        }

        public void setDescrOpen(boolean descrOpen) {
            this.descrOpen = descrOpen;
        }

        public DataSetReference getDataSetReference() {
            return this.dataSetReference;
        }

        public ContextField getContextField() {
            return this.contextField;
        }

        public void clear() {
            this.dataSetReference = null;
            this.contextField = null;
            this.currentLangCode = null;
            this.subRefOpen = false;
            this.descrOpen = false;
        }
    }

    private class FieldElementTray {
        private String langCode;
        private Field field;

        private FieldElementTray() {
        }

        public void put(Field field, String langCode) {
            this.field = field;
            this.langCode = langCode;
        }

        public Field getField() {
            return this.field;
        }

        public String getLangCode() {
            return this.langCode;
        }

        public boolean isEmpty() {
            return this.field == null;
        }

        public void clear() {
            this.field = null;
            this.langCode = null;
        }
    }

    private class XmlEventHandler<T>
    extends DefaultHandler {
        private Stack<Object> contextStack = new Stack();
        private Stack<Field[]> contextFieldStack = new Stack();
        private Stack<String> eNames = new Stack();
        private FieldElementTray fieldElementTray = new FieldElementTray();
        private DataSetReferenceTray dataSetReferenceTray = new DataSetReferenceTray();
        private StringBuffer characters;
        private TextAndImageTray textAndImageTray = new TextAndImageTray();
        private T rootContextObject = null;

        private XmlEventHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qualName, Attributes attributes) throws SAXException {
            String eName = this.eName(localName, qualName);
            String parentEName = this.eNames.isEmpty() ? "" : this.eNames.peek();
            this.eNames.push(eName);
            this.characters = new StringBuffer(100);
            if (this.contextStack.isEmpty()) {
                Context rootContext = XmlContextParser.this.contextRootClass.getAnnotation(Context.class);
                if (eName.equals(rootContext.name()) && parentEName.equals(rootContext.parentName())) {
                    try {
                        Object context = XmlContextParser.this.contextRootClass.newInstance();
                        Field[] fields = context.getClass().getDeclaredFields();
                        this.setAttributeValues(context, fields, eName, parentEName, attributes);
                        this.rootContextObject = context;
                        this.contextStack.push(context);
                        this.contextFieldStack.push(fields);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                if (!this.dataSetReferenceTray.isEmpty()) {
                    this.dataSetReferenceTray.setCurrentLangCode(attributes.getValue("xml:lang"));
                    if (eName.equals("subReference")) {
                        this.dataSetReferenceTray.setSubRefOpen(true);
                    } else if (eName.equals("shortDescription")) {
                        this.dataSetReferenceTray.setDescrOpen(true);
                    }
                }
                if (!this.textAndImageTray.isEmpty()) {
                    String index;
                    if (eName.equals("text")) {
                        index = attributes.getValue("index");
                        String langCode = attributes.getValue("xml:lang");
                        this.textAndImageTray.prepareTextEntry(index, langCode);
                    } else if (eName.equals("imageUrl")) {
                        index = attributes.getValue("index");
                        this.textAndImageTray.prepareImageEntry(index);
                    } else if (eName.equals("variable")) {
                        String _name = attributes.getValue("name");
                        this.textAndImageTray.prepareVariableEntry(_name);
                    }
                }
                Object contextObject = this.contextStack.peek();
                Field[] fields = this.contextFieldStack.peek();
                this.setAttributeValues(contextObject, fields, eName, parentEName, attributes);
                for (Field f : fields) {
                    SubContext subContext;
                    Class<?> clazz;
                    Context context;
                    if (f.isAnnotationPresent(ContextField.class)) {
                        ContextField contextField = f.getAnnotation(ContextField.class);
                        if (!contextField.name().equals(eName) || !contextField.parentName().equals(parentEName) && !contextField.parentNonStrict() || contextField.isAttribute()) continue;
                        if (contextField.type() != ContextField.Type.DataSetReference && contextField.type() != ContextField.Type.TextAndImage) {
                            this.fieldElementTray.put(f, attributes.getValue("xml:lang"));
                            continue;
                        }
                        if (contextField.type() == ContextField.Type.TextAndImage) {
                            TextAndImage textAndImage = new TextAndImage();
                            this.textAndImageTray.put(contextField, textAndImage);
                            try {
                                f.setAccessible(true);
                                f.set(contextObject, textAndImage);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        if (contextField.type() != ContextField.Type.DataSetReference) continue;
                        DataSetReference dataSetReference = new DataSetReference();
                        dataSetReference.setRefObjectId(attributes.getValue("refObjectId"));
                        dataSetReference.setType(attributes.getValue("type"));
                        dataSetReference.setUri(attributes.getValue("uri"));
                        dataSetReference.setVersion(attributes.getValue("version"));
                        try {
                            f.setAccessible(true);
                            if (!contextField.isMultiple()) {
                                f.set(contextObject, dataSetReference);
                            } else {
                                Object collectionObject = f.get(contextObject);
                                if (collectionObject != null && collectionObject instanceof Collection) {
                                    ((Collection)collectionObject).add(dataSetReference);
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        this.dataSetReferenceTray.put(dataSetReference, contextField);
                        continue;
                    }
                    if (!f.isAnnotationPresent(SubContext.class) || !(context = (clazz = (subContext = f.getAnnotation(SubContext.class)).contextClass()).getAnnotation(Context.class)).name().equals(eName) || !context.parentName().equals(parentEName) && !context.parentNonStrict()) continue;
                    try {
                        Object subContextObject = clazz.newInstance();
                        Field[] subFields = subContextObject.getClass().getDeclaredFields();
                        Field[] superFields = subContextObject.getClass().getSuperclass().getDeclaredFields();
                        int length = subFields.length + superFields.length;
                        Field[] subContextFields = new Field[length];
                        int i = 0;
                        while (i < length) {
                            int j = 0;
                            while (j < subFields.length) {
                                subContextFields[i] = subFields[j];
                                ++j;
                                ++i;
                            }
                            j = 0;
                            while (j < superFields.length) {
                                subContextFields[i] = superFields[j];
                                ++j;
                                ++i;
                            }
                        }
                        this.setAttributeValues(subContextObject, subContextFields, eName, parentEName, attributes);
                        this.contextStack.push(subContextObject);
                        this.contextFieldStack.push(subContextFields);
                        for (Field subContextField : subContextFields) {
                            ContextField contextField;
                            if (!subContextField.isAnnotationPresent(ContextField.class) || !(contextField = subContextField.getAnnotation(ContextField.class)).name().equals(eName) || !contextField.parentName().equals(parentEName) && !contextField.parentNonStrict() || contextField.isAttribute()) continue;
                            this.fieldElementTray.put(subContextField, attributes.getValue("xml:lang"));
                        }
                        f.setAccessible(true);
                        if (!subContext.isMultiple()) {
                            f.set(contextObject, subContextObject);
                            continue;
                        }
                        Object collectionObject = f.get(contextObject);
                        if (collectionObject == null || !(collectionObject instanceof Collection)) continue;
                        ((Collection)collectionObject).add(subContextObject);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.characters != null) {
                this.characters.append(new String(ch, start, length));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qualName) throws SAXException {
            ContextField contextField;
            Context context;
            Object o;
            String value = null;
            if (this.characters != null) {
                value = this.characters.toString();
                this.characters = null;
            }
            if (!this.fieldElementTray.isEmpty() && value != null) {
                Object contextObject = this.contextStack.peek();
                if (contextObject != null) {
                    Field field = this.fieldElementTray.getField();
                    ContextField contextField2 = field.getAnnotation(ContextField.class);
                    if (field.getDeclaringClass().equals(contextObject.getClass())) {
                        this.setFieldValue(contextObject, field, contextField2, value, this.fieldElementTray.getLangCode());
                    }
                }
                this.fieldElementTray.clear();
            }
            if (!this.dataSetReferenceTray.isEmpty() && value != null && value.length() > 0) {
                if (this.dataSetReferenceTray.isDescrOpen()) {
                    LangString descr = null;
                    descr = this.dataSetReferenceTray.getCurrentLangCode() != null ? new LangString(this.dataSetReferenceTray.getCurrentLangCode(), value) : new LangString(value);
                    DataSetReference dRef = this.dataSetReferenceTray.getDataSetReference();
                    dRef.getDescription().add(descr);
                } else if (this.dataSetReferenceTray.isSubRefOpen()) {
                    DataSetReference dRef = this.dataSetReferenceTray.getDataSetReference();
                    dRef.getSubReferences().add(value);
                }
            }
            if (!this.textAndImageTray.isEmpty() && this.textAndImageTray.hasPreparedEntry() && value != null) {
                this.textAndImageTray.finishEntry(value);
            }
            String eName = this.eName(localName, qualName);
            if (!this.contextStack.isEmpty() && (o = this.contextStack.peek()) != null && (context = o.getClass().getAnnotation(Context.class)).name().equals(eName)) {
                this.contextStack.pop();
                this.contextFieldStack.pop();
            }
            if (!this.dataSetReferenceTray.isEmpty()) {
                contextField = this.dataSetReferenceTray.getContextField();
                if (contextField.name().equals(eName)) {
                    this.dataSetReferenceTray.clear();
                } else {
                    this.dataSetReferenceTray.setCurrentLangCode(null);
                    this.dataSetReferenceTray.setDescrOpen(false);
                    this.dataSetReferenceTray.setSubRefOpen(false);
                }
            }
            if (!this.textAndImageTray.isEmpty() && (contextField = this.textAndImageTray.getContextField()) != null && contextField.name().equals(eName)) {
                this.textAndImageTray.clear();
            }
            this.eNames.pop();
        }

        private void setAttributeValues(Object contextObject, Field[] fields, String elementName, String parentElementName, Attributes attributes) {
            for (Field field : fields) {
                String v;
                ContextField contextField;
                if (!field.isAnnotationPresent(ContextField.class) || !(contextField = field.getAnnotation(ContextField.class)).isAttribute() || !contextField.name().equals(elementName) || !contextField.parentName().equals(parentElementName) && !contextField.parentNonStrict() || (v = attributes.getValue(contextField.attributeName())) == null) continue;
                this.setFieldValue(contextObject, field, contextField, v, null);
            }
        }

        private void setFieldValue(Object contextObject, Field field, ContextField contextField, String stringValue, String langCode) {
            try {
                field.setAccessible(true);
                Object value = null;
                String string = stringValue.trim();
                switch (contextField.type()) {
                    case Text: {
                        value = new String(string);
                        break;
                    }
                    case MultiLangText: {
                        value = langCode == null ? new LangString(string) : new LangString(langCode, string);
                        break;
                    }
                    case Boolean: {
                        boolean b = string.equalsIgnoreCase("true") || string.equals("1");
                        value = b;
                        break;
                    }
                    case Double: {
                        value = Double.parseDouble(string);
                        break;
                    }
                    case Integer: {
                        value = Integer.parseInt(string);
                    }
                }
                if (!contextField.isMultiple()) {
                    field.set(contextObject, value);
                } else {
                    Object collectionObject = field.get(contextObject);
                    if (collectionObject != null && collectionObject instanceof Collection) {
                        ((Collection)collectionObject).add(value);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private String eName(String localName, String qName) {
            String eName = "";
            if (localName != null && localName.length() > 0) {
                eName = localName;
            } else if (qName != null && qName.length() > 0) {
                int pos = qName.indexOf(58);
                eName = pos != -1 ? qName.substring(pos + 1) : qName;
            }
            return eName;
        }
    }
}

