/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openlca.olcatdb.swing.Browser;

public class AboutPanel
extends JPanel {
    private static final long serialVersionUID = 7672736187363120541L;

    public AboutPanel() {
        super(new BorderLayout());
        this.init();
    }

    private void init() {
        this.setBackground(Color.WHITE);
        JPanel logoPanel = new JPanel(new GridBagLayout());
        logoPanel.setBackground(Color.WHITE);
        this.add((Component)logoPanel, "North");
        GridBagConstraints grid = null;
        int row = 0;
        JLabel logo = new JLabel();
        logo.setIcon(new ImageIcon(this.getClass().getResource("logo.jpg")));
        grid = new GridBagConstraints();
        grid.gridy = row;
        grid.insets = new Insets(0, 10, 0, 10);
        grid.gridwidth = 4;
        logoPanel.add((Component)logo, grid);
        JEditorPane pane = new JEditorPane();
        pane.setEditable(false);
        try {
            pane.setPage(this.getClass().getResource("about.html"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.add((Component)new JScrollPane(pane), "Center");
        pane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                try {
                    URL url;
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (url = e.getURL()) != null) {
                        Browser.open(url.toURI());
                    }
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    JOptionPane.showMessageDialog(AboutPanel.this, "Cannot open referenced file.", "Error", 0);
                }
            }
        });
    }
}

