/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.apache.batik.util.gui.xmleditor.XMLEditorKit;
import org.openlca.olcatdb.ResourceFolder;
import org.openlca.olcatdb.conversion.Conversion;
import org.openlca.olcatdb.conversion.ConversionDispatch;
import org.openlca.olcatdb.conversion.Validation;
import org.openlca.olcatdb.conversion.XMLProcessFormat;
import org.openlca.olcatdb.conversion.es2tocsv.ES2DatasetScanner;
import org.openlca.olcatdb.database.ElemFlowMap;
import org.openlca.olcatdb.swing.Browser;
import org.openlca.olcatdb.swing.ConversionWindow;
import org.openlca.olcatdb.swing.Image;
import org.openlca.olcatdb.swing.ProgressDialog;

public class ConversionPanel
extends JPanel {
    private static final long serialVersionUID = 5389417304119100396L;
    private JTextField sourceFileText;
    private JTextField targetDirText;
    private File targetDirectory;
    private File sourceFile;
    private JComboBox targetFormatCombo;
    private JCheckBox csvSplitCheckBox;
    private JCheckBox isProxyCheckBox;
    private JEditorPane outputPane;
    private JButton runButton;
    private ResourceFolder lastResult;
    private List<JButton> resultOptions = new ArrayList<JButton>();
    private String lang = "en";
    private JTextField mdText;
    private JLabel mdLabel;
    private JButton mdButton;
    private File mdFile = null;
    private JLabel langJLabel;
    private JLabel csvCheckBoxLabel;
    private JLabel isProxyCheckBoxLabel;
    private JComboBox langComboBox;
    private JButton scanLangButton;
    private JPanel langPanel;
    private static ConversionPanel instance = null;
    private JButton validationButton;

    private ConversionPanel() {
        super(new BorderLayout());
        this.init();
        this.setES2Fields(false);
    }

    public static ConversionPanel getInstance() {
        if (instance == null) {
            instance = new ConversionPanel();
        }
        return instance;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(File sourceFile) {
        this.sourceFile = sourceFile;
    }

    private void init() {
        this.setBackground(Color.WHITE);
        JPanel configPanel = new JPanel(new GridBagLayout());
        configPanel.setBackground(Color.WHITE);
        this.add((Component)configPanel, "North");
        GridBagConstraints grid = null;
        int row = 0;
        JLabel logo = new JLabel();
        logo.setIcon(new ImageIcon(this.getClass().getResource("logo.jpg")));
        grid = new GridBagConstraints();
        grid.gridy = row++;
        grid.insets = new Insets(0, 10, 0, 10);
        grid.gridwidth = 4;
        configPanel.add((Component)logo, grid);
        JLabel sourceLabel = new JLabel("Source:");
        grid = new GridBagConstraints();
        grid.gridy = row;
        grid.anchor = 21;
        grid.insets = new Insets(5, 5, 5, 5);
        configPanel.add((Component)sourceLabel, grid);
        this.sourceFileText = new JTextField();
        this.sourceFileText.setEditable(false);
        this.sourceFileText.setPreferredSize(new Dimension(300, 28));
        this.sourceFileText.setMinimumSize(new Dimension(300, 28));
        grid = new GridBagConstraints();
        grid.gridy = row;
        grid.insets = new Insets(5, 5, 5, 5);
        configPanel.add((Component)this.sourceFileText, grid);
        JButton sourceBrowseButton = new JButton();
        sourceBrowseButton.setIcon(Image.makeIcon("folder.png"));
        grid = new GridBagConstraints();
        grid.gridy = row++;
        grid.insets = new Insets(5, 5, 5, 5);
        configPanel.add((Component)sourceBrowseButton, grid);
        sourceBrowseButton.addActionListener(new SourceFileSelection());
        JLabel targetLabel = new JLabel("Target:");
        grid = new GridBagConstraints();
        grid.gridy = row;
        grid.anchor = 21;
        grid.insets = new Insets(5, 5, 5, 5);
        configPanel.add((Component)targetLabel, grid);
        this.targetDirText = new JTextField();
        this.targetDirText.setEditable(false);
        this.targetDirText.setPreferredSize(new Dimension(300, 28));
        this.targetDirText.setMinimumSize(new Dimension(300, 28));
        grid = new GridBagConstraints();
        grid.gridy = row;
        grid.insets = new Insets(5, 5, 5, 5);
        configPanel.add((Component)this.targetDirText, grid);
        JButton targetBrowseButton = new JButton();
        targetBrowseButton.setIcon(Image.makeIcon("folder.png"));
        grid = new GridBagConstraints();
        grid.gridy = row++;
        grid.anchor = 21;
        grid.insets = new Insets(5, 5, 5, 5);
        configPanel.add((Component)targetBrowseButton, grid);
        targetBrowseButton.addActionListener(new TargetDirSelection());
        this.mdLabel = new JLabel("Master data:");
        grid = new GridBagConstraints();
        grid.gridy = row;
        grid.anchor = 21;
        grid.insets = new Insets(5, 5, 5, 5);
        configPanel.add((Component)this.mdLabel, grid);
        this.mdText = new JTextField();
        this.mdText.setEditable(false);
        this.mdText.setPreferredSize(new Dimension(300, 28));
        this.mdText.setMinimumSize(new Dimension(300, 28));
        grid = new GridBagConstraints();
        grid.gridy = row;
        grid.insets = new Insets(5, 5, 5, 5);
        configPanel.add((Component)this.mdText, grid);
        this.mdButton = new JButton();
        this.mdButton.setIcon(Image.makeIcon("folder.png"));
        grid = new GridBagConstraints();
        grid.gridy = row++;
        grid.insets = new Insets(5, 5, 5, 5);
        configPanel.add((Component)this.mdButton, grid);
        ArrayList<String> mdFilterList = new ArrayList<String>();
        mdFilterList.add(".zip");
        this.mdButton.addActionListener(new MasterDataFileSelection());
        this.langJLabel = new JLabel("Preferred language:");
        grid = new GridBagConstraints();
        grid.gridy = row;
        grid.anchor = 21;
        grid.insets = new Insets(5, 5, 5, 5);
        configPanel.add((Component)this.langJLabel, grid);
        this.langPanel = new JPanel();
        this.langPanel.setBackground(Color.WHITE);
        this.langPanel.setLayout(new FlowLayout());
        grid = new GridBagConstraints();
        grid.gridy = row++;
        grid.anchor = 21;
        grid.insets = new Insets(5, 5, 5, 5);
        configPanel.add((Component)this.langPanel, grid);
        this.langComboBox = new JComboBox();
        this.langComboBox.setPreferredSize(new Dimension(100, 28));
        this.langComboBox.addItem("en (default)");
        this.langPanel.add(this.langComboBox);
        this.langComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                String item = (String)String.class.cast(ConversionPanel.this.langComboBox.getSelectedItem());
                if (item != null) {
                    if (item.equals("en (default)")) {
                        ConversionPanel.this.lang = "en";
                    } else {
                        ConversionPanel.this.lang = item;
                    }
                }
            }
        });
        this.scanLangButton = new JButton("Scan languages");
        this.langPanel.add(this.scanLangButton);
        this.scanLangButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ES2DatasetScanner scanner = new ES2DatasetScanner(ES2DatasetScanner.ScanMode.LANG, ConversionPanel.this.sourceFile);
                ProgressDialog dialog = new ProgressDialog("Scan languages ...", ConversionPanel.this, scanner);
                Thread thread = new Thread(scanner);
                thread.start();
                dialog.setLocationRelativeTo(ConversionPanel.this);
                dialog.setVisible(true);
                try {
                    thread.join();
                    if (scanner.getLangs().size() > 0) {
                        ConversionPanel.this.langComboBox.removeAllItems();
                    }
                    for (String s : scanner.getLangs()) {
                        if (s.equals("")) continue;
                        ConversionPanel.this.langComboBox.addItem(s);
                    }
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
            }
        });
        this.csvCheckBoxLabel = new JLabel("Split into separate files:");
        grid = new GridBagConstraints();
        grid.gridy = ++row;
        grid.anchor = 21;
        grid.insets = new Insets(5, 5, 5, 5);
        configPanel.add((Component)this.csvCheckBoxLabel, grid);
        this.csvSplitCheckBox = new JCheckBox();
        configPanel.add((Component)this.csvSplitCheckBox, grid);
        this.isProxyCheckBoxLabel = new JLabel("Use proxies in mappings");
        grid = new GridBagConstraints();
        grid.gridy = row++;
        grid.anchor = 21;
        grid.insets = new Insets(5, 5, 5, 5);
        configPanel.add((Component)this.isProxyCheckBoxLabel, grid);
        this.isProxyCheckBox = new JCheckBox();
        configPanel.add((Component)this.isProxyCheckBox, grid);
        JPanel runPanel = new JPanel(new FlowLayout());
        runPanel.setBackground(Color.WHITE);
        grid = new GridBagConstraints();
        grid.gridy = row;
        grid.gridwidth = 4;
        grid.insets = new Insets(0, 5, 5, 5);
        configPanel.add((Component)runPanel, grid);
        this.targetFormatCombo = new JComboBox();
        this.targetFormatCombo.setPreferredSize(new Dimension(160, 28));
        for (XMLProcessFormat format : XMLProcessFormat.values()) {
            this.targetFormatCombo.addItem(format);
        }
        runPanel.add(this.targetFormatCombo);
        this.targetFormatCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (ConversionPanel.this.targetFormatCombo.getSelectedItem() == XMLProcessFormat.CSV) {
                    ConversionPanel.this.setES2Fields(true);
                } else {
                    ConversionPanel.this.setES2Fields(false);
                }
            }
        });
        this.runButton = new JButton();
        this.runButton.setIcon(Image.makeIcon("run.png"));
        this.runButton.setDisabledIcon(Image.makeIcon("run_dis.png"));
        this.runButton.setEnabled(false);
        runPanel.add((Component)this.runButton, grid);
        this.runButton.addActionListener(new RunAction());
        JPanel browserPanel = new JPanel(new BorderLayout());
        this.add((Component)browserPanel, "Center");
        browserPanel.setBackground(Color.WHITE);
        JPanel buttonPanel = this.buttonPanel();
        browserPanel.add((Component)buttonPanel, "North");
        this.editorPane();
        browserPanel.add((Component)new JScrollPane(this.outputPane), "Center");
    }

    private void setES2Fields(final boolean visible) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (visible) {
                    ConversionWindow.getInstance().setSize(600, 670);
                    ConversionWindow.getInstance().getMenuPanel().getComponent(1).setVisible(visible);
                } else {
                    ConversionWindow.getInstance().setSize(600, 600);
                    ConversionWindow.getInstance().getMenuPanel().getComponent(1).setVisible(visible);
                }
            }
        });
        this.langJLabel.setVisible(visible);
        this.langPanel.setVisible(visible);
        this.csvSplitCheckBox.setVisible(visible);
        this.csvCheckBoxLabel.setVisible(visible);
        this.isProxyCheckBox.setVisible(!visible);
        this.isProxyCheckBoxLabel.setVisible(!visible);
        this.mdButton.setVisible(false);
        this.mdLabel.setVisible(false);
        this.mdText.setVisible(false);
    }

    private void editorPane() {
        this.outputPane = new JEditorPane();
        this.outputPane.setEditorKitForContentType("text/xml", new XMLEditorKit());
        try {
            this.outputPane.setPage(this.getClass().getResource("welcome.html"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.outputPane.setEditable(false);
        this.outputPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                try {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        URL url = e.getURL();
                        if (url == null) {
                            File f = new File(e.getDescription());
                            if (!f.exists()) {
                                throw new RuntimeException("Unexpectedly file not found from hyperlinkevent: " + e + ", desc: " + e.getDescription());
                            }
                            ConversionPanel.this.outputPane.setPage(f.toURI().toURL());
                            ConversionPanel.this.showCSVOrXML(f.getAbsolutePath());
                        }
                        if (url != null) {
                            if (url.toString().startsWith("http")) {
                                Browser.open(url.toURI());
                            } else {
                                String file = e.getURL().getFile();
                                ConversionPanel.this.outputPane.setPage(e.getURL());
                                ConversionPanel.this.showCSVOrXML(file);
                            }
                        }
                    }
                }
                catch (Exception exc) {
                    JOptionPane.showMessageDialog(ConversionPanel.this, "Cannot open referenced file.", "Error", 0);
                }
            }
        });
    }

    protected void showCSVOrXML(String file) throws BadLocationException {
        if (file.toLowerCase().endsWith(".xml") || file.toLowerCase().endsWith(".csv")) {
            Document doc = this.outputPane.getDocument();
            String text = doc.getText(doc.getStartPosition().getOffset(), doc.getEndPosition().getOffset());
            this.outputPane.setContentType("text/xml");
            this.outputPane.setText(text);
        }
    }

    private JPanel buttonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout(0, 2, 5));
        buttonPanel.setBackground(Color.WHITE);
        JButton homeButton = new JButton();
        homeButton.setIcon(Image.makeIcon("home.png"));
        homeButton.setDisabledIcon(Image.makeIcon("home_dis.png"));
        homeButton.setToolTipText("Conversion index");
        homeButton.setEnabled(false);
        buttonPanel.add(homeButton);
        homeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File indexFile;
                if (ConversionPanel.this.lastResult != null && (indexFile = ConversionPanel.this.lastResult.getIndexFile()) != null) {
                    try {
                        ConversionPanel.this.outputPane.setPage(indexFile.toURI().toURL());
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(ConversionPanel.this, ex.getMessage(), "Error", 0);
                    }
                }
            }
        });
        this.resultOptions.add(homeButton);
        this.validationButton = new JButton();
        this.validationButton.setIcon(Image.makeIcon("validation.png"));
        this.validationButton.setDisabledIcon(Image.makeIcon("validation_dis.png"));
        this.validationButton.setEnabled(false);
        this.validationButton.setToolTipText("Validate output");
        buttonPanel.add(this.validationButton);
        this.validationButton.addActionListener(new ValidationAction());
        this.resultOptions.add(this.validationButton);
        JButton browserButton = new JButton();
        browserButton.setIcon(Image.makeIcon("browser.png"));
        browserButton.setDisabledIcon(Image.makeIcon("browser_dis.png"));
        browserButton.setEnabled(false);
        browserButton.setToolTipText("Open in browser");
        buttonPanel.add(browserButton);
        browserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File indexFile;
                if (ConversionPanel.this.lastResult != null && (indexFile = ConversionPanel.this.lastResult.getIndexFile()) != null) {
                    try {
                        Browser.open(indexFile.toURI());
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(ConversionPanel.this, ex.getMessage(), "Error", 0);
                    }
                }
            }
        });
        this.resultOptions.add(browserButton);
        JButton folderButton = new JButton();
        folderButton.setIcon(Image.makeIcon("file_system.png"));
        folderButton.setDisabledIcon(Image.makeIcon("file_system_dis.png"));
        folderButton.setEnabled(false);
        folderButton.setToolTipText("Open in file explorer");
        buttonPanel.add(folderButton);
        folderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConversionPanel.this.lastResult != null && ConversionPanel.this.lastResult.getRootDir() != null && ConversionPanel.this.lastResult.getRootDir().exists()) {
                    Browser.open(ConversionPanel.this.lastResult.getRootDir().toURI());
                }
            }
        });
        this.resultOptions.add(folderButton);
        return buttonPanel;
    }

    void setResourceFolder(ResourceFolder folder) {
        File indexFile;
        this.lastResult = folder;
        if (folder != null && (indexFile = folder.getIndexFile()) != null) {
            try {
                Document doc = this.outputPane.getDocument();
                doc.putProperty("stream", null);
                this.outputPane.setPage(indexFile.toURI().toURL());
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
            }
        }
        for (JButton b : this.resultOptions) {
            b.setEnabled(folder != null);
        }
    }

    void validationPerformed() {
        File logFile;
        if (this.lastResult != null && (logFile = this.lastResult.getValidationLog()) != null && logFile.exists()) {
            try {
                this.outputPane.setPage(logFile.toURI().toURL());
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
            }
        }
    }

    private void checkCanRun() {
        boolean canRun = false;
        boolean bl = canRun = this.targetDirectory != null && this.targetDirectory.isDirectory();
        if (canRun) {
            boolean bl2 = canRun = this.sourceFile != null && this.sourceFile.isFile();
        }
        if (this.runButton != null) {
            this.runButton.setEnabled(canRun);
        }
    }

    JFrame getFrame(Container container) {
        if (container instanceof JFrame) {
            return (JFrame)container;
        }
        if (container.getParent() != null) {
            return this.getFrame(container.getParent());
        }
        return null;
    }

    private class ValidationAction
    implements ActionListener {
        private ValidationAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (ConversionPanel.this.lastResult == null) {
                    JOptionPane.showMessageDialog(ConversionPanel.this, "Cannot run validation", "Error", 0);
                } else {
                    Validation validation = new Validation(ConversionPanel.this.lastResult);
                    ProgressDialog dialog = new ProgressDialog("Run validation", ConversionPanel.this, validation);
                    Thread thread = new Thread(validation);
                    thread.start();
                    dialog.setLocationRelativeTo(ConversionPanel.this);
                    dialog.setVisible(true);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(ConversionPanel.this, ex.getMessage(), "Error", 0);
            }
        }
    }

    private class RunAction
    implements ActionListener {
        private XMLProcessFormat targetFormat;

        private RunAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ElemFlowMap.setIsProxy(ConversionPanel.this.isProxyCheckBox.isSelected());
                this.targetFormat = (XMLProcessFormat)((Object)ConversionPanel.this.targetFormatCombo.getSelectedItem());
                Conversion conversion = ConversionDispatch.createConversion(ConversionPanel.this.sourceFile, ConversionPanel.this.targetDirectory, this.targetFormat, ConversionPanel.this.csvSplitCheckBox.isSelected(), ConversionPanel.this.lang, ConversionPanel.this.mdFile);
                ProgressDialog dialog = new ProgressDialog("Run conversion", ConversionPanel.this, conversion);
                Thread thread = new Thread(conversion);
                thread.start();
                dialog.setLocationRelativeTo(ConversionPanel.this);
                dialog.setVisible(true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(ConversionPanel.this, ex.getMessage(), "Error", 0);
            }
            if (this.targetFormat == XMLProcessFormat.CSV) {
                ConversionPanel.this.validationButton.setEnabled(false);
            } else {
                ConversionPanel.this.validationButton.setEnabled(true);
            }
        }
    }

    private class TargetDirSelection
    implements ActionListener {
        private TargetDirSelection() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileSelectionMode(1);
            if (ConversionWindow.lastTarget != null) {
                fileChooser.setSelectedFile(new File(ConversionWindow.lastTarget));
            }
            fileChooser.showOpenDialog(ConversionPanel.this);
            File file = fileChooser.getSelectedFile();
            if (file != null && file.isDirectory()) {
                ConversionPanel.this.targetDirText.setText(file.getAbsolutePath());
                ConversionPanel.this.targetDirectory = file;
                ConversionPanel.this.targetDirText.setSelectionStart(0);
                ConversionPanel.this.targetDirText.setSelectionEnd(1);
                ConversionWindow.lastTarget = file.getAbsolutePath();
            }
            ConversionPanel.this.checkCanRun();
        }
    }

    private class MasterDataFileSelection
    implements ActionListener {
        private MasterDataFileSelection() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileFilter(new FileFilter(){

                @Override
                public String getDescription() {
                    return "*.zip - ZIP file with LCA master data";
                }

                @Override
                public boolean accept(File file) {
                    String n = file.getName().toLowerCase();
                    return file.isDirectory() || n.endsWith(".zip");
                }
            });
            fileChooser.showOpenDialog(ConversionPanel.this);
            File selFile = fileChooser.getSelectedFile();
            if (selFile != null) {
                ConversionPanel.this.mdText.setText(selFile.getAbsolutePath());
                ConversionPanel.this.mdFile = selFile;
            }
        }
    }

    private class SourceFileSelection
    implements ActionListener {
        private SourceFileSelection() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fileChooser = new JFileChooser();
            if (ConversionWindow.lastSource != null) {
                fileChooser.setSelectedFile(new File(ConversionWindow.lastSource));
            }
            fileChooser.setFileFilter(new FileFilter(){

                @Override
                public String getDescription() {
                    return "*.csv | *.spold | *.xml | *.zip - XML or ZIP file with LCA process data";
                }

                @Override
                public boolean accept(File file) {
                    String n = file.getName().toLowerCase();
                    boolean b = false;
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(".xml");
                    list.add(".zip");
                    list.add(".spold");
                    list.add(".csv");
                    for (String s : list) {
                        if (!n.endsWith(s)) continue;
                        b = true;
                        break;
                    }
                    return file.isDirectory() || b;
                }
            });
            fileChooser.showOpenDialog(ConversionPanel.this);
            File selFile = fileChooser.getSelectedFile();
            if (selFile != null) {
                ConversionPanel.this.sourceFileText.setText(selFile.getAbsolutePath());
                ConversionPanel.this.sourceFileText.setSelectionStart(0);
                ConversionPanel.this.sourceFileText.setSelectionEnd(1);
                ConversionPanel.this.sourceFile = selFile;
                ConversionWindow.lastSource = selFile.getAbsolutePath();
            }
            ConversionPanel.this.checkCanRun();
        }
    }
}

