/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.swing;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openlca.olcatdb.database.Database;
import org.openlca.olcatdb.swing.AboutPanel;
import org.openlca.olcatdb.swing.ConversionPanel;
import org.openlca.olcatdb.swing.ES2SettingPanel;
import org.openlca.olcatdb.swing.StorePanel;
import org.openlca.olcatdb.swing.XPathSearchPanel;
import org.openlca.olcatdb.templates.TemplateLoader;

public class ConversionWindow
extends JFrame {
    public static ConversionWindow conversionWindow;
    private static final long serialVersionUID = 3189547916668087580L;
    static String lastSource;
    static String lastTarget;
    private JPanel menuPanel;
    private static ConversionWindow instance;
    private Thread databaseThread;

    public JPanel getMenuPanel() {
        return this.menuPanel;
    }

    public Thread getDatabaseThread() {
        return this.databaseThread;
    }

    public static ConversionWindow getInstance() {
        return instance;
    }

    private ConversionWindow() {
        this.loadIni();
        this.setDefaultCloseOperation(3);
        this.setSize(600, 600);
        this.getContentPane().setBackground(Color.WHITE);
        this.initComponents();
        this.setTitle("openLCA - Data Converter 3.1");
        this.setIconImage(new ImageIcon(this.getClass().getResource("app_icon.png")).getImage());
        int width = this.getWidth();
        int height = this.getHeight();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screen.width - width) / 2;
        int y = (screen.height - height) / 2;
        this.setBounds(x, y, width, height);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ConversionWindow.this.writeIni();
                try {
                    Database.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.databaseThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Database.getInstance();
                    TemplateLoader.getInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.databaseThread.start();
    }

    private void loadIni() {
        File iniFile = new File("converter.ini");
        if (iniFile.exists()) {
            Properties props = new Properties();
            try {
                props.load(new FileReader(iniFile));
                lastSource = props.getProperty("lastSource");
                lastTarget = props.getProperty("lastTarget");
                String dbFolder = props.getProperty("dbFolder");
                if (dbFolder != null) {
                    Database.setFolder(new File(dbFolder));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void writeIni() {
        File dbFolder;
        Properties props = new Properties();
        if (lastSource != null) {
            props.put("lastSource", lastSource);
        }
        if (lastTarget != null) {
            props.put("lastTarget", lastTarget);
        }
        if ((dbFolder = Database.getFolder()) != null) {
            props.put("dbFolder", dbFolder.getAbsolutePath());
        }
        if (!props.isEmpty()) {
            File iniFile = new File("converter.ini");
            try {
                props.store(new FileWriter(iniFile), "");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void initComponents() {
        Container rootPanel = this.getContentPane();
        rootPanel.setLayout(new BorderLayout());
        this.menuPanel = new JPanel();
        this.menuPanel.setBackground(Color.WHITE);
        this.menuPanel.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        rootPanel.add((Component)this.menuPanel, "North");
        this.menuPanel.setLayout(new FlowLayout(0, 15, 5));
        LinkGroup menuLinks = new LinkGroup();
        Link conversionLink = new Link("Conversion");
        this.menuPanel.add(conversionLink);
        menuLinks.manageLink(conversionLink);
        Link es2SettingLink = new Link("Settings");
        this.menuPanel.add(es2SettingLink);
        menuLinks.manageLink(es2SettingLink);
        Link storeLink = new Link("Database");
        this.menuPanel.add(storeLink);
        menuLinks.manageLink(storeLink);
        Link xpathLink = new Link("XPath Search");
        this.menuPanel.add(xpathLink);
        menuLinks.manageLink(xpathLink);
        Link aboutLink = new Link("About");
        this.menuPanel.add(aboutLink);
        menuLinks.manageLink(aboutLink);
        conversionLink.setActivated(true);
        final CardLayout cardLayout = new CardLayout();
        final JPanel contentPanel = new JPanel(cardLayout);
        rootPanel.add((Component)contentPanel, "Center");
        contentPanel.add((Component)ConversionPanel.getInstance(), "Conversion");
        contentPanel.add((Component)ES2SettingPanel.getInstance(), "Settings");
        contentPanel.add((Component)new XPathSearchPanel(), "XPath");
        contentPanel.add((Component)new StorePanel(), "Store");
        contentPanel.add((Component)new AboutPanel(), "About");
        conversionLink.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                cardLayout.show(contentPanel, "Conversion");
            }
        });
        es2SettingLink.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                cardLayout.show(contentPanel, "Settings");
            }
        });
        xpathLink.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                cardLayout.show(contentPanel, "XPath");
            }
        });
        storeLink.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                cardLayout.show(contentPanel, "Store");
            }
        });
        aboutLink.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                cardLayout.show(contentPanel, "About");
            }
        });
    }

    static {
        instance = new ConversionWindow();
    }

    private class LinkGroup
    extends MouseAdapter {
        private List<Link> links = new ArrayList<Link>();

        private LinkGroup() {
        }

        public void manageLink(Link link) {
            this.links.add(link);
            link.addMouseListener(this);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Link activatedLink = (Link)e.getSource();
            activatedLink.setActivated(true);
            for (Link link : this.links) {
                if (link == activatedLink) continue;
                link.setActivated(false);
            }
        }
    }

    private class Link
    extends JLabel {
        private static final long serialVersionUID = -7623040179235397166L;
        private String text;
        private boolean activated;

        public Link(String text) {
            super("<html><u>" + text + "</u></html>");
            this.text = text;
            this.setForeground(Color.BLUE);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (!Link.this.activated) {
                        ConversionWindow.this.setCursor(new Cursor(12));
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    ConversionWindow.this.setCursor(new Cursor(0));
                }
            });
        }

        public void setActivated(boolean activated) {
            if (activated) {
                this.setText("<html><b>" + this.text + "</b></html>");
                this.setForeground(Color.GRAY);
            } else {
                this.setText("<html><u>" + this.text + "</u></html>");
                this.setForeground(Color.BLUE);
            }
            this.activated = activated;
        }
    }
}

