/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.openlca.olcatdb.conversion.es2tocsv.ES2MappingFileUtil;
import org.openlca.olcatdb.swing.ConversionWindow;
import org.openlca.olcatdb.swing.ES2SettingPanel;

public abstract class ES2AbstractMappingPanel
extends JPanel {
    private static final long serialVersionUID = 4964792093986966944L;
    protected String path = System.getProperty("user.dir") + File.separator + "database" + File.separator;
    protected File mappingFile;
    protected JTable table;
    protected DefaultTableModel model;
    protected JPanel tableJPane;
    protected JLabel subtitle;
    protected JButton removeButton;
    protected JButton addButton;
    protected JButton saveButton;
    protected JButton openButton;
    protected JButton scanButton;
    protected final FileFilter csvFileFilter = new FileFilter(){

        @Override
        public String getDescription() {
            return "*.csv";
        }

        @Override
        public boolean accept(File f) {
            String n = f.getName().toLowerCase();
            return f.isDirectory() || n.endsWith(".csv");
        }
    };

    public ES2AbstractMappingPanel() {
        this.initDefaultComponents();
    }

    protected abstract void initComponents();

    protected abstract void setTableRowsFromFile(File var1);

    protected abstract void scanButtonClicked(MouseEvent var1);

    protected abstract void addButtonClicked(MouseEvent var1);

    protected void removeButtonClicked(MouseEvent e) {
        int[] rows = this.table.getSelectedRows();
        TableModel tm = this.table.getModel();
        while (rows.length > 0) {
            ((DefaultTableModel)tm).removeRow(this.table.convertRowIndexToModel(rows[0]));
            rows = this.table.getSelectedRows();
        }
        this.table.clearSelection();
    }

    protected void openButtonClicked(MouseEvent e) {
        File file;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileFilter(this.csvFileFilter);
        fileChooser.setSelectedFile(this.mappingFile);
        int status = fileChooser.showOpenDialog(ES2SettingPanel.getInstance());
        if (status == 0 && (file = fileChooser.getSelectedFile()) != null) {
            this.setTableRowsFromFile(file);
        }
    }

    protected void saveButtonClicked(MouseEvent e) {
        try {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileFilter(this.csvFileFilter);
            fileChooser.setSelectedFile(this.mappingFile);
            int status = fileChooser.showSaveDialog(ES2SettingPanel.getInstance());
            if (status == 0) {
                File file = fileChooser.getSelectedFile();
                if (!file.getName().toLowerCase().endsWith(".csv")) {
                    file = new File(file.getAbsolutePath() + ".csv");
                    System.out.println(file.getAbsolutePath());
                }
                List<List<String>> rows = this.getRows();
                ES2MappingFileUtil.writeCSVFile(file, rows);
                JOptionPane.showMessageDialog(ES2SettingPanel.getInstance(), "Your mapping file was successfully saved to: \"" + file.getAbsolutePath() + "\"");
            }
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog(ConversionWindow.getInstance(), "Write error", "", 0);
        }
    }

    protected void initDefaultComponents() {
        this.setBackground(Color.WHITE);
        this.setLayout(new BorderLayout());
        this.subtitle = new JLabel();
        this.tableJPane = new JPanel();
        this.tableJPane.setBackground(Color.WHITE);
        this.add((Component)this.tableJPane, "West");
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.setBackground(Color.WHITE);
        this.add((Component)northPanel, "North");
        JPanel menuPanel = new JPanel();
        menuPanel.setBackground(Color.WHITE);
        menuPanel.setLayout(new FlowLayout(0));
        northPanel.add((Component)this.subtitle, "North");
        northPanel.add((Component)menuPanel, "South");
        this.scanButton = new JButton();
        menuPanel.add(this.scanButton);
        this.scanButton.setIcon(new ImageIcon(this.getClass().getResource("search_decl_obj.gif")));
        this.scanButton.setToolTipText("Scan the data in the source file. It may take a while.");
        this.scanButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ES2AbstractMappingPanel.this.scanButtonClicked(e);
            }
        });
        this.openButton = new JButton();
        this.openButton.setIcon(new ImageIcon(this.getClass().getResource("opentype.gif")));
        this.openButton.setToolTipText("Open...");
        menuPanel.add(this.openButton);
        this.openButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ES2AbstractMappingPanel.this.openButtonClicked(e);
            }
        });
        this.saveButton = new JButton();
        this.saveButton.setIcon(new ImageIcon(this.getClass().getResource("save_edit.gif")));
        this.saveButton.setToolTipText("Save");
        menuPanel.add(this.saveButton);
        this.saveButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ES2AbstractMappingPanel.this.saveButtonClicked(e);
            }
        });
        this.addButton = new JButton();
        this.addButton.setIcon(new ImageIcon(this.getClass().getResource("add_obj.gif")));
        this.addButton.setToolTipText("Add row");
        menuPanel.add(this.addButton);
        this.addButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ES2AbstractMappingPanel.this.addButtonClicked(e);
            }
        });
        this.removeButton = new JButton();
        this.removeButton.setIcon(new ImageIcon(this.getClass().getResource("delete_obj.gif")));
        this.removeButton.setToolTipText("Remove selected rows");
        menuPanel.add(this.removeButton);
        this.removeButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ES2AbstractMappingPanel.this.removeButtonClicked(e);
            }
        });
    }

    public List<List<String>> getRows() {
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        TableModel tm = this.table.getModel();
        int colCount = this.table.getColumnCount();
        int rowCount = this.table.getRowCount();
        for (int row = 0; row < rowCount; ++row) {
            ArrayList<String> list = new ArrayList<String>();
            for (int col = 0; col < colCount; ++col) {
                list.add(tm.getValueAt(row, col).toString());
            }
            rows.add(list);
        }
        return rows;
    }
}

