/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.swing;

import com.greendeltatc.simapro.csv.model.types.ElementaryFlowType;
import com.greendeltatc.simapro.csv.model.types.SubCompartment;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.openlca.olcatdb.conversion.es2tocsv.CompartmentModel;
import org.openlca.olcatdb.conversion.es2tocsv.ES2DatasetScanner;
import org.openlca.olcatdb.conversion.es2tocsv.ES2MappingFileUtil;
import org.openlca.olcatdb.swing.ConversionPanel;
import org.openlca.olcatdb.swing.ConversionWindow;
import org.openlca.olcatdb.swing.ES2AbstractMappingPanel;
import org.openlca.olcatdb.swing.ProgressDialog;

public class ES2CompartmentPanel
extends ES2AbstractMappingPanel {
    private static final long serialVersionUID = 8478443023119978317L;
    private JComboBox comboBox;
    private static ES2CompartmentPanel instance = null;

    public static ES2CompartmentPanel getInstance() {
        if (instance == null) {
            instance = new ES2CompartmentPanel();
        }
        return instance;
    }

    private ES2CompartmentPanel() {
        this.mappingFile = new File(this.path + "ES2_TO_CSV_COMPARTMENT_MAP.csv");
        this.initComponents();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ConversionWindow.getInstance().getDatabaseThread().join();
                    ES2CompartmentPanel.this.setTableRowsFromFile(ES2CompartmentPanel.this.mappingFile);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    @Override
    protected void initComponents() {
        this.subtitle.setText("  Compartment mapping");
        this.comboBox = new JComboBox();
        this.comboBox.setEditable(true);
        this.comboBox.setVisible(true);
        for (ElementaryFlowType flowType : ElementaryFlowType.values()) {
            String comp = flowType.getValue();
            this.comboBox.addItem(comp);
            for (SubCompartment subCompartment : flowType.getSubCompartments()) {
                this.comboBox.addItem(comp + "/" + subCompartment.getValue());
            }
        }
        this.table = new JTable();
        Object[] subtitles = new String[]{"ES2 Compartment", "ES2 Subcompartment", "SimaPro Element Type/Subcompartment"};
        Object[][] rows = null;
        this.model = new DefaultTableModel(rows, subtitles);
        this.model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent arg0) {
            }
        });
        this.table.setModel(this.model);
        this.table.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(this.comboBox));
        this.table.setBackground(Color.WHITE);
        this.tableJPane.add(this.table);
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setPreferredSize(new Dimension(590, 450));
        this.tableJPane.add(scrollPane);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(2);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(2);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(100);
    }

    @Override
    protected void scanButtonClicked(MouseEvent e) {
        ES2DatasetScanner scanner = new ES2DatasetScanner(ES2DatasetScanner.ScanMode.COMPARTMENTS, ConversionPanel.getInstance().getSourceFile());
        ProgressDialog dialog = new ProgressDialog("Scan compartments", ConversionPanel.getInstance(), scanner);
        Thread thread = new Thread(scanner);
        thread.start();
        dialog.setVisible(true);
        try {
            thread.join();
            Map<String, String[]> compartments = scanner.getComparments();
            for (String[] a : compartments.values()) {
                Object[] rowData = new Object[]{a[0], a[1], "-"};
                this.model.addRow(rowData);
            }
        }
        catch (InterruptedException e2) {
            // empty catch block
        }
    }

    @Override
    protected void addButtonClicked(MouseEvent e) {
        Object[] rowData = new Object[]{"", "", ""};
        this.model.addRow(rowData);
        this.table.scrollRectToVisible(this.table.getCellRect(this.table.getRowCount() - 1, 0, true));
    }

    @Override
    protected void setTableRowsFromFile(File file) {
        List<CompartmentModel> list = null;
        try {
            list = ES2MappingFileUtil.readCompartments(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (list.size() > 0) {
            if (this.model.getRowCount() > 0) {
                for (int i = this.model.getRowCount() - 1; i > -1; --i) {
                    this.model.removeRow(i);
                }
            }
            for (CompartmentModel m : list) {
                String sima = "";
                sima = m.getSimaProSubcompartment().equals("") ? m.getSimaProElemType() : m.getSimaProElemType() + "/" + m.getSimaProSubcompartment();
                Object[] rowData = new Object[]{m.getEs2Compartment(), m.getEs2Subcompartment(), sima};
                this.model.addRow(rowData);
            }
        }
    }

    @Override
    public List<List<String>> getRows() {
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        TableModel tm = this.table.getModel();
        int colCount = this.table.getColumnCount();
        int rowCount = this.table.getRowCount();
        for (int row = 0; row < rowCount; ++row) {
            ArrayList<String> list = new ArrayList<String>();
            for (int col = 0; col < colCount; ++col) {
                if (col == 2) {
                    String[] cols = tm.getValueAt(row, col).toString().split("/");
                    if (cols.length != 2) {
                        list.add(cols[0]);
                        list.add("");
                        continue;
                    }
                    list.add(cols[0]);
                    list.add(cols[1]);
                    continue;
                }
                list.add(tm.getValueAt(row, col).toString());
            }
            rows.add(list);
        }
        return rows;
    }
}

