/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.swing;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.openlca.olcatdb.conversion.es2tocsv.ES2DatasetScanner;
import org.openlca.olcatdb.conversion.es2tocsv.ES2MappingFileUtil;
import org.openlca.olcatdb.swing.ConversionPanel;
import org.openlca.olcatdb.swing.ConversionWindow;
import org.openlca.olcatdb.swing.ES2AbstractMappingPanel;
import org.openlca.olcatdb.swing.ProgressDialog;

public class ES2ElecMappingPanel
extends ES2AbstractMappingPanel {
    private static final long serialVersionUID = -8216957104204171923L;
    private static ES2ElecMappingPanel instance = new ES2ElecMappingPanel();

    public static ES2ElecMappingPanel getInstance() {
        return instance;
    }

    private ES2ElecMappingPanel() {
        this.mappingFile = new File(this.path + "ES2_TO_CSV_ELECTRICITY_UNITS.csv");
        this.initComponents();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ConversionWindow.getInstance().getDatabaseThread().join();
                    ES2ElecMappingPanel.this.setTableRowsFromFile(ES2ElecMappingPanel.this.mappingFile);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    @Override
    protected void initComponents() {
        this.subtitle.setText("  Energy Units");
        this.scanButton.setToolTipText("Scan all units in the dataset");
        this.table = new JTable();
        Object[] subtitles = new String[]{"Unit"};
        Object[][] rows = null;
        this.model = new DefaultTableModel(rows, subtitles);
        this.table.setModel(this.model);
        this.table.setBackground(Color.WHITE);
        this.tableJPane.add(this.table);
        this.tableJPane.add(new JScrollPane(this.table));
    }

    @Override
    protected void setTableRowsFromFile(File file) {
        try {
            for (String unit : ES2MappingFileUtil.readElecricityUnits(file)) {
                Object[] rowData = new Object[]{unit};
                this.model.addRow(rowData);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void scanButtonClicked(MouseEvent e) {
        ES2DatasetScanner scanner = new ES2DatasetScanner(ES2DatasetScanner.ScanMode.UNITS, ConversionPanel.getInstance().getSourceFile());
        ProgressDialog dialog = new ProgressDialog("Scan units", ConversionPanel.getInstance(), scanner);
        Thread thread = new Thread(scanner);
        thread.start();
        dialog.setVisible(true);
        try {
            thread.join();
            for (String unit : scanner.getUnits()) {
                Object[] rowData = new Object[]{unit};
                this.model.addRow(rowData);
            }
        }
        catch (InterruptedException e2) {
            // empty catch block
        }
    }

    @Override
    protected void addButtonClicked(MouseEvent e) {
        Object[] rowData = new Object[]{""};
        this.model.addRow(rowData);
        this.table.scrollRectToVisible(this.table.getCellRect(this.table.getRowCount() - 1, 0, true));
    }
}

