/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.swing;

import com.greendeltatc.simapro.csv.model.types.Geography;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.openlca.olcatdb.conversion.es2tocsv.ES2DatasetScanner;
import org.openlca.olcatdb.conversion.es2tocsv.ES2MappingFileUtil;
import org.openlca.olcatdb.swing.ConversionPanel;
import org.openlca.olcatdb.swing.ConversionWindow;
import org.openlca.olcatdb.swing.ES2AbstractMappingPanel;
import org.openlca.olcatdb.swing.ProgressDialog;

public class ES2GeoMappingPanel
extends ES2AbstractMappingPanel {
    private static final long serialVersionUID = 8478443023119978317L;
    private Map<String, String> rowMap = new HashMap<String, String>();
    private static ES2GeoMappingPanel instance = new ES2GeoMappingPanel();

    public static ES2GeoMappingPanel getInstance() {
        return instance;
    }

    private ES2GeoMappingPanel() {
        this.mappingFile = new File(this.path + "ES2_TO_CSV_GEOGRAPHY_MAP.csv");
        this.initComponents();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ConversionWindow.getInstance().getDatabaseThread().join();
                    ES2GeoMappingPanel.this.setTableRowsFromFile(ES2GeoMappingPanel.this.mappingFile);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    @Override
    protected void initComponents() {
        this.subtitle.setText("  Geography mapping");
        JComboBox<String> comboBox = new JComboBox<String>();
        for (String s : this.getComboItems()) {
            comboBox.addItem(s);
        }
        comboBox.setEnabled(true);
        comboBox.setVisible(true);
        this.table = new JTable();
        Object[] subtitles = new String[]{"EcoSpold 2", "SimaPro "};
        Object[][] rows = null;
        this.model = new DefaultTableModel(rows, subtitles);
        this.table.setModel(this.model);
        this.table.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(comboBox));
        this.table.setBackground(Color.WHITE);
        this.tableJPane.add(this.table);
        this.tableJPane.add(new JScrollPane(this.table));
    }

    @Override
    protected void scanButtonClicked(MouseEvent e) {
        ES2DatasetScanner scanner = new ES2DatasetScanner(ES2DatasetScanner.ScanMode.GEO, ConversionPanel.getInstance().getSourceFile());
        ProgressDialog dialog = new ProgressDialog("Scan geographies ...", ConversionPanel.getInstance(), scanner);
        Thread thread = new Thread(scanner);
        thread.start();
        dialog.setVisible(true);
        try {
            thread.join();
            for (String geo : scanner.getGeos()) {
                Object[] rowData = new Object[]{geo, "unknown"};
                this.model.addRow(rowData);
            }
        }
        catch (InterruptedException e2) {
            // empty catch block
        }
    }

    @Override
    protected void addButtonClicked(MouseEvent e) {
        Object[] rowData = new Object[]{"", "unknown"};
        this.model.addRow(rowData);
        this.table.scrollRectToVisible(this.table.getCellRect(this.table.getRowCount() - 1, 0, true));
    }

    @Override
    protected void setTableRowsFromFile(File file) {
        this.readMappingfile(file);
        for (Map.Entry<String, String> entry : this.rowMap.entrySet()) {
            Object[] row = new Object[]{entry.getKey(), entry.getValue()};
            this.model.addRow(row);
        }
    }

    private void readMappingfile(File file) {
        try {
            Map<Object, Object> geoMap = new HashMap();
            geoMap = ES2MappingFileUtil.readGeography(file);
            for (Map.Entry<Object, Object> entry : geoMap.entrySet()) {
                if (((String)entry.getKey()).equals("") || ((String)entry.getKey()).equals(((Geography)((Object)entry.getValue())).getValue())) continue;
                this.rowMap.put((String)entry.getKey(), ((Geography)((Object)entry.getValue())).getValue());
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(ConversionWindow.getInstance(), "Error while reading the file \"ES2_TO_CSV_GEOGRAPHY_MAP.csv\"", "ERROR", 0);
        }
    }

    private List<String> getComboItems() {
        ArrayList<String> list = new ArrayList<String>();
        for (Geography geography : Geography.values()) {
            list.add(geography.getValue());
        }
        Collections.sort(list);
        return list;
    }
}

