/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.swing;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.openlca.olcatdb.conversion.es2tocsv.ProductNameSavePreferences;
import org.openlca.olcatdb.swing.Image;

public class ES2NameSettingPanel
extends JPanel {
    private static final long serialVersionUID = -3021253759031890669L;
    private ProductNameSavePreferences saves = new ProductNameSavePreferences();
    private JCheckBox chckbxFlowName;
    private JCheckBox chckbxActivityName;
    private JCheckBox chckbxGeography;
    private JCheckBox chckbxSystemModelName;
    private JCheckBox chckbxActivityType;
    private JTextField txtFlowName;
    private JTextField txtGeo;
    private JTextField txtActivityName;
    private JTextField txtSystemModelName;
    private JTextField txtType;
    private JButton btnSave;
    private JButton btnDefaults;
    private JLabel lblExample;
    private JLabel lblSpecifyTheOrder;
    private JLabel lblNewLabel;
    private Queue<String> valueOfCurrentTextField = new LinkedList<String>();
    private static ES2NameSettingPanel instance = new ES2NameSettingPanel();

    public static ES2NameSettingPanel getInstance() {
        return instance;
    }

    private ES2NameSettingPanel() {
        this.initComponentsWithBuilder();
        this.initComponents();
        this.setValuesToComponents();
    }

    private void initComponentsWithBuilder() {
        this.setBackground(Color.WHITE);
        this.chckbxFlowName = new JCheckBox("Flow Name (1000)");
        this.chckbxActivityName = new JCheckBox("Activity Name (100)");
        this.chckbxGeography = new JCheckBox("Geography (410)");
        this.chckbxSystemModelName = new JCheckBox("System Model Name (3005)");
        this.chckbxActivityType = new JCheckBox("Activity Type (110)");
        JLabel lblSelect = new JLabel("Name (FieldID) from the Ecospold 2 documentation");
        JLabel lblSort = new JLabel("Order");
        this.btnSave = new JButton();
        this.btnSave.setIcon(new ImageIcon(this.getClass().getResource("save_edit.gif")));
        this.btnSave.setToolTipText("Save");
        this.btnDefaults = new JButton();
        this.btnDefaults.setIcon(new ImageIcon(this.getClass().getResource("defaults_ps.gif")));
        this.btnDefaults.setToolTipText("Restore Defaults");
        this.txtGeo = new JTextField();
        this.txtGeo.setHorizontalAlignment(0);
        this.txtGeo.setColumns(1);
        this.txtActivityName = new JTextField();
        this.txtActivityName.setHorizontalAlignment(0);
        this.txtActivityName.setColumns(1);
        this.txtSystemModelName = new JTextField();
        this.txtSystemModelName.setHorizontalAlignment(0);
        this.txtSystemModelName.setColumns(1);
        this.txtType = new JTextField();
        this.txtType.setHorizontalAlignment(0);
        this.txtType.setColumns(1);
        this.txtFlowName = new JTextField();
        this.txtFlowName.setHorizontalAlignment(0);
        this.txtFlowName.setColumns(1);
        this.lblExample = new JLabel("Example with default Settings (1,2,3,4,5):\n");
        this.lblSpecifyTheOrder = new JLabel("Specify the order of elements in product flow names.");
        this.lblNewLabel = new JLabel(new ImageIcon());
        JLabel lblNewLabel_1 = new JLabel("");
        lblNewLabel_1.setIcon(Image.makeIcon("productNameExample.png"));
        GroupLayout groupLayout = new GroupLayout(this);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.txtSystemModelName, -1, 35, Short.MAX_VALUE).addComponent(this.txtType, -1, 35, Short.MAX_VALUE).addComponent(this.txtGeo, -1, 35, Short.MAX_VALUE).addComponent(this.txtActivityName)).addComponent(this.txtFlowName, -2, 35, -2)).addGap(18)).addGroup(groupLayout.createSequentialGroup().addComponent(lblSort, -1, 47, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chckbxActivityName).addComponent(this.chckbxGeography).addGroup(groupLayout.createSequentialGroup().addComponent(this.chckbxActivityType).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 215, Short.MAX_VALUE)).addComponent(this.chckbxSystemModelName).addComponent(lblSelect, -2, 365, -2)).addGap(21)).addComponent(this.chckbxFlowName, -2, 189, -2))).addComponent(this.lblExample).addComponent(this.lblNewLabel).addComponent(lblNewLabel_1, -1, 439, Short.MAX_VALUE).addComponent(this.lblSpecifyTheOrder))).addGroup(groupLayout.createSequentialGroup().addComponent(this.btnSave).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnDefaults))).addGap(5)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnSave).addComponent(this.btnDefaults)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblSpecifyTheOrder).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblSort).addComponent(lblSelect)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtFlowName, -2, 23, -2).addComponent(this.chckbxFlowName)).addGap(4).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtGeo, -2, 23, -2).addComponent(this.chckbxGeography)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtActivityName, -2, 23, -2).addComponent(this.chckbxActivityName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.chckbxSystemModelName).addComponent(this.txtSystemModelName, -2, 23, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.chckbxActivityType).addComponent(this.txtType, -2, 23, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblExample).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(lblNewLabel_1).addGap(63).addComponent(this.lblNewLabel).addContainerGap(-1, Short.MAX_VALUE)));
        this.setLayout(groupLayout);
    }

    private void setDefaultsClicked(MouseEvent e) {
        this.saves = new ProductNameSavePreferences();
        ProductNameSavePreferences.writeDatabase(this.saves);
        this.setValuesToComponents();
    }

    private void initComponents() {
        this.btnSave.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                ES2NameSettingPanel.this.setSavedValues();
            }
        });
        this.btnDefaults.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ES2NameSettingPanel.this.setDefaultsClicked(e);
            }
        });
        this.txtFlowName.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent arg0) {
                ES2NameSettingPanel.this.changeTextInput(ES2NameSettingPanel.this.txtFlowName);
            }

            @Override
            public void focusGained(FocusEvent arg0) {
                ES2NameSettingPanel.this.textFieldFocusGained(arg0, ES2NameSettingPanel.this.txtFlowName);
            }
        });
        this.txtGeo.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent arg0) {
                ES2NameSettingPanel.this.changeTextInput(ES2NameSettingPanel.this.txtGeo);
            }

            @Override
            public void focusGained(FocusEvent arg0) {
                ES2NameSettingPanel.this.textFieldFocusGained(arg0, ES2NameSettingPanel.this.txtGeo);
            }
        });
        this.txtActivityName.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent arg0) {
                ES2NameSettingPanel.this.changeTextInput(ES2NameSettingPanel.this.txtActivityName);
            }

            @Override
            public void focusGained(FocusEvent arg0) {
                ES2NameSettingPanel.this.textFieldFocusGained(arg0, ES2NameSettingPanel.this.txtActivityName);
            }
        });
        this.txtSystemModelName.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent arg0) {
                ES2NameSettingPanel.this.changeTextInput(ES2NameSettingPanel.this.txtSystemModelName);
            }

            @Override
            public void focusGained(FocusEvent arg0) {
                ES2NameSettingPanel.this.textFieldFocusGained(arg0, ES2NameSettingPanel.this.txtSystemModelName);
            }
        });
        this.txtType.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent arg0) {
                ES2NameSettingPanel.this.changeTextInput(ES2NameSettingPanel.this.txtType);
            }

            @Override
            public void focusGained(FocusEvent arg0) {
                ES2NameSettingPanel.this.textFieldFocusGained(arg0, ES2NameSettingPanel.this.txtType);
            }
        });
    }

    private void textFieldFocusGained(FocusEvent arg0, JTextField textField) {
        this.valueOfCurrentTextField.add(textField.getText());
    }

    private void setMapValueSafe(Map<Integer, JTextField> map, JTextField textField, JTextField changedField, String oldValue) {
        if (textField != changedField) {
            map.put(Integer.valueOf(textField.getText()), textField);
        } else {
            map.put(Integer.valueOf(oldValue), textField);
        }
    }

    private void changeTextInput(JTextField textField) {
        String oldValue = this.valueOfCurrentTextField.poll();
        HashMap<Integer, JTextField> map = new HashMap<Integer, JTextField>();
        this.setMapValueSafe(map, this.txtFlowName, textField, oldValue);
        this.setMapValueSafe(map, this.txtGeo, textField, oldValue);
        this.setMapValueSafe(map, this.txtActivityName, textField, oldValue);
        this.setMapValueSafe(map, this.txtSystemModelName, textField, oldValue);
        this.setMapValueSafe(map, this.txtType, textField, oldValue);
        try {
            int value = Integer.parseInt(textField.getText());
            if (value < 1 || value > 5) {
                textField.setText(oldValue);
                this.showWrongInputMessage();
            } else {
                ((JTextField)map.get(value)).setText(oldValue);
            }
        }
        catch (NumberFormatException e) {
            this.showWrongInputMessage();
        }
    }

    private void showWrongInputMessage() {
        String message = "Only allow the characters from 1 to 5.";
        JOptionPane.showMessageDialog(new JFrame(), message);
    }

    public void setSavedValues() {
        this.saves.setChkBoxFlowName(this.chckbxFlowName.isSelected());
        this.saves.setChkBoxGeo(this.chckbxGeography.isSelected());
        this.saves.setChkBoxActivityName(this.chckbxActivityName.isSelected());
        this.saves.setChkBoxSystemModelName(this.chckbxSystemModelName.isSelected());
        this.saves.setChkBoxActivityType(this.chckbxActivityType.isSelected());
        this.saves.setSortFlowName(Integer.parseInt(this.txtFlowName.getText()));
        this.saves.setSortGeo(Integer.parseInt(this.txtGeo.getText()));
        this.saves.setSortActivityName(Integer.parseInt(this.txtActivityName.getText()));
        this.saves.setSortSystemModelName(Integer.parseInt(this.txtSystemModelName.getText()));
        this.saves.setSortAcitvityType(Integer.parseInt(this.txtType.getText()));
        if (!ProductNameSavePreferences.writeDatabase(this.saves)) {
            JOptionPane.showMessageDialog(new JFrame(), "Save Error!");
        } else {
            JOptionPane.showMessageDialog(new JFrame(), "Saved!");
        }
    }

    public void setValuesToComponents() {
        this.saves = ProductNameSavePreferences.readDatabase();
        this.chckbxFlowName.setSelected(this.saves.isChkBoxFlowName());
        this.chckbxActivityName.setSelected(this.saves.isChkBoxActivityName());
        this.chckbxGeography.setSelected(this.saves.isChkBoxGeo());
        this.chckbxSystemModelName.setSelected(this.saves.isChkBoxSystemModelName());
        this.chckbxActivityType.setSelected(this.saves.isChkBoxActivityType());
        this.txtFlowName.setText(String.valueOf(this.saves.getSortFlowName()));
        this.txtGeo.setText(String.valueOf(this.saves.getSortGeo()));
        this.txtActivityName.setText(String.valueOf(this.saves.getSortActivityName()));
        this.txtSystemModelName.setText(String.valueOf(this.saves.getSortSystemModelName()));
        this.txtType.setText(String.valueOf(this.saves.getSortAcitvityType()));
    }
}

