/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.openlca.olcatdb.conversion.Conversion;
import org.openlca.olcatdb.conversion.Monitor;
import org.openlca.olcatdb.conversion.Task;
import org.openlca.olcatdb.conversion.Validation;
import org.openlca.olcatdb.swing.ConversionPanel;

public class ProgressDialog
extends JDialog
implements Monitor {
    private static final long serialVersionUID = 1750356891833727862L;
    private Task task;
    private ConversionPanel conversionPanel;
    private JProgressBar progressBar;
    private JLabel statusLabel;
    private JButton cancelButton;

    public ProgressDialog(String title, ConversionPanel panel, Task conversion) {
        super(panel.getFrame(panel.getParent()), title, true);
        this.task = conversion;
        this.task.setMonitor(this);
        this.conversionPanel = panel;
        JPanel content = (JPanel)this.getContentPane();
        content.setBackground(Color.WHITE);
        this.progressBar = new JProgressBar();
        content.add((Component)this.progressBar, "Center");
        this.statusLabel = new JLabel("Start conversion...");
        JPanel labelPanel = new JPanel(new FlowLayout(0));
        labelPanel.setBackground(Color.WHITE);
        content.add((Component)labelPanel, "North");
        labelPanel.add(this.statusLabel);
        this.cancelButton = new JButton("Cancel");
        JPanel cancelPanel = new JPanel(new FlowLayout(2));
        cancelPanel.setBackground(Color.WHITE);
        content.add((Component)cancelPanel, "South");
        cancelPanel.add(this.cancelButton);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (ProgressDialog.this.task != null) {
                    ProgressDialog.this.statusLabel.setText("Stop process...");
                    ProgressDialog.this.cancelButton.setEnabled(false);
                    ProgressDialog.this.task.cancel();
                }
            }
        });
        this.setDefaultCloseOperation(0);
        this.setSize(300, 125);
    }

    @Override
    public void begin(int size) {
        this.progressBar.setMaximum(size);
        this.progressBar.setValue(0);
    }

    @Override
    public void finished(Task task) {
        if (task instanceof Conversion) {
            this.conversionPanel.setResourceFolder(task.getResult());
        } else if (task instanceof Validation) {
            this.conversionPanel.validationPerformed();
        }
        this.dispose();
    }

    @Override
    public void progress(String step, int worked) {
        this.statusLabel.setText(step);
        this.progressBar.setValue(worked);
    }
}

