/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.openlca.olcatdb.database.Database;
import org.openlca.olcatdb.swing.SwitchDatabaseAction;

public class StorePanel
extends JPanel {
    private static final long serialVersionUID = -576755786625142901L;
    private JTextField queryText;
    private JEditorPane outputPane;

    public StorePanel() {
        super(new BorderLayout());
        this.init();
    }

    private void init() {
        this.setBackground(Color.WHITE);
        JPanel searchPanel = new JPanel(new GridBagLayout());
        searchPanel.setBackground(Color.WHITE);
        this.add((Component)searchPanel, "North");
        GridBagConstraints grid = null;
        int row = 0;
        JLabel logo = new JLabel();
        logo.setIcon(new ImageIcon(this.getClass().getResource("logo.jpg")));
        grid = new GridBagConstraints();
        grid.gridy = row++;
        grid.insets = new Insets(0, 10, 0, 10);
        grid.gridwidth = 4;
        searchPanel.add((Component)logo, grid);
        JLabel folderLabel = new JLabel("Database folder:");
        grid = new GridBagConstraints();
        grid.gridy = row;
        grid.anchor = 21;
        grid.insets = new Insets(5, 5, 5, 5);
        searchPanel.add((Component)folderLabel, grid);
        JTextField folderText = new JTextField();
        folderText.setText(Database.getFolder().getAbsolutePath());
        folderText.setEditable(false);
        folderText.setPreferredSize(new Dimension(300, 28));
        folderText.setMinimumSize(new Dimension(300, 28));
        grid = new GridBagConstraints();
        grid.gridy = row;
        grid.insets = new Insets(5, 5, 5, 5);
        searchPanel.add((Component)folderText, grid);
        JButton folderButton = new JButton();
        folderButton.setToolTipText("Select the database location");
        folderButton.setIcon(new ImageIcon(this.getClass().getResource("folder.png")));
        grid = new GridBagConstraints();
        grid.gridy = row++;
        grid.insets = new Insets(5, 5, 5, 5);
        searchPanel.add((Component)folderButton, grid);
        JLabel sourceLabel = new JLabel("Query:");
        grid = new GridBagConstraints();
        grid.gridy = row;
        grid.anchor = 21;
        grid.insets = new Insets(5, 5, 5, 5);
        searchPanel.add((Component)sourceLabel, grid);
        this.queryText = new JTextField();
        this.queryText.setText("SELECT * FROM ES1_COMPARTMENTS");
        this.queryText.setEditable(true);
        this.queryText.setPreferredSize(new Dimension(300, 28));
        this.queryText.setMinimumSize(new Dimension(300, 28));
        grid = new GridBagConstraints();
        grid.gridy = row;
        grid.insets = new Insets(5, 5, 5, 5);
        searchPanel.add((Component)this.queryText, grid);
        JButton runButton = new JButton();
        runButton.setIcon(new ImageIcon(this.getClass().getResource("run.png")));
        grid = new GridBagConstraints();
        grid.gridy = row++;
        grid.insets = new Insets(5, 5, 5, 5);
        searchPanel.add((Component)runButton, grid);
        runButton.addActionListener(new SearchAction());
        runButton.setToolTipText("Run SQL query");
        this.outputPane = new JEditorPane();
        this.outputPane.setEditable(true);
        this.add((Component)new JScrollPane(this.outputPane), "Center");
        final JPopupMenu menu = new JPopupMenu();
        this.outputPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    menu.show(StorePanel.this.outputPane, e.getX(), e.getY());
                }
            }
        });
        folderButton.addActionListener(new SwitchDatabaseAction(folderText, this.outputPane));
    }

    private class SearchAction
    implements ActionListener {
        private SearchAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                StringBuilder builder = new StringBuilder();
                String query = StorePanel.this.queryText.getText();
                ResultSet resultSet = Database.getInstance().query(query);
                ResultSetMetaData md = resultSet.getMetaData();
                int c = md.getColumnCount();
                while (resultSet.next()) {
                    for (int i = 1; i <= c; ++i) {
                        Object o = resultSet.getObject(i);
                        if (o != null) {
                            builder.append(o.toString());
                        }
                        if (i >= c) continue;
                        builder.append("; ");
                    }
                    builder.append("\n");
                }
                StorePanel.this.outputPane.setText(builder.toString());
            }
            catch (Exception exc) {
                exc.printStackTrace();
                JOptionPane.showMessageDialog(StorePanel.this, exc.getMessage(), "Error", 0);
            }
        }
    }
}

