/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.openlca.olcatdb.conversion.XPathSearch;
import org.openlca.olcatdb.swing.ConversionWindow;

public class XPathSearchPanel
extends JPanel {
    private static final long serialVersionUID = 4461144118652223470L;
    private JTextField sourceFileText;
    private File sourceFile;
    private JTextField queryText;
    private JEditorPane outputPane;

    public XPathSearchPanel() {
        super(new BorderLayout());
        this.init();
    }

    private void init() {
        this.setBackground(Color.WHITE);
        JPanel searchPanel = new JPanel(new GridBagLayout());
        searchPanel.setBackground(Color.WHITE);
        this.add((Component)searchPanel, "North");
        GridBagConstraints grid = null;
        int row = 0;
        JLabel logo = new JLabel();
        logo.setIcon(new ImageIcon(this.getClass().getResource("logo.jpg")));
        grid = new GridBagConstraints();
        grid.gridy = row++;
        grid.insets = new Insets(0, 10, 0, 10);
        grid.gridwidth = 4;
        searchPanel.add((Component)logo, grid);
        JLabel sourceLabel = new JLabel("Source:");
        grid = new GridBagConstraints();
        grid.gridy = row;
        grid.anchor = 21;
        grid.insets = new Insets(5, 5, 5, 5);
        searchPanel.add((Component)sourceLabel, grid);
        this.sourceFileText = new JTextField();
        this.sourceFileText.setEditable(false);
        this.sourceFileText.setPreferredSize(new Dimension(300, 28));
        this.sourceFileText.setMinimumSize(new Dimension(300, 28));
        grid = new GridBagConstraints();
        grid.gridy = row;
        grid.insets = new Insets(5, 5, 5, 5);
        searchPanel.add((Component)this.sourceFileText, grid);
        JButton sourceBrowseButton = new JButton();
        sourceBrowseButton.setIcon(new ImageIcon(this.getClass().getResource("folder.png")));
        grid = new GridBagConstraints();
        grid.gridy = row++;
        grid.insets = new Insets(5, 5, 5, 5);
        searchPanel.add((Component)sourceBrowseButton, grid);
        sourceBrowseButton.addActionListener(new SourceFileSelection());
        JLabel targetLabel = new JLabel("XPath:");
        grid = new GridBagConstraints();
        grid.gridy = row;
        grid.anchor = 21;
        grid.insets = new Insets(5, 5, 5, 5);
        searchPanel.add((Component)targetLabel, grid);
        this.queryText = new JTextField();
        this.queryText.setEditable(true);
        this.queryText.setPreferredSize(new Dimension(300, 28));
        this.queryText.setMinimumSize(new Dimension(300, 28));
        grid = new GridBagConstraints();
        grid.gridy = row;
        grid.insets = new Insets(5, 5, 5, 5);
        searchPanel.add((Component)this.queryText, grid);
        JButton runButton = new JButton();
        runButton.setIcon(new ImageIcon(this.getClass().getResource("run.png")));
        grid = new GridBagConstraints();
        grid.gridy = row;
        grid.insets = new Insets(5, 5, 5, 5);
        searchPanel.add((Component)runButton, grid);
        runButton.addActionListener(new RunAction());
        this.outputPane = new JEditorPane();
        this.outputPane.setEditable(true);
        this.add((Component)new JScrollPane(this.outputPane), "Center");
        final JPopupMenu menu = new JPopupMenu();
        menu.add(new SaveAction());
        this.outputPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    menu.show(XPathSearchPanel.this.outputPane, e.getX(), e.getY());
                }
            }
        });
    }

    private class RunAction
    implements ActionListener {
        private RunAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (XPathSearchPanel.this.sourceFile == null || !XPathSearchPanel.this.sourceFile.exists()) {
                JOptionPane.showMessageDialog(XPathSearchPanel.this, "There is no source file selected.", "Error", 0);
            } else {
                String query = XPathSearchPanel.this.queryText.getText();
                if (query == null || query.length() == 0) {
                    JOptionPane.showMessageDialog(XPathSearchPanel.this, "The query is empty.", "Error", 0);
                } else {
                    try {
                        StringWriter writer = new StringWriter();
                        BufferedWriter buffer = new BufferedWriter(writer);
                        XPathSearch search = new XPathSearch(XPathSearchPanel.this.sourceFile, query);
                        search.run();
                        HashMap<String, String> result = search.getResult();
                        if (result.isEmpty()) {
                            buffer.write("no result");
                            buffer.newLine();
                        } else {
                            ArrayList<String> keys = new ArrayList<String>(result.keySet());
                            Collections.sort(keys);
                            for (String key : keys) {
                                String resLine = key + "; " + result.get(key);
                                buffer.write(resLine);
                                buffer.newLine();
                            }
                        }
                        buffer.flush();
                        buffer.close();
                        XPathSearchPanel.this.outputPane.setText(writer.toString());
                    }
                    catch (Exception e2) {
                        JOptionPane.showMessageDialog(XPathSearchPanel.this, e2.getMessage(), "Error", 0);
                    }
                }
            }
        }
    }

    private class SourceFileSelection
    implements ActionListener {
        private SourceFileSelection() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fileChooser = new JFileChooser();
            if (ConversionWindow.lastSource != null) {
                fileChooser.setSelectedFile(new File(ConversionWindow.lastSource));
            }
            fileChooser.setFileFilter(new FileFilter(){

                @Override
                public String getDescription() {
                    return "*.xml | .zip - XML or ZIP file";
                }

                @Override
                public boolean accept(File file) {
                    String n = file.getName();
                    return file.isDirectory() || n.endsWith(".XML") || n.endsWith(".xml") || n.endsWith(".zip") || n.endsWith(".ZIP");
                }
            });
            fileChooser.showOpenDialog(XPathSearchPanel.this);
            File selFile = fileChooser.getSelectedFile();
            if (selFile != null) {
                XPathSearchPanel.this.sourceFile = selFile;
                XPathSearchPanel.this.sourceFileText.setText(selFile.getAbsolutePath());
                XPathSearchPanel.this.sourceFileText.setSelectionStart(0);
                XPathSearchPanel.this.sourceFileText.setSelectionEnd(1);
                ConversionWindow.lastSource = selFile.getAbsolutePath();
            }
        }
    }

    private class SaveAction
    extends AbstractAction {
        private static final long serialVersionUID = -7701604559722509406L;

        public SaveAction() {
            super("Save As...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setSelectedFile(new File("result.csv"));
            int save = fileChooser.showSaveDialog(XPathSearchPanel.this);
            File selFile = fileChooser.getSelectedFile();
            if (save == 0 && selFile != null) {
                boolean doIt = true;
                if (selFile.exists()) {
                    int d = JOptionPane.showConfirmDialog(XPathSearchPanel.this, "The selected file already exists. Do you want to overwrite it?", "File exists", 2);
                    boolean bl = doIt = d == 0;
                }
                if (doIt) {
                    try {
                        StringReader reader = new StringReader(XPathSearchPanel.this.outputPane.getText());
                        BufferedReader inBuffer = new BufferedReader(reader);
                        FileWriter writer = new FileWriter(fileChooser.getSelectedFile());
                        BufferedWriter outBuffer = new BufferedWriter(writer);
                        String line = null;
                        while ((line = inBuffer.readLine()) != null) {
                            outBuffer.write(line);
                            outBuffer.newLine();
                        }
                        outBuffer.flush();
                        outBuffer.close();
                        inBuffer.close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(XPathSearchPanel.this, ex.getMessage(), "Error", 0);
                    }
                }
            }
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }
}

