/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.templates;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.app.VelocityEngine;
import org.openlca.olcatdb.templates.TemplateType;

public class TemplateLoader {
    private static volatile TemplateLoader loader;
    private static Object loaderLock;
    private static String templateFolder;
    private volatile VelocityEngine engine;

    private TemplateLoader() {
        this.initializeTemplatesAndEngine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TemplateLoader getInstance() {
        if (loader == null) {
            Object object = loaderLock;
            synchronized (object) {
                if (loader == null) {
                    loader = new TemplateLoader();
                }
            }
        }
        return loader;
    }

    public static void setTemplateFolder(String folder) {
        if (!folder.equals(templateFolder)) {
            templateFolder = folder;
            if (loader != null) {
                loader = new TemplateLoader();
            }
        }
    }

    private void initializeTemplatesAndEngine() {
        File templateDir = this.initTemplateFolder();
        this.extractTemplates(templateDir);
        this.initEngine();
    }

    private File initTemplateFolder() {
        File templateDir = new File(templateFolder);
        if (!templateDir.exists()) {
            templateDir.mkdir();
        }
        return templateDir;
    }

    private void extractTemplates(File templateDir) {
        for (TemplateType templateType : TemplateType.values()) {
            String templateName = templateType.getTemplateName();
            File templateFile = new File(templateDir, templateName);
            if (templateFile.exists()) continue;
            this.extractTemplate(templateName, templateFile);
        }
    }

    private void extractTemplate(String templateName, File templateFile) {
        try {
            this.tryExtractTemplate(templateName, templateFile);
        }
        catch (Exception e) {
            String message = String.format("Cannot extract template %s to folder %s.", templateName, templateFile);
            throw new RuntimeException(message, e);
        }
    }

    private void tryExtractTemplate(String templateName, File templateFile) throws Exception {
        InputStream is = TemplateLoader.class.getResourceAsStream(templateName);
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        BufferedWriter writer = new BufferedWriter(new FileWriter(templateFile));
        String line = null;
        while ((line = reader.readLine()) != null) {
            writer.write(line);
            writer.newLine();
        }
        writer.flush();
        writer.close();
        reader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initEngine() {
        TemplateLoader templateLoader = this;
        synchronized (templateLoader) {
            if (this.engine != null) {
                return;
            }
            this.engine = new VelocityEngine();
            this.engine.setProperty("file.resource.loader.path", templateFolder);
            try {
                Properties props = new Properties();
                props.put("file.resource.loader.cache", "true");
                props.put("resource.loader", "file");
                this.engine.init(props);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Template getTemplate(TemplateType type) {
        Template t = null;
        try {
            t = this.engine.getTemplate(type.getTemplateName());
        }
        catch (Exception e) {
            String message = String.format("Cannot load template %s.", type.getTemplateName());
            throw new RuntimeException(message, e);
        }
        return t;
    }

    static {
        loaderLock = new Object();
        templateFolder = "templates";
    }
}

