/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.templates;

import org.openlca.olcatdb.conversion.FileIndex;
import org.openlca.olcatdb.datatypes.DataSetReference;
import org.openlca.olcatdb.ecospold1.ES1EcoSpold;
import org.openlca.olcatdb.ecospold2.ES2EcoSpold;
import org.openlca.olcatdb.ecospold2.ES2Uncertainty;
import org.openlca.olcatdb.ecospold2.masterdata.ES2ActivityList;
import org.openlca.olcatdb.ecospold2.masterdata.ES2ActivityNameList;
import org.openlca.olcatdb.ecospold2.masterdata.ES2ClassificationSystemList;
import org.openlca.olcatdb.ecospold2.masterdata.ES2CompartmentList;
import org.openlca.olcatdb.ecospold2.masterdata.ES2ElemFlowList;
import org.openlca.olcatdb.ecospold2.masterdata.ES2GeographyList;
import org.openlca.olcatdb.ecospold2.masterdata.ES2PersonList;
import org.openlca.olcatdb.ecospold2.masterdata.ES2ProductFlowList;
import org.openlca.olcatdb.ecospold2.masterdata.ES2SourceList;
import org.openlca.olcatdb.ecospold2.masterdata.ES2TagList;
import org.openlca.olcatdb.ecospold2.masterdata.ES2UnitList;
import org.openlca.olcatdb.ilcd.ILCDContact;
import org.openlca.olcatdb.ilcd.ILCDFlow;
import org.openlca.olcatdb.ilcd.ILCDFlowProperty;
import org.openlca.olcatdb.ilcd.ILCDProcess;
import org.openlca.olcatdb.ilcd.ILCDSource;
import org.openlca.olcatdb.ilcd.ILCDUnitGroup;

public enum TemplateType {
    EcoSpold01("EcoSpold1.vtl", "ecoSpold", ES1EcoSpold.class),
    EcoSpold02("EcoSpold2.vtl", "ecoSpold", ES2EcoSpold.class),
    ES2Units("ES2Units.vtl", "unitList", ES2UnitList.class),
    ES2SourceList("ES2Sources.vtl", "sources", ES2SourceList.class),
    ES2ActivityNameList("ES2ActivityNames.vtl", "activities", ES2ActivityNameList.class),
    ES2ActivityList("ES2ActivityList.vtl", "activities", ES2ActivityList.class),
    ES2Classifications("ES2Classifications.vtl", "systems", ES2ClassificationSystemList.class),
    ES2ElemFlowList("ES2ElementaryExchanges.vtl", "exchanges", ES2ElemFlowList.class),
    ES2ProductFlowList("IntermediateExchanges.vtl", "exchanges", ES2ProductFlowList.class),
    ES2GeographyList("ES2Geographies.vtl", "geographies", ES2GeographyList.class),
    ES2PersonList("ES2Persons.vtl", "persons", ES2PersonList.class),
    ES2TagList("ES2Tags.vtl", "tagList", ES2TagList.class),
    ES2CompartmentList("ES2Compartments.vtl", "compartmentList", ES2CompartmentList.class),
    ES2Uncertainty("ES2Uncertainty.vtl", "uncertainty", ES2Uncertainty.class),
    ILCDProcess("ILCDProcess.vtl", "process", ILCDProcess.class),
    ILCDFlow("ILCDFlow.vtl", "flow", ILCDFlow.class),
    ILCDFlowProperty("ILCDFlowProperty.vtl", "flowProperty", ILCDFlowProperty.class),
    ILCDUnitGroup("ILCDUnitGroup.vtl", "unitGroup", ILCDUnitGroup.class),
    ILCDSource("ILCDSource.vtl", "source", ILCDSource.class),
    ILCDContact("ILCDContact.vtl", "contact", ILCDContact.class),
    ILCDDataSetReference("ILCDDataSetRef.vtl", "refElem refVal", DataSetReference.class),
    FileIndex("FileIndex.vtl", "index", FileIndex.class);

    private final String templateName;
    private final String contextName;
    private final Class<?> contextType;

    private TemplateType(String templateName, String contextName, Class<?> contextType) {
        this.templateName = templateName;
        this.contextName = contextName;
        this.contextType = contextType;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public String getContextName() {
        return this.contextName;
    }

    public Class<?> getContextType() {
        return this.contextType;
    }
}

