/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.olcatdb.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.event.EventCartridge;
import org.apache.velocity.app.event.implement.EscapeXmlReference;
import org.openlca.olcatdb.templates.TemplateLoader;
import org.openlca.olcatdb.templates.TemplateType;
import org.openlca.olcatdb.xml.XmlFormatter;

public class XmlOutputter {
    private static final String ENCODING = "utf-8";
    private static final ExecutorService executor = new ThreadPoolExecutor(0, 8, 2L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy());

    public void output(Object context, TemplateType templateType, File file) {
        this.output(context, templateType, file, false);
    }

    public void output(Object context, TemplateType templateType, File file, boolean otherThread) {
        if (context == null || templateType == null || file == null) {
            throw new IllegalArgumentException("The context object, template type, and target file cannot be NULL.");
        }
        FileWorker worker = new FileWorker(context, templateType, file);
        if (!otherThread) {
            worker.run();
        } else {
            executor.execute(worker);
        }
    }

    public void output(Object context, TemplateType templateType, Writer writer) {
        this.output(context, templateType, writer, false);
    }

    public void output(Object context, TemplateType templateType, Writer writer, boolean otherThread) {
        if (context == null || templateType == null || writer == null) {
            throw new IllegalArgumentException("The context object, template type, and writer cannot be NULL.");
        }
        WriterWorker worker = new WriterWorker(context, templateType, writer);
        if (!otherThread) {
            worker.run();
        } else {
            executor.execute(worker);
        }
    }

    private class WriterWorker
    implements Runnable {
        private Object context;
        private TemplateType templateType;
        private Writer writer;

        public WriterWorker(Object context, TemplateType templateType, Writer writer) {
            this.context = context;
            this.templateType = templateType;
            this.writer = writer;
        }

        @Override
        public void run() {
            Template template = TemplateLoader.getInstance().getTemplate(this.templateType);
            VelocityContext velocityContext = new VelocityContext();
            velocityContext.put(this.templateType.getContextName(), this.context);
            try {
                EventCartridge cartridge = new EventCartridge();
                cartridge.addEventHandler(new EscapeXmlReference());
                cartridge.attachToContext(velocityContext);
                StringWriter cacheWriter = new StringWriter();
                template.merge(velocityContext, cacheWriter);
                cacheWriter.flush();
                cacheWriter.close();
                StringReader cacheReader = new StringReader(cacheWriter.toString());
                XmlFormatter formatter = new XmlFormatter();
                formatter.format(cacheReader, this.writer);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class FileWorker
    implements Runnable {
        private Object context;
        private TemplateType templateType;
        private File file;

        public FileWorker(Object context, TemplateType templateType, File file) {
            this.context = context;
            this.templateType = templateType;
            this.file = file;
        }

        @Override
        public void run() {
            Template template = TemplateLoader.getInstance().getTemplate(this.templateType);
            VelocityContext velocityContext = new VelocityContext();
            velocityContext.put(this.templateType.getContextName(), this.context);
            try {
                EventCartridge cartridge = new EventCartridge();
                cartridge.addEventHandler(new EscapeXmlReference());
                cartridge.attachToContext(velocityContext);
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), XmlOutputter.ENCODING);
                template.merge(velocityContext, writer);
                ((Writer)writer).flush();
                ((Writer)writer).close();
                XmlFormatter formatter = new XmlFormatter();
                formatter.format(this.file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

