/*
 * Decompiled with CFR 0.152.
 */
package csk.penrose;

import csk.penrose.App;
import csk.penrose.PenroseTile;
import csk.taprats.geometry.Point;
import csk.taprats.geometry.Polygon;
import csk.taprats.geometry.Rect;
import csk.taprats.geometry.Transform;
import csk.taprats.toolkit.GeoGraphics;
import csk.taprats.toolkit.GeoView;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;

public class Editor
extends GeoView {
    protected PenroseTile tile;
    protected App app;
    boolean first;
    int drag_edge;
    int drag_vert;

    public Editor(PenroseTile penroseTile, boolean bl) {
        this(penroseTile, bl, Editor.getBoundingRect(penroseTile, bl));
    }

    protected Editor(PenroseTile penroseTile, boolean bl, Rect rect) {
        super(0.0, 0.0, 1.0);
        this.tile = penroseTile;
        this.first = bl;
        this.drag_edge = -1;
        this.setSink(true);
        this.setBackground(new Color(0.9372549f, 0.9372549f, 0.9372549f));
        MouseGuy mouseGuy = new MouseGuy();
        this.addMouseListener(mouseGuy);
        this.addMouseMotionListener(mouseGuy);
        this.setBounds(rect.getLeft(), rect.getTop(), rect.getWidth());
    }

    private static Rect getBoundingRect(PenroseTile penroseTile, boolean bl) {
        Point[] pointArray = bl ? penroseTile.getFirstShape() : penroseTile.getSecondShape();
        Rect rect = new Polygon(pointArray).getBoundingBox().centralScale(1.25);
        double d = Math.max(rect.getWidth(), rect.getHeight());
        Point point = new Point(rect.getLeft() + 0.5 * rect.getWidth(), rect.getBottom() + 0.5 * rect.getHeight());
        return new Rect(point.getX() - 0.5 * d, point.getY() + 0.5 * d, d, d);
    }

    public void setApp(App app) {
        this.app = app;
    }

    public void setTile(PenroseTile penroseTile) {
        this.tile = penroseTile;
        this.drag_edge = -1;
        this.drag_vert = -1;
        Rect rect = Editor.getBoundingRect(penroseTile, this.first);
        this.setBounds(rect.getLeft(), rect.getTop(), rect.getWidth());
    }

    public void redraw(GeoGraphics geoGraphics) {
        int n;
        Point[][] pointArrayArray;
        Point[] pointArray;
        Point[] pointArray2;
        Color color = Color.black;
        Color color2 = null;
        Color color3 = new Color(0.0f, 0.0f, 0.25f);
        Color color4 = new Color(0.0f, 0.0f, 0.75f);
        Color color5 = new Color(1.0f, 0.0f, 0.0f);
        if (this.first) {
            pointArray2 = this.tile.getFirstShape();
            color2 = new Color(0.87058824f, 0.8392157f, 0.7764706f);
            pointArray = new Point[this.tile.numFirstEdges()];
            pointArrayArray = new Point[this.tile.numFirstEdges()][];
            for (n = 0; n < this.tile.numFirstEdges(); ++n) {
                pointArray[n] = this.tile.getFirstVertex(n);
                pointArrayArray[n] = this.tile.getFirstEdge(n);
            }
        } else {
            pointArray2 = this.tile.getSecondShape();
            color2 = new Color(0.9372549f, 0.90588236f, 0.8392157f);
            pointArray = new Point[this.tile.numSecondEdges()];
            pointArrayArray = new Point[this.tile.numSecondEdges()][];
            for (n = 0; n < this.tile.numSecondEdges(); ++n) {
                pointArray[n] = this.tile.getSecondVertex(n);
                pointArrayArray[n] = this.tile.getSecondEdge(n);
            }
        }
        geoGraphics.setColor(color2);
        geoGraphics.drawPolygon(pointArray2, true);
        geoGraphics.setColor(color);
        geoGraphics.drawPolygon(pointArray2, false);
        Graphics graphics = geoGraphics.getDirectGraphics();
        for (int i = 0; i < pointArray.length; ++i) {
            Point point = pointArray[i];
            Point point2 = pointArray[(i + 1) % pointArray.length];
            Point point3 = this.worldToScreen(point);
            int n2 = (int)point3.getX();
            int n3 = (int)point3.getY();
            graphics.setColor(color3);
            graphics.drawRect(n2 - 2, n3 - 2, 4, 4);
            if (!(point.dist(point2) > 1.0E-7)) continue;
            graphics.setColor(color4);
            Point[] pointArray3 = pointArrayArray[i];
            pointArray3 = this.first ? this.tile.getFirstTransform(i).apply(pointArray3) : this.tile.getSecondTransform(i).apply(pointArray3);
            for (int j = 1; j < pointArray3.length - 1; ++j) {
                point3 = this.worldToScreen(pointArray3[j]);
                n2 = (int)point3.getX();
                n3 = (int)point3.getY();
                if (i == this.drag_edge && j == this.drag_vert) {
                    graphics.setColor(color5);
                    graphics.fillOval(n2 - 2, n3 - 2, 4, 4);
                    graphics.setColor(color4);
                    continue;
                }
                graphics.fillOval(n2 - 2, n3 - 2, 4, 4);
            }
        }
    }

    class MouseGuy
    extends MouseAdapter
    implements MouseMotionListener {
        public void mouseReleased(MouseEvent mouseEvent) {
            Editor.this.drag_edge = -1;
            Editor.this.drag_vert = -1;
            Editor.this.app.doUpdate();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Point point;
            int n;
            Transform transform;
            Point[] pointArray;
            Point point2;
            Point point3;
            int n2;
            Point[][] pointArrayArray;
            Point[] pointArray2;
            Point[] pointArray3;
            if (GeoView.isShift(mouseEvent)) {
                return;
            }
            Editor.this.drag_edge = -1;
            Editor.this.drag_vert = -1;
            Point point4 = new Point(mouseEvent.getX(), mouseEvent.getY());
            if (Editor.this.first) {
                pointArray3 = Editor.this.tile.getFirstShape();
                pointArray2 = new Point[Editor.this.tile.numFirstEdges()];
                pointArrayArray = new Point[Editor.this.tile.numFirstEdges()][];
                for (n2 = 0; n2 < Editor.this.tile.numFirstEdges(); ++n2) {
                    pointArray2[n2] = Editor.this.tile.getFirstVertex(n2);
                    pointArrayArray[n2] = Editor.this.tile.getFirstEdge(n2);
                }
            } else {
                pointArray3 = Editor.this.tile.getSecondShape();
                pointArray2 = new Point[Editor.this.tile.numSecondEdges()];
                pointArrayArray = new Point[Editor.this.tile.numSecondEdges()][];
                for (n2 = 0; n2 < Editor.this.tile.numSecondEdges(); ++n2) {
                    pointArray2[n2] = Editor.this.tile.getSecondVertex(n2);
                    pointArrayArray[n2] = Editor.this.tile.getSecondEdge(n2);
                }
            }
            for (n2 = 0; n2 < pointArray2.length; ++n2) {
                point3 = pointArray2[n2];
                point2 = pointArray2[(n2 + 1) % pointArray2.length];
                if (!(point3.dist(point2) > 1.0E-7)) continue;
                pointArray = pointArrayArray[n2];
                transform = null;
                transform = Editor.this.first ? Editor.this.tile.getFirstTransform(n2) : Editor.this.tile.getSecondTransform(n2);
                for (n = 1; n < pointArray.length - 1; ++n) {
                    point = Editor.this.worldToScreen(transform.apply(pointArray[n]));
                    if (!(point4.dist2(point) < 49.0)) continue;
                    if (GeoView.isControl(mouseEvent)) {
                        Point[] pointArray4 = new Point[pointArray.length - 1];
                        System.arraycopy(pointArray, 0, pointArray4, 0, n);
                        System.arraycopy(pointArray, n + 1, pointArray4, n, pointArray.length - (n + 1));
                        if (Editor.this.first) {
                            Editor.this.tile.setFirstEdge(n2, pointArray4);
                        } else {
                            Editor.this.tile.setSecondEdge(n2, pointArray4);
                        }
                        Editor.this.app.doUpdate();
                        return;
                    }
                    Editor.this.drag_edge = n2;
                    Editor.this.drag_vert = n;
                    Editor.this.app.doUpdate();
                    return;
                }
            }
            if (GeoView.isControl(mouseEvent)) {
                Editor.this.app.doUpdate();
                return;
            }
            for (n2 = 0; n2 < pointArray2.length; ++n2) {
                point3 = pointArray2[n2];
                point2 = pointArray2[(n2 + 1) % pointArray2.length];
                if (!(point3.dist(point2) > 1.0E-7)) continue;
                pointArray = pointArrayArray[n2];
                transform = null;
                transform = Editor.this.first ? Editor.this.tile.getFirstTransform(n2) : Editor.this.tile.getSecondTransform(n2);
                for (n = 1; n < pointArray.length; ++n) {
                    Point point5;
                    point = Editor.this.worldToScreen(transform.apply(pointArray[n - 1]));
                    if (!(point4.distToSegment(point, point5 = Editor.this.worldToScreen(transform.apply(pointArray[n]))) < 7.0)) continue;
                    Point point6 = transform.invert().apply(Editor.this.screenToWorld(point4));
                    Point[] pointArray5 = new Point[pointArray.length + 1];
                    System.arraycopy(pointArray, 0, pointArray5, 0, n);
                    pointArray5[n] = point6;
                    System.arraycopy(pointArray, n, pointArray5, n + 1, pointArray.length - n);
                    if (Editor.this.first) {
                        Editor.this.tile.setFirstEdge(n2, pointArray5);
                    } else {
                        Editor.this.tile.setSecondEdge(n2, pointArray5);
                    }
                    Editor.this.drag_edge = n2;
                    Editor.this.drag_vert = n;
                    Editor.this.app.doUpdate();
                    return;
                }
            }
            Editor.this.app.doUpdate();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (GeoView.isShift(mouseEvent)) {
                return;
            }
            if (Editor.this.drag_edge != -1) {
                if (Editor.this.first) {
                    Point[] pointArray = Editor.this.tile.getFirstEdge(Editor.this.drag_edge);
                    Transform transform = Editor.this.tile.getFirstTransform(Editor.this.drag_edge);
                    pointArray[Editor.this.drag_vert] = transform.invert().apply(Editor.this.screenToWorld(mouseEvent.getX(), mouseEvent.getY()));
                    Editor.this.app.doUpdate();
                    return;
                }
                Point[] pointArray = Editor.this.tile.getSecondEdge(Editor.this.drag_edge);
                Transform transform = Editor.this.tile.getSecondTransform(Editor.this.drag_edge);
                pointArray[Editor.this.drag_vert] = transform.invert().apply(Editor.this.screenToWorld(mouseEvent.getX(), mouseEvent.getY()));
                Editor.this.app.doUpdate();
                return;
            }
        }
    }
}

