/*
 * Decompiled with CFR 0.152.
 */
package csk.penrose;

import csk.penrose.PenroseTile;
import csk.taprats.general.ParseXML;
import csk.taprats.general.XMLParseError;
import csk.taprats.geometry.Point;
import csk.taprats.geometry.Transform;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.Element;

public class KiteDart
extends PenroseTile {
    public static final double phi = 1.61803398875;
    public static final Point A;
    public static final Point B;
    public static final Point C;
    public static final Point D;
    public static final Point E;
    public static final boolean[] keo;
    public static final boolean[] deo;

    public boolean isFirstRotated(int n) {
        return keo[n];
    }

    public boolean isSecondRotated(int n) {
        return deo[n];
    }

    public Point[] getFirstEdge(int n) {
        switch (n) {
            case 0: 
            case 3: 
            case 4: 
            case 9: {
                return this.ea;
            }
            case 2: 
            case 5: {
                return this.eb;
            }
            case 1: 
            case 8: {
                return this.ec;
            }
        }
        return this.ed;
    }

    public void setFirstEdge(int n, Point[] pointArray) {
        switch (n) {
            case 0: 
            case 3: 
            case 4: 
            case 9: {
                this.ea = pointArray;
                return;
            }
            case 2: 
            case 5: {
                this.eb = pointArray;
                return;
            }
            case 1: 
            case 8: {
                this.ec = pointArray;
                return;
            }
        }
        this.ed = pointArray;
    }

    public Point[] getSecondEdge(int n) {
        switch (n) {
            case 0: 
            case 3: 
            case 4: 
            case 9: {
                return this.ed;
            }
            case 2: 
            case 5: {
                return this.eb;
            }
            case 1: 
            case 8: {
                return this.ec;
            }
        }
        return this.ea;
    }

    public void setSecondEdge(int n, Point[] pointArray) {
        switch (n) {
            case 0: 
            case 3: 
            case 4: 
            case 9: {
                this.ed = pointArray;
                return;
            }
            case 2: 
            case 5: {
                this.eb = pointArray;
                return;
            }
            case 1: 
            case 8: {
                this.ec = pointArray;
                return;
            }
        }
        this.ea = pointArray;
    }

    public KiteDart() {
        this.ps = new double[]{1.0E-5, 0.0, 1.0E-5, 0.0};
        this.ea = new Point[]{new Point(0.0, 0.0), new Point(1.0, 0.0)};
        this.eb = new Point[]{new Point(0.0, 0.0), new Point(1.0, 0.0)};
        this.ec = new Point[]{new Point(0.0, 0.0), new Point(1.0, 0.0)};
        this.ed = new Point[]{new Point(0.0, 0.0), new Point(1.0, 0.0)};
        this.setupTilingVertices();
    }

    private void setupTilingVertices() {
        Point point = KiteDart.erectOn(D, A, this.ps[0], this.ps[1]);
        Point point2 = KiteDart.erectOn(A, C, this.ps[2], this.ps[3]);
        Point point3 = KiteDart.erectOn(E, D, this.ps[2], this.ps[3]);
        Transform transform = Transform.rotateAroundPoint(E, -1.2566370614359172);
        Transform transform2 = Transform.rotateAroundPoint(A, -2.5132741228718345);
        this.vs1 = new Point[]{A, point2, point, point3, E, transform.apply(point3), transform.apply(point), B, transform2.apply(point), transform2.apply(point2)};
        point = KiteDart.erectOn(A, B, this.ps[0], this.ps[1]);
        point2 = KiteDart.erectOn(B, C, this.ps[2], this.ps[3]);
        point3 = KiteDart.erectOn(C, B, this.ps[0], this.ps[1] + 0.6283185307179586);
        transform = Transform.rotateAroundPoint(C, -1.2566370614359172);
        transform2 = Transform.rotateAroundPoint(A, 2.5132741228718345);
        this.vs2 = new Point[]{A, point, point2, point3, C, transform.apply(point3), transform.apply(point2), D, transform2.apply(point2), transform2.apply(point)};
    }

    public void setParameter(int n, double d) {
        super.setParameter(n, d);
        this.setupTilingVertices();
    }

    public void setParameters(double[] dArray) {
        super.setParameters(dArray);
        this.setupTilingVertices();
    }

    public KiteDart(Element element, ParseXML parseXML) throws XMLParseError {
        this.ps = new double[4];
        Point[][] pointArrayArray = new Point[4][];
        int n = 0;
        Enumeration enumeration = ParseXML.getChildren(element);
        while (enumeration.hasMoreElements()) {
            Element element2;
            Enumeration enumeration2;
            Element element3 = (Element)enumeration.nextElement();
            if (element3.getNodeName().equals("vertices")) {
                int n2 = 0;
                enumeration2 = ParseXML.getChildren(element3);
                while (enumeration2.hasMoreElements()) {
                    element2 = (Element)enumeration2.nextElement();
                    this.ps[n2] = ParseXML.getElementDouble(element2, "val", "param");
                    ++n2;
                }
                this.ps[1] = this.ps[1] * (Math.PI * 2);
                this.ps[3] = this.ps[3] * (Math.PI * 2);
                continue;
            }
            if (!element3.getNodeName().equals("edge_shape")) continue;
            Vector<Point> vector = new Vector<Point>();
            enumeration2 = ParseXML.getChildren(element3);
            while (enumeration2.hasMoreElements()) {
                element2 = (Element)enumeration2.nextElement();
                vector.addElement(ParseXML.getPoint(element2));
            }
            pointArrayArray[n] = new Point[vector.size()];
            vector.copyInto(pointArrayArray[n]);
            ++n;
        }
        this.ea = pointArrayArray[0];
        this.eb = pointArrayArray[1];
        this.ec = pointArrayArray[2];
        this.ed = pointArrayArray[3];
        this.setupTilingVertices();
    }

    public void write(PrintWriter printWriter, String string) throws IOException {
        printWriter.println(string + "<penrose type=\"P2\">");
        printWriter.println(string + "  <vertices>");
        printWriter.println(string + "    <param val=\"" + this.ps[0] + "\"/>");
        printWriter.println(string + "    <param val=\"" + this.ps[1] / (Math.PI * 2) + "\"/>");
        printWriter.println(string + "    <param val=\"" + this.ps[2] + "\"/>");
        printWriter.println(string + "    <param val=\"" + this.ps[3] / (Math.PI * 2) + "\"/>");
        printWriter.println(string + "  </vertices>");
        printWriter.println();
        KiteDart.writeEdgeShape(printWriter, string + "  ", this.ea);
        KiteDart.writeEdgeShape(printWriter, string + "  ", this.eb);
        KiteDart.writeEdgeShape(printWriter, string + "  ", this.ec);
        KiteDart.writeEdgeShape(printWriter, string + "  ", this.ed);
        printWriter.println(string + "</penrose>");
    }

    static {
        keo = new boolean[]{false, false, false, true, false, true, false, true, true, true};
        deo = new boolean[]{true, true, true, false, true, false, true, false, false, false};
        A = new Point(0.0, 0.0);
        B = new Point(Math.cos(0.3141592653589793), Math.sin(0.3141592653589793));
        C = new Point(0.0, 1.61803398875);
        D = new Point(-Math.cos(0.3141592653589793), Math.sin(0.3141592653589793));
        E = new Point(0.0, -1.0);
    }
}

