/*
 * Decompiled with CFR 0.152.
 */
package csk.penrose;

import csk.penrose.App;
import csk.penrose.Editor;
import csk.penrose.KiteDart;
import csk.penrose.PenroseTile;
import csk.penrose.Places;
import csk.penrose.Rhombs;
import csk.penrose.Viewer;
import csk.taprats.general.ParseXML;
import csk.taprats.general.XMLParseError;
import csk.taprats.toolkit.LoadSave;
import csk.taprats.toolkit.Slider;
import csk.taprats.toolkit.WindowCloser;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Observable;
import java.util.Observer;
import org.w3c.dom.Element;
import org.w3c.dom.ProcessingInstruction;

public class PenroseApp
extends Panel
implements App {
    protected PenroseTile tile;
    protected Viewer viewer;
    protected Editor edit_first;
    protected Editor edit_second;
    protected Slider s1;
    protected Slider s2;
    protected Slider s3;
    protected Slider s4;
    protected PopupMenu menu;
    protected Frame parent;

    public PenroseApp(PenroseTile penroseTile, Frame frame) {
        this(penroseTile, frame, false);
    }

    public PenroseApp(PenroseTile penroseTile, Frame frame, boolean bl) {
        this.tile = penroseTile;
        this.parent = frame;
        this.viewer = new Viewer(penroseTile);
        this.viewer.setSize(400, 400);
        this.viewer.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == 's') {
                    System.err.println("Writing to output.txt");
                    try {
                        FileWriter fileWriter = new FileWriter("output.txt");
                        PrintWriter printWriter = new PrintWriter(fileWriter);
                        PenroseApp.this.viewer.emitShapes(printWriter);
                        printWriter.flush();
                        fileWriter.close();
                    }
                    catch (Exception exception) {}
                } else if (keyEvent.getKeyChar() == 'p') {
                    PenroseApp.this.doPrint();
                }
            }
        });
        this.edit_first = new Editor(penroseTile, true);
        this.edit_first.setSize(200, 200);
        this.edit_first.setApp(this);
        this.edit_second = new Editor(penroseTile, false);
        this.edit_second.setSize(200, 200);
        this.edit_second.setApp(this);
        this.s1 = new Slider("P1", 0.0, 0.0, 1.0);
        this.s2 = new Slider("P2", 0.0, 0.0, 1.0);
        this.s3 = new Slider("P3", 0.0, 0.0, 1.0);
        this.s4 = new Slider("P4", 0.0, 0.0, 1.0);
        Panel panel = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        panel.setLayout(gridBagLayout);
        this.s1.insert(panel, gridBagLayout, 0, 0);
        this.s2.insert(panel, gridBagLayout, 0, 1);
        this.s3.insert(panel, gridBagLayout, 0, 2);
        this.s4.insert(panel, gridBagLayout, 0, 3);
        this.s1.value_changed.addObserver(new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                PenroseApp.this.tile.setParameter(0, (Double)object);
                PenroseApp.this.doUpdate();
            }
        });
        this.s2.value_changed.addObserver(new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                PenroseApp.this.tile.setParameter(1, (Double)object);
                PenroseApp.this.doUpdate();
            }
        });
        this.s3.value_changed.addObserver(new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                PenroseApp.this.tile.setParameter(2, (Double)object);
                PenroseApp.this.doUpdate();
            }
        });
        this.s4.value_changed.addObserver(new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                PenroseApp.this.tile.setParameter(3, (Double)object);
                PenroseApp.this.doUpdate();
            }
        });
        gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Button button = new Button("New P2");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PenroseApp.this.doNewP2();
            }
        });
        Button button2 = new Button("New P3");
        button2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PenroseApp.this.doNewP3();
            }
        });
        Button button3 = new Button("Save As...");
        button3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PenroseApp.this.doSaveAs();
            }
        });
        Button button4 = new Button("Load...");
        button4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PenroseApp.this.doLoad();
            }
        });
        Button button5 = new Button("Print...");
        button5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PenroseApp.this.doPrint();
            }
        });
        Button button6 = new Button("Quit");
        button6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        Panel panel2 = new Panel();
        if (bl) {
            panel2.setLayout(new GridLayout(1, 2));
            panel2.add(button);
            panel2.add(button2);
        } else {
            panel2.setLayout(new GridLayout(1, 6));
            panel2.add(button);
            panel2.add(button2);
            panel2.add(button3);
            panel2.add(button4);
            panel2.add(button5);
            panel2.add(button6);
        }
        gridBagLayout.setConstraints(panel2, gridBagConstraints);
        this.add(panel2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(this.edit_first, gridBagConstraints);
        this.add(this.edit_first);
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.edit_second, gridBagConstraints);
        this.add(this.edit_second);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagLayout.setConstraints(this.viewer, gridBagConstraints);
        this.add(this.viewer);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(panel, gridBagConstraints);
        this.add(panel);
        this.menu = new PopupMenu("Penrose");
        MenuItem menuItem = new MenuItem("Save As...");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PenroseApp.this.doSaveAs();
            }
        });
        this.menu.add(menuItem);
        menuItem = new MenuItem("Quit");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        this.menu.add(menuItem);
        this.viewer.add(this.menu);
        if (penroseTile instanceof KiteDart) {
            this.viewer.loadConfig(Places.p2_first, Places.p2_second);
        } else {
            this.viewer.loadConfig(Places.p3_first, Places.p3_second);
        }
    }

    public Viewer getViewer() {
        return this.viewer;
    }

    protected void doSaveAs() {
        String string = LoadSave.doSaveVerify(this.parent, "Save Penrose Tile", "save_penrose");
        if (string != null) {
            try {
                FileWriter fileWriter = new FileWriter(string);
                BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                PrintWriter printWriter = new PrintWriter(bufferedWriter);
                printWriter.println("<?xml version=\"1.0\"?>\n<?penrose 0.1?>\n");
                this.tile.write(printWriter, "");
                printWriter.flush();
                fileWriter.close();
            }
            catch (IOException iOException) {
                System.err.println("Could not save Penrose tile");
            }
        }
    }

    protected void doLoad() {
        String string = LoadSave.doLoadVerify(this.parent, "Load Penrose Tile", "load_penrose");
        if (string != null) {
            try {
                FileInputStream fileInputStream = new FileInputStream(string);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                PenroseTile penroseTile = PenroseApp.readTile(bufferedInputStream);
                fileInputStream.close();
                this.setTiling(penroseTile);
            }
            catch (IOException iOException) {
                System.err.println("Unable to read " + string);
            }
            catch (XMLParseError xMLParseError) {
                System.err.println("Malformed penrose file: " + xMLParseError);
            }
        }
    }

    protected void doPrint() {
        System.err.println("Writing to output.eps");
        try {
            FileWriter fileWriter = new FileWriter("output.eps");
            PrintWriter printWriter = new PrintWriter(fileWriter);
            this.viewer.print(printWriter);
            printWriter.flush();
            fileWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void doNewP2() {
        this.setTiling(new KiteDart());
    }

    protected void doNewP3() {
        this.setTiling(new Rhombs());
    }

    protected void setTiling(PenroseTile penroseTile) {
        this.tile = penroseTile;
        this.viewer.setTile(penroseTile);
        this.edit_first.setTile(penroseTile);
        this.edit_second.setTile(penroseTile);
        this.s1.setValue(penroseTile.getParameter(0));
        this.s2.setValue(penroseTile.getParameter(1));
        this.s3.setValue(penroseTile.getParameter(2));
        this.s4.setValue(penroseTile.getParameter(3));
    }

    @Override
    public void doUpdate() {
        this.viewer.forceRedraw();
        this.edit_first.forceRedraw();
        this.edit_second.forceRedraw();
    }

    public static PenroseTile readTile(InputStream inputStream) throws XMLParseError {
        return PenroseApp.readTile(new ParseXML(inputStream));
    }

    public static PenroseTile readTile(ParseXML parseXML) throws XMLParseError {
        ProcessingInstruction processingInstruction = parseXML.getPINode();
        if (processingInstruction == null) {
            throw new XMLParseError("Document has no PI node.");
        }
        if (!processingInstruction.getNodeName().equals("penrose")) {
            throw new XMLParseError("Document is not a Penrose file.");
        }
        Element element = parseXML.beginDocument();
        ParseXML.verifyElementName(element, "penrose");
        String string = ParseXML.getProp(element, "type");
        if (string.equals("P2")) {
            return new KiteDart(element, parseXML);
        }
        if (string.equals("P3")) {
            return new Rhombs(element, parseXML);
        }
        throw new XMLParseError("Unrecognized type of Penrose tile.");
    }

    public static final void main(String[] stringArray) throws IOException {
        KiteDart kiteDart = new KiteDart();
        Frame frame = new Frame("Penrose Tile Editor");
        PenroseApp penroseApp = new PenroseApp(kiteDart, frame, false);
        frame.setLayout(new BorderLayout());
        frame.add("Center", penroseApp);
        frame.addWindowListener(new WindowCloser(frame, true));
        frame.pack();
        frame.show();
    }
}

