/*
 * Decompiled with CFR 0.152.
 */
package csk.penrose;

import csk.taprats.geometry.Point;
import csk.taprats.geometry.Transform;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;

public class PenroseTile {
    protected Point[] ea;
    protected Point[] eb;
    protected Point[] ec;
    protected Point[] ed;
    protected Point[] vs1;
    protected Point[] vs2;
    protected double[] ps;

    public Point[] getIntrinsicEdge(int n) {
        switch (n) {
            case 0: {
                return this.ea;
            }
            case 1: {
                return this.eb;
            }
            case 2: {
                return this.ec;
            }
        }
        return this.ed;
    }

    public int numFirstEdges() {
        return this.vs1.length;
    }

    public Point getFirstVertex(int n) {
        return this.vs1[n];
    }

    public Point[] getFirstEdge(int n) {
        return null;
    }

    public void setFirstEdge(int n, Point[] pointArray) {
    }

    public Transform getFirstTransform(int n) {
        Point point = this.vs1[n];
        Point point2 = this.vs1[(n + 1) % this.vs1.length];
        if (point.dist(point2) > 1.0E-7) {
            Transform transform = Transform.matchLineSegment(point, point2);
            if (this.isFirstRotated(n)) {
                return transform.compose(new Transform(-1.0, 0.0, 1.0, 0.0, -1.0, 0.0));
            }
            return transform;
        }
        return null;
    }

    public boolean isFirstRotated(int n) {
        return false;
    }

    public int numSecondEdges() {
        return this.vs2.length;
    }

    public Point getSecondVertex(int n) {
        return this.vs2[n];
    }

    public Point[] getSecondEdge(int n) {
        return null;
    }

    public void setSecondEdge(int n, Point[] pointArray) {
    }

    public Transform getSecondTransform(int n) {
        Point point = this.vs2[n];
        Point point2 = this.vs2[(n + 1) % this.vs2.length];
        if (point.dist(point2) > 1.0E-7) {
            Transform transform = Transform.matchLineSegment(point, point2);
            if (this.isSecondRotated(n)) {
                return transform.compose(new Transform(-1.0, 0.0, 1.0, 0.0, -1.0, 0.0));
            }
            return transform;
        }
        return null;
    }

    public boolean isSecondRotated(int n) {
        return false;
    }

    public Point[] getFirstShape() {
        Vector<Point> vector = new Vector<Point>();
        for (int i = 0; i < this.vs1.length; ++i) {
            int n;
            if (!(this.vs1[i].dist(this.vs1[(i + 1) % this.vs1.length]) > 1.0E-7)) continue;
            Transform transform = this.getFirstTransform(i);
            Point[] pointArray = this.getFirstEdge(i);
            if (this.isFirstRotated(i)) {
                for (n = pointArray.length - 1; n > 0; --n) {
                    vector.addElement(transform.apply(pointArray[n]));
                }
                continue;
            }
            for (n = 0; n < pointArray.length - 1; ++n) {
                vector.addElement(transform.apply(pointArray[n]));
            }
        }
        Object[] objectArray = new Point[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Point[] getSecondShape() {
        Vector<Point> vector = new Vector<Point>();
        for (int i = 0; i < this.vs2.length; ++i) {
            int n;
            if (!(this.vs2[i].dist(this.vs2[(i + 1) % this.vs2.length]) > 1.0E-7)) continue;
            Transform transform = this.getSecondTransform(i);
            Point[] pointArray = this.getSecondEdge(i);
            if (this.isSecondRotated(i)) {
                for (n = pointArray.length - 1; n > 0; --n) {
                    vector.addElement(transform.apply(pointArray[n]));
                }
                continue;
            }
            for (n = 0; n < pointArray.length - 1; ++n) {
                vector.addElement(transform.apply(pointArray[n]));
            }
        }
        Object[] objectArray = new Point[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void setParameter(int n, double d) {
        this.ps[n] = n % 2 == 1 ? d * 2.0 * Math.PI : d;
    }

    public void setParameters(double[] dArray) {
        this.ps[0] = dArray[0];
        this.ps[1] = dArray[1] * 2.0 * Math.PI;
        this.ps[2] = dArray[2];
        this.ps[3] = dArray[3] * 2.0 * Math.PI;
    }

    public double getParameter(int n) {
        if (n % 2 == 1) {
            return this.ps[n] / (Math.PI * 2);
        }
        return this.ps[n];
    }

    public void write(PrintWriter printWriter, String string) throws IOException {
    }

    protected static void writeEdgeShape(PrintWriter printWriter, String string, Point[] pointArray) {
        printWriter.println(string + "<edge_shape>");
        for (int i = 0; i < pointArray.length; ++i) {
            Point point = pointArray[i];
            printWriter.println(string + "  <point x=\"" + point.getX() + "\" y=\"" + point.getY() + "\"/>");
        }
        printWriter.println(string + "</edge_shape>");
    }

    protected static final Point erectOn(Point point, Point point2, double d, double d2) {
        double d3 = point.dist(point2);
        double d4 = Math.sin(d2);
        double d5 = Math.cos(d2);
        double d6 = (point2.getY() - point.getY()) / d3;
        double d7 = (point2.getX() - point.getX()) / d3;
        return new Point(point.getX() + d * (d5 * d7 - d4 * d6), point.getY() + d * (d5 * d6 + d4 * d7));
    }
}

