/*
 * Decompiled with CFR 0.152.
 */
package csk.penrose;

import csk.penrose.PenroseTile;
import csk.taprats.general.ParseXML;
import csk.taprats.general.XMLParseError;
import csk.taprats.geometry.Point;
import csk.taprats.geometry.Transform;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.Element;

public class Rhombs
extends PenroseTile {
    public static final double phi = 1.61803398875;
    public static final double thinx = 1.0 / Math.tan(1.2566370614359172);
    public static final double thickx = 1.0 / Math.tan(0.9424777960769379);
    public static final Point THIN0;
    public static final Point THIN1;
    public static final Point THIN2;
    public static final Point THIN3;
    public static final Point THICK0;
    public static final Point THICK1;
    public static final Point THICK2;
    public static final Point THICK3;
    public static final boolean[] rot_thin;
    public static final boolean[] rot_thick;

    public Rhombs() {
        this.ps = new double[]{1.0E-5, 0.0, 1.0E-5, 0.0};
        this.ea = new Point[]{new Point(0.0, 0.0), new Point(1.0, 0.0)};
        this.eb = new Point[]{new Point(0.0, 0.0), new Point(1.0, 0.0)};
        this.ec = new Point[]{new Point(0.0, 0.0), new Point(1.0, 0.0)};
        this.ed = new Point[]{new Point(0.0, 0.0), new Point(1.0, 0.0)};
        this.setupTilingVertices();
    }

    private void setupTilingVertices() {
        Transform transform = Transform.rotateAroundPoint(THIN3, -1.2566370614359172);
        Transform transform2 = Transform.rotateAroundPoint(THIN2, -2.5132741228718345);
        Transform transform3 = Transform.rotateAroundPoint(THIN0, 2.5132741228718345);
        this.vs1 = new Point[10];
        this.vs1[0] = THIN0;
        this.vs1[1] = Rhombs.erectOn(THIN0, THIN1, this.ps[0], 1.8849555921538759 + this.ps[1]);
        this.vs1[2] = Rhombs.erectOn(THIN1, THIN0, this.ps[2], -this.ps[3]);
        this.vs1[3] = THIN2;
        this.vs1[4] = transform2.apply(this.vs1[2]);
        this.vs1[5] = Rhombs.erectOn(THIN3, THIN2, this.ps[0], this.ps[1]);
        this.vs1[6] = THIN3;
        this.vs1[7] = transform.apply(this.vs1[5]);
        this.vs1[8] = transform.apply(this.vs1[4]);
        this.vs1[9] = transform3.apply(this.vs1[1]);
        transform = Transform.rotateAroundPoint(THICK1, -1.2566370614359172);
        transform2 = Transform.rotateAroundPoint(THICK0, -2.5132741228718345);
        transform3 = Transform.rotateAroundPoint(THICK3, -1.2566370614359172);
        Transform transform4 = Transform.matchTwoSegments(THIN3, THIN2, THICK0, THICK1);
        Transform transform5 = Transform.matchTwoSegments(THIN3, THIN0, THICK3, THICK2);
        this.vs2 = new Point[12];
        this.vs2[0] = THICK0;
        this.vs2[1] = transform4.apply(this.vs1[5]);
        this.vs2[2] = transform4.apply(this.vs1[4]);
        this.vs2[3] = THICK1;
        this.vs2[4] = transform.apply(this.vs2[2]);
        this.vs2[5] = transform.apply(this.vs2[1]);
        this.vs2[6] = transform5.apply(this.vs1[8]);
        this.vs2[7] = transform5.apply(this.vs1[7]);
        this.vs2[8] = THICK3;
        this.vs2[9] = transform3.apply(this.vs2[7]);
        this.vs2[10] = transform3.apply(this.vs2[6]);
        this.vs2[11] = transform2.apply(this.vs2[1]);
    }

    public void setParameter(int n, double d) {
        super.setParameter(n, d);
        this.setupTilingVertices();
    }

    public void setParameters(double[] dArray) {
        super.setParameters(dArray);
        this.setupTilingVertices();
    }

    public Rhombs(Element element, ParseXML parseXML) throws XMLParseError {
        this.ps = new double[4];
        Point[][] pointArrayArray = new Point[4][];
        int n = 0;
        Enumeration enumeration = ParseXML.getChildren(element);
        while (enumeration.hasMoreElements()) {
            Element element2;
            Enumeration enumeration2;
            Element element3 = (Element)enumeration.nextElement();
            if (element3.getNodeName().equals("vertices")) {
                int n2 = 0;
                enumeration2 = ParseXML.getChildren(element3);
                while (enumeration2.hasMoreElements()) {
                    element2 = (Element)enumeration2.nextElement();
                    this.ps[n2] = ParseXML.getElementDouble(element2, "val", "param");
                    ++n2;
                }
                this.ps[1] = this.ps[1] * (Math.PI * 2);
                this.ps[3] = this.ps[3] * (Math.PI * 2);
                continue;
            }
            if (!element3.getNodeName().equals("edge_shape")) continue;
            Vector<Point> vector = new Vector<Point>();
            enumeration2 = ParseXML.getChildren(element3);
            while (enumeration2.hasMoreElements()) {
                element2 = (Element)enumeration2.nextElement();
                vector.addElement(ParseXML.getPoint(element2));
            }
            pointArrayArray[n] = new Point[vector.size()];
            vector.copyInto(pointArrayArray[n]);
            ++n;
        }
        this.ea = pointArrayArray[0];
        this.eb = pointArrayArray[1];
        this.ec = pointArrayArray[2];
        this.ed = pointArrayArray[3];
        this.setupTilingVertices();
    }

    public void write(PrintWriter printWriter, String string) throws IOException {
        printWriter.println(string + "<penrose type=\"P3\">");
        printWriter.println(string + "  <vertices>");
        printWriter.println(string + "    <param val=\"" + this.ps[0] + "\"/>");
        printWriter.println(string + "    <param val=\"" + this.ps[1] / (Math.PI * 2) + "\"/>");
        printWriter.println(string + "    <param val=\"" + this.ps[2] + "\"/>");
        printWriter.println(string + "    <param val=\"" + this.ps[3] / (Math.PI * 2) + "\"/>");
        printWriter.println(string + "  </vertices>");
        printWriter.println();
        Rhombs.writeEdgeShape(printWriter, string + "  ", this.ea);
        Rhombs.writeEdgeShape(printWriter, string + "  ", this.eb);
        Rhombs.writeEdgeShape(printWriter, string + "  ", this.ec);
        Rhombs.writeEdgeShape(printWriter, string + "  ", this.ed);
        printWriter.println(string + "</penrose>");
    }

    public boolean isFirstRotated(int n) {
        return rot_thin[n];
    }

    public boolean isSecondRotated(int n) {
        return rot_thick[n];
    }

    public Point[] getFirstEdge(int n) {
        switch (n) {
            case 1: 
            case 8: {
                return this.ea;
            }
            case 4: 
            case 7: {
                return this.eb;
            }
            case 2: 
            case 3: {
                return this.ec;
            }
        }
        return this.ed;
    }

    public void setFirstEdge(int n, Point[] pointArray) {
        switch (n) {
            case 1: 
            case 8: {
                this.ea = pointArray;
                return;
            }
            case 4: 
            case 7: {
                this.eb = pointArray;
                return;
            }
            case 2: 
            case 3: {
                this.ec = pointArray;
                return;
            }
        }
        this.ed = pointArray;
    }

    public Point[] getSecondEdge(int n) {
        switch (n) {
            case 5: 
            case 10: {
                return this.ea;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: {
                return this.eb;
            }
            case 2: 
            case 3: {
                return this.ec;
            }
        }
        return this.ed;
    }

    public void setSecondEdge(int n, Point[] pointArray) {
        switch (n) {
            case 5: 
            case 10: {
                this.ea = pointArray;
                return;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: {
                this.eb = pointArray;
                return;
            }
            case 2: 
            case 3: {
                this.ec = pointArray;
                return;
            }
        }
        this.ed = pointArray;
    }

    static {
        rot_thin = new boolean[]{false, false, true, false, false, true, false, true, true, true};
        rot_thick = new boolean[]{false, true, true, false, false, false, false, true, false, true, true, true};
        THIN0 = new Point(thinx, 0.0);
        THIN1 = new Point(0.0, 1.0);
        THIN2 = new Point(-thinx, 0.0);
        THIN3 = new Point(0.0, -1.0);
        THICK0 = new Point(thickx, 0.0);
        THICK1 = new Point(0.0, 1.0);
        THICK2 = new Point(-thickx, 0.0);
        THICK3 = new Point(0.0, -1.0);
    }
}

