/*
 * Decompiled with CFR 0.152.
 */
package csk.penrose;

import csk.penrose.KiteDart;
import csk.penrose.PenroseTile;
import csk.penrose.Places;
import csk.taprats.general.Input;
import csk.taprats.geometry.Point;
import csk.taprats.geometry.Transform;
import csk.taprats.toolkit.GeoGraphics;
import csk.taprats.toolkit.GeoView;
import csk.taprats.toolkit.PS;
import java.awt.Color;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Vector;

public class Viewer
extends GeoView {
    protected PenroseTile tile;
    protected Transform[] first_xforms;
    protected Transform[] second_xforms;

    Viewer(PenroseTile penroseTile) {
        super(0.0, 1.0, 1.0);
        this.tile = penroseTile;
        this.setBackground(new Color(0.9372549f, 0.9372549f, 0.9372549f));
        this.setSink(true);
    }

    public void setTile(PenroseTile penroseTile) {
        this.tile = penroseTile;
        if (penroseTile instanceof KiteDart) {
            this.loadConfig(Places.p2_first, Places.p2_second);
        } else {
            this.loadConfig(Places.p3_first, Places.p3_second);
        }
        this.forceRedraw();
    }

    public void loadConfig(Transform[] transformArray, Transform[] transformArray2) {
        this.first_xforms = transformArray2;
        this.second_xforms = transformArray;
        this.forceRedraw();
    }

    public void loadConfig(Reader reader) {
        try {
            Input input = new Input(reader);
            int n = input.readInt();
            int n2 = input.readInt();
            Transform transform = Transform.scale(1.0 / (double)Math.max(n, n2));
            Vector<Transform> vector = new Vector<Transform>();
            Vector<Transform> vector2 = new Vector<Transform>();
            try {
                while (true) {
                    String string = input.readString();
                    Transform transform2 = new Transform(input.readDouble(), input.readDouble(), input.readDouble(), input.readDouble(), input.readDouble(), input.readDouble());
                    if (string.equals("first")) {
                        vector.addElement(transform.compose(transform2));
                        continue;
                    }
                    if (!string.equals("second")) continue;
                    vector2.addElement(transform.compose(transform2));
                }
            }
            catch (IOException iOException) {
                Object[] objectArray = new Transform[vector.size()];
                Object[] objectArray2 = new Transform[vector2.size()];
                vector.copyInto(objectArray);
                vector2.copyInto(objectArray2);
                this.loadConfig((Transform[])objectArray, (Transform[])objectArray2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void redraw(GeoGraphics geoGraphics) {
        Point[] pointArray;
        int n;
        if (this.first_xforms == null || this.second_xforms == null) {
            return;
        }
        Point[] pointArray2 = this.tile.getFirstShape();
        Point[] pointArray3 = this.tile.getSecondShape();
        Color color = Color.black;
        Color color2 = new Color(0.87058824f, 0.8392157f, 0.7764706f);
        Color color3 = new Color(0.9372549f, 0.90588236f, 0.8392157f);
        for (n = 0; n < this.first_xforms.length; ++n) {
            pointArray = this.first_xforms[n].apply(pointArray2);
            geoGraphics.setColor(color2);
            geoGraphics.drawPolygon(pointArray, true);
            geoGraphics.setColor(color);
            geoGraphics.drawPolygon(pointArray, false);
        }
        for (n = 0; n < this.second_xforms.length; ++n) {
            pointArray = this.second_xforms[n].apply(pointArray3);
            geoGraphics.setColor(color3);
            geoGraphics.drawPolygon(pointArray, true);
            geoGraphics.setColor(color);
            geoGraphics.drawPolygon(pointArray, false);
        }
    }

    public void print(PrintWriter printWriter) {
        Point[] pointArray;
        int n;
        if (this.first_xforms == null || this.second_xforms == null) {
            return;
        }
        PS pS = new PS(printWriter, this.getBoundingBox());
        Point[] pointArray2 = this.tile.getFirstShape();
        Point[] pointArray3 = this.tile.getSecondShape();
        Color color = Color.black;
        Color color2 = new Color(0.87058824f, 0.8392157f, 0.7764706f);
        Color color3 = new Color(0.9372549f, 0.90588236f, 0.8392157f);
        for (n = 0; n < this.first_xforms.length; ++n) {
            pointArray = this.first_xforms[n].apply(pointArray2);
            pS.printColor(color2);
            pS.println("");
            pS.printPolygon(pointArray, 0, pointArray.length);
            pS.println("gsave fill grestore 0 0 0 setrgbcolor stroke");
        }
        for (n = 0; n < this.second_xforms.length; ++n) {
            pointArray = this.second_xforms[n].apply(pointArray3);
            pS.printColor(color3);
            pS.println("");
            pS.printPolygon(pointArray, 0, pointArray.length);
            pS.println("gsave fill grestore 0 0 0 setrgbcolor stroke");
        }
    }

    public void emitShapes(PrintWriter printWriter) {
        int n;
        Point[] pointArray = this.tile.getFirstShape();
        Point[] pointArray2 = this.tile.getSecondShape();
        printWriter.println(pointArray.length);
        for (n = 0; n < pointArray.length; ++n) {
            printWriter.println("" + pointArray[n].getX() + " " + pointArray[n].getY());
        }
        printWriter.println();
        printWriter.println(pointArray2.length);
        for (n = 0; n < pointArray2.length; ++n) {
            printWriter.println("" + pointArray2[n].getX() + " " + pointArray2[n].getY());
        }
    }
}

