/*
 * Decompiled with CFR 0.152.
 */
package csk.taprats;

import csk.taprats.geometry.Intersect;
import csk.taprats.geometry.Map;
import csk.taprats.geometry.Point;
import csk.taprats.geometry.Polygon;
import csk.taprats.geometry.Transform;
import csk.taprats.geometry.UnitCallback;
import csk.taprats.geometry.Vertex;
import csk.taprats.tile.Feature;
import csk.taprats.tile.PlacedFeature;
import csk.taprats.tile.Tiling;
import csk.taprats.toolkit.PS;

class MyCallback
implements UnitCallback {
    Tiling t;
    PS ps;
    Map map;
    double left;
    double right;
    double ang_l;
    double ang_c;
    double ang_r;
    double theta;
    boolean[] onoff;

    MyCallback(Tiling tiling, PS pS, double d, double d2, double d3) {
        this.t = tiling;
        this.ps = pS;
        this.map = null;
        this.left = d;
        this.right = d2;
        this.theta = d3;
        this.onoff = new boolean[tiling.numFeatures()];
        for (int i = 0; i < this.onoff.length; ++i) {
            this.onoff[i] = true;
        }
        this.ang_l = 0.39269908169872414;
        this.ang_c = 1.1780972450961724;
        this.ang_r = 0.39269908169872414;
    }

    MyCallback(Tiling tiling, double d, double d2, double d3) {
        this.t = tiling;
        this.ps = null;
        this.map = new Map();
        this.left = d;
        this.right = d2;
        this.theta = d3;
        this.onoff = new boolean[tiling.numFeatures()];
        for (int i = 0; i < this.onoff.length; ++i) {
            this.onoff[i] = true;
        }
        this.ang_l = 0.39269908169872414;
        this.ang_c = 1.1780972450961724;
        this.ang_r = 0.39269908169872414;
    }

    public void setAngles(double d, double d2, double d3) {
        this.ang_l = d;
        this.ang_c = d2;
        this.ang_r = d3;
    }

    public void setOnOff(boolean[] blArray) {
        for (int i = 0; i < blArray.length; ++i) {
            this.onoff[i] = blArray[i];
        }
    }

    private static double lerp(double d, double d2, double d3) {
        return (1.0 - d3) * d + d3 * d2;
    }

    public void receive(int n, int n2) {
        if (this.ps == null) {
            System.err.println("" + n + " " + n2);
        }
        Transform transform = Transform.translate(this.t.getTrans1().scale(n).add(this.t.getTrans2().scale(n2)));
        Transform transform2 = Transform.rotate(this.theta);
        for (int i = 0; i < this.t.numFeatures(); ++i) {
            Point point;
            Point point2;
            int n3;
            if (!this.onoff[i]) continue;
            PlacedFeature placedFeature = this.t.getFeature(i);
            Transform transform3 = transform.compose(placedFeature.getTransform());
            Feature feature = placedFeature.getFeature();
            Polygon polygon = feature.getPolygon();
            polygon.applyTransform(transform2.compose(transform3));
            polygon.forceCCW();
            Map map = null;
            if (this.ps == null) {
                map = new Map();
            }
            if (this.ps != null) {
                this.ps.printPolygon(polygon);
                this.ps.println("0.8 setgray stroke");
                this.ps.println("0 setgray");
            }
            int n4 = polygon.numVertices();
            double d = 0.0;
            for (int j = 0; j < n4; ++j) {
                Point point3 = polygon.getVertex(j);
                Point point4 = polygon.getVertex((j + 1) % n4);
                d = Math.max(d, point3.dist(point4));
            }
            int[] nArray = new int[n4];
            int n5 = 0;
            for (n3 = 0; n3 < n4; ++n3) {
                point2 = polygon.getVertex(n3);
                if (!(point2.dist(point = polygon.getVertex((n3 + 1) % n4)) > 0.25 * d)) continue;
                nArray[n5] = n3;
                ++n5;
            }
            for (n3 = 0; n3 < n5; ++n3) {
                Vertex vertex;
                Object object;
                Point point5;
                point2 = polygon.getVertex(nArray[n3]);
                point = polygon.getVertex((nArray[n3] + 1) % n4);
                Point point6 = polygon.getVertex(nArray[(n3 + 1) % n5]);
                Point point7 = polygon.getVertex((nArray[(n3 + 1) % n5] + 1) % n4);
                Point point8 = point2.convexSum(point, 0.5);
                Point point9 = point6.convexSum(point7, 0.5);
                double d2 = point8.getX();
                double d3 = point9.getX();
                double d4 = (d2 - this.left) / (this.right - this.left);
                double d5 = (d3 - this.left) / (this.right - this.left);
                if (d4 < 0.0) {
                    d4 = 0.0;
                }
                if (d4 > 1.0) {
                    d4 = 1.0;
                }
                if (d5 < 0.0) {
                    d5 = 0.0;
                }
                if (d5 > 1.0) {
                    d5 = 1.0;
                }
                double d6 = 0.0;
                double d7 = 0.0;
                d6 = d4 < 0.5 ? MyCallback.lerp(this.ang_l, this.ang_c, d4 * 2.0) : MyCallback.lerp(this.ang_c, this.ang_r, (d4 - 0.5) * 2.0);
                d7 = d5 < 0.5 ? MyCallback.lerp(this.ang_l, this.ang_c, d5 * 2.0) : MyCallback.lerp(this.ang_c, this.ang_r, (d5 - 0.5) * 2.0);
                Point point10 = Transform.rotateAroundPoint(point8, d6).apply(point);
                Point point11 = Intersect.getInternalParams(point8, point10, point9, point5 = Transform.rotateAroundPoint(point9, -d7).apply(point6));
                if (point11 != null && point11.getX() > 0.0 && point11.getY() > 0.0 && ((Point)(object = point8.convexSum(point10, point11.getX()))).sweep(point8, point9) > 0.3) {
                    if (this.ps != null) {
                        this.ps.printLine(point8, (Point)object);
                        this.ps.println("stroke");
                        this.ps.printLine(point9, (Point)object);
                        this.ps.println("stroke");
                        continue;
                    }
                    vertex = map.insertVertex(point8);
                    Vertex vertex2 = map.insertVertex(point9);
                    if (((Point)object).distToLine(point8, point9) < 1.0E-5) {
                        map.insertEdge(vertex, vertex2);
                        continue;
                    }
                    Vertex vertex3 = map.insertVertex((Point)object);
                    map.insertEdge(vertex, vertex3);
                    map.insertEdge(vertex3, vertex2);
                    continue;
                }
                if (this.ps != null) {
                    this.ps.printLine(point8, point9);
                    this.ps.println("stroke");
                    continue;
                }
                object = map.insertVertex(point8);
                vertex = map.insertVertex(point9);
                map.insertEdge((Vertex)object, vertex);
            }
            if (this.ps != null) continue;
            this.map.mergeSimple(map);
        }
    }

    Map getMap() {
        return this.map;
    }
}

