/*
 * Decompiled with CFR 0.152.
 */
package csk.taprats;

import csk.taprats.MyCallback;
import csk.taprats.geometry.FillRegion;
import csk.taprats.geometry.Map;
import csk.taprats.geometry.Polygon;
import csk.taprats.geometry.Rect;
import csk.taprats.geometry.Transform;
import csk.taprats.tile.Tiling;
import csk.taprats.tile.TilingLibrary;
import csk.taprats.toolkit.PS;
import csk.taprats.toolkit.WindowCloser;
import csk.taprats.ui.RenderPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;

public class Parquet {
    private static double ang_l;
    private static double ang_c;
    private static double ang_r;

    public static final void run(Tiling tiling, Rect rect, double d, boolean bl, boolean[] blArray) {
        double d2 = rect.getLeft();
        double d3 = rect.getRight();
        Rect rect2 = rect.centralScale(1.25);
        Polygon polygon = new Polygon(4);
        Transform transform = Transform.rotate(-d);
        polygon.addVertex(transform.apply(rect2.getTopLeft()));
        polygon.addVertex(transform.apply(rect2.getBottomLeft()));
        polygon.addVertex(transform.apply(rect2.getBottomRight()));
        polygon.addVertex(transform.apply(rect2.getTopRight()));
        if (bl) {
            FillRegion fillRegion = new FillRegion();
            MyCallback myCallback = new MyCallback(tiling, d2, d3, d);
            myCallback.setAngles(ang_l, ang_c, ang_r);
            if (blArray != null) {
                myCallback.setOnOff(blArray);
            }
            fillRegion.fill(polygon, tiling.getTrans1(), tiling.getTrans2(), myCallback);
            Map map = myCallback.getMap();
            RenderPanel renderPanel = new RenderPanel(map);
            renderPanel.setSize(500, 500);
            Frame frame = new Frame("Rendered Design");
            renderPanel.setParentFrame(frame);
            frame.addWindowListener(new WindowCloser(frame, false));
            frame.setLayout(new BorderLayout());
            frame.add("Center", (Component)renderPanel);
            frame.pack();
            frame.show();
        } else {
            try {
                FileWriter fileWriter = new FileWriter("output.eps");
                BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                PS pS = new PS(bufferedWriter, rect2.centralScale(1.3));
                pS.println("0.1 setlinewidth");
                FillRegion fillRegion = new FillRegion();
                MyCallback myCallback = new MyCallback(tiling, pS, d2, d3, d);
                myCallback.setAngles(ang_l, ang_c, ang_r);
                if (blArray != null) {
                    myCallback.setOnOff(blArray);
                }
                fillRegion.fill(polygon, tiling.getTrans1(), tiling.getTrans2(), myCallback);
                pS.println("showpage\n%%EOF");
                bufferedWriter.flush();
                fileWriter.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static final void main(String[] stringArray) {
        Object object;
        String string = null;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 20.0;
        double d4 = 5.0;
        double d5 = 0.0;
        boolean bl = false;
        ang_l = 0.39269908169872414;
        ang_c = 1.1780972450961724;
        ang_r = 0.39269908169872414;
        boolean[] blArray = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("--bb")) {
                d = new Double(stringArray[i + 1]);
                d2 = new Double(stringArray[i + 2]);
                d3 = new Double(stringArray[i + 3]);
                d4 = new Double(stringArray[i + 4]);
                i += 4;
                continue;
            }
            if (stringArray[i].endsWith(".tile") || stringArray[i].endsWith(".xml")) {
                string = stringArray[i];
                continue;
            }
            if (stringArray[i].equals("--theta")) {
                d5 = new Double(stringArray[++i]) * Math.PI / 180.0;
                continue;
            }
            if (stringArray[i].equals("--open")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("--onoff")) {
                object = stringArray[++i];
                blArray = new boolean[((String)object).length()];
                for (int j = 0; j < blArray.length; ++j) {
                    blArray[j] = ((String)object).charAt(j) == '1';
                }
                continue;
            }
            if (stringArray[i].equals("--angs")) {
                double d6 = new Double(stringArray[i + 1]);
                double d7 = new Double(stringArray[i + 2]);
                double d8 = new Double(stringArray[i + 3]);
                ang_l = d6 * Math.PI / 180.0;
                ang_c = d7 * Math.PI / 180.0;
                ang_r = d8 * Math.PI / 180.0;
                i += 3;
                continue;
            }
            string = stringArray[i];
        }
        Tiling tiling = null;
        if (string.endsWith(".tile") || string.endsWith(".xml")) {
            try {
                object = new FileInputStream(string);
                BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)object);
                tiling = Tiling.importTiling((InputStream)bufferedInputStream);
            }
            catch (Exception exception) {
                System.err.println("Unable to load tiling " + string + ".");
                System.exit(-1);
            }
        } else {
            object = TilingLibrary.importBuiltinTilingLibrary((String)"builtins");
            tiling = object.findTiling(string);
            if (tiling == null) {
                object = TilingLibrary.importBuiltinTilingLibrary((String)"archimedeans");
                tiling = object.findTiling(string);
            }
            if (tiling == null) {
                System.err.println("Unable to find tiling " + string + ".");
                System.exit(-1);
            }
        }
        Parquet.run(tiling, new Rect(d, d2, d3, d4), d5, bl, blArray);
    }
}

