/*
 * Decompiled with CFR 0.152.
 */
package csk.taprats;

import csk.taprats.About;
import csk.taprats.Taprats;
import csk.taprats.app.Prototype;
import csk.taprats.general.ParseXML;
import csk.taprats.general.XMLParseError;
import csk.taprats.tile.Symmetro;
import csk.taprats.tile.Tiling;
import csk.taprats.tile.TilingLibrary;
import csk.taprats.toolkit.LoadSave;
import csk.taprats.toolkit.WindowCloser;
import csk.taprats.ui.DesignEditor;
import csk.taprats.ui.TilingSelector;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.w3c.dom.Element;

public class Program {
    private static Frame app;
    private static TilingSelector sel;

    private static void tryToLaunchDesign(String string, boolean bl) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            ParseXML parseXML = new ParseXML(bufferedInputStream);
            DesignEditor designEditor = new DesignEditor(Prototype.readXML((ParseXML)parseXML, (Element)parseXML.beginDocument()));
            if (bl) {
                designEditor.quitOnClose();
            }
            Frame frame = new Frame("Design editor: " + designEditor.getTiling().getName());
            designEditor.setParentFrame(frame);
            frame.setLayout(new BorderLayout());
            frame.add("Center", (Component)designEditor);
            frame.addWindowListener(new WindowCloser(frame, bl));
            frame.pack();
            frame.show();
            return;
        }
        catch (XMLParseError xMLParseError) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.err.println("Unable to load design " + string);
        if (bl) {
            System.exit(-1);
        }
    }

    public static final void openAboutBox() {
        About about = new About();
        about.pack();
        about.show();
    }

    private static final void doLoadTiling(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            Tiling tiling = Tiling.importTiling((InputStream)bufferedInputStream);
            if (sel != null) {
                sel.addTiling(tiling);
            }
        }
        catch (Exception exception) {
            System.err.println("Unable to load tiling " + string + ".");
            exception.printStackTrace();
        }
    }

    public static final void doLoadTiling() {
        String string = LoadSave.doLoad(app, "Load Tiling...", "loadtiling");
        if (string != null) {
            Program.doLoadTiling(string);
        }
    }

    public static final void doLoadLibrary() {
        block2: {
            String string = LoadSave.doLoad(app, "Load Tiling Library...", "loadtiling");
            if (string == null) break block2;
            try {
                FileInputStream fileInputStream = new FileInputStream(string);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                TilingLibrary tilingLibrary = TilingLibrary.importTilingLibrary((InputStream)bufferedInputStream);
                sel.addTilingLibrary(tilingLibrary);
            }
            catch (Exception exception) {
                System.err.println("Unable to load tiling library " + string + ".");
                exception.printStackTrace();
            }
        }
    }

    public static final void doLoadDesign() {
        String string = LoadSave.doLoad(app, "Load Tiling...", "loaddesign");
        if (string != null) {
            Program.tryToLaunchDesign(string, false);
        }
    }

    private static final void dealWithTilingName(String string) {
        try {
            Program.doLoadTiling(string);
        }
        catch (Exception exception) {
            try {
                Symmetro.getTiling((String)string);
            }
            catch (Exception exception2) {
                System.err.println("Unable to preload tiling " + string + ".");
                exception.printStackTrace();
                exception2.printStackTrace();
                System.exit(-1);
            }
        }
    }

    public static final void main(String[] stringArray) {
        Object object;
        if (Boolean.getBoolean("taprats.debug.debug")) {
            Taprats.DEBUG = true;
        }
        String string = null;
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-h") || stringArray[n].equals("--help")) {
                System.err.println("Usage: java taprats.jar [options...] [design]");
                System.err.println("options:\n  -t <tiling-file>, --tiling <tiling-file>: preload this tiling.");
                System.err.println("  -h, --help: print this message.");
                System.exit(0);
            } else if (stringArray[n].equals("-t") || stringArray[n].equals("--tiling")) {
                vector.addElement(stringArray[++n]);
            } else {
                if (string != null) {
                    System.err.println("Too many designs on command line.");
                    System.exit(-1);
                }
                string = stringArray[n];
            }
            ++n;
        }
        if (string == null) {
            sel = new TilingSelector();
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            object = (String)vector.elementAt(n2);
            Program.dealWithTilingName((String)object);
            ++n2;
        }
        if (string != null) {
            Program.tryToLaunchDesign(string, true);
        } else {
            object = new Frame("Taprats " + Taprats.getVersionString());
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            ((Container)object).setLayout(gridBagLayout);
            app = object;
            Button button = new Button("About...");
            Button button2 = new Button("Quit");
            Button button3 = new Button("Load Design...");
            Button button4 = new Button("Load Tiling...");
            Button button5 = new Button("Load Library...");
            button2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    System.exit(0);
                }
            });
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Program.openAboutBox();
                }
            });
            button4.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Program.doLoadTiling();
                }
            });
            button3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Program.doLoadDesign();
                }
            });
            button5.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Program.doLoadLibrary();
                }
            });
            Panel panel = new Panel();
            panel.setLayout(new GridLayout(1, 4));
            panel.add(button2);
            panel.add(button);
            panel.add(button4);
            panel.add(button3);
            panel.add(button5);
            ((Window)object).addWindowListener(new WindowCloser((Window)object, true));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 2;
            gridBagLayout.setConstraints(panel, gridBagConstraints);
            ((Container)object).add(panel);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weighty = 3.0;
            gridBagConstraints.fill = 1;
            gridBagLayout.setConstraints((Component)sel, gridBagConstraints);
            ((Container)object).add((Component)sel);
            ((Window)object).pack();
            ((Window)object).show();
        }
    }
}

