/*
 * Decompiled with CFR 0.152.
 */
package csk.taprats.general;

import csk.taprats.general.ChildEnum;
import csk.taprats.general.XMLParseError;
import csk.taprats.geometry.Point;
import csk.taprats.geometry.Transform;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.SAXException;

public class ParseXML {
    protected Document doc;
    private static DocumentBuilderFactory doc_factory;
    private static DocumentBuilder doc_builder;
    private static TransformerFactory transformer_factory;
    private static Transformer transformer;

    public ParseXML(Document document) {
        this.doc = document;
    }

    public ParseXML(InputStream inputStream) throws XMLParseError {
        if (doc_builder != null) {
            try {
                this.doc = doc_builder.parse(inputStream);
            }
            catch (SAXException sAXException) {
                throw new XMLParseError("Couldn't parse document");
            }
            catch (IOException iOException) {
                throw new XMLParseError("Couldn't parse document");
            }
        }
    }

    public ParseXML(String string) throws XMLParseError {
        if (doc_builder != null) {
            try {
                this.doc = doc_builder.parse(string);
            }
            catch (SAXException sAXException) {
                throw new XMLParseError("Couldn't parse document");
            }
            catch (IOException iOException) {
                throw new XMLParseError("Couldn't parse document");
            }
        }
    }

    public Element beginDocument() {
        return this.doc.getDocumentElement();
    }

    public static final String getProp(Element element, String string) {
        String string2 = element.getAttribute(string);
        if (string2.length() == 0) {
            return null;
        }
        return string2;
    }

    public static final boolean hasProp(Element element, String string) {
        return element.hasAttribute(string);
    }

    public static double[] parseDoubles(Element element, String string, String string2) throws XMLParseError {
        Vector<Double> vector = new Vector<Double>();
        ParseXML.verifyElementName(element, string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(new Double(ParseXML.getPropDouble(element, stringTokenizer.nextToken())));
        }
        double[] dArray = new double[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            dArray[n] = (Double)vector.elementAt(n);
            ++n;
        }
        return dArray;
    }

    public static int getElementInt(Element element, String string, String string2) throws XMLParseError {
        ParseXML.verifyElementName(element, string2);
        return ParseXML.getPropInt(element, string);
    }

    public static int getPropInt(Element element, String string) {
        return Integer.parseInt(ParseXML.getProp(element, string));
    }

    public static double getElementDouble(Element element, String string, String string2) throws XMLParseError {
        ParseXML.verifyElementName(element, string2);
        return ParseXML.getPropDouble(element, string);
    }

    public static Point getPoint(Element element) throws XMLParseError {
        return new Point(ParseXML.getPropDouble(element, "x"), ParseXML.getPropDouble(element, "y"));
    }

    public static Transform getTransform(Element element) throws XMLParseError {
        return new Transform(ParseXML.getPropDouble(element, "a"), ParseXML.getPropDouble(element, "b"), ParseXML.getPropDouble(element, "c"), ParseXML.getPropDouble(element, "d"), ParseXML.getPropDouble(element, "e"), ParseXML.getPropDouble(element, "f"));
    }

    public static double getPropDouble(Element element, String string) throws XMLParseError {
        try {
            return new Double(ParseXML.getProp(element, string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new XMLParseError("Illegal floating point data in input");
        }
    }

    public static boolean getPropBool(Element element, String string) throws XMLParseError {
        String string2 = ParseXML.getElementProp(element, string);
        if (string2.equals("true")) {
            return true;
        }
        if (string2.equals("false")) {
            return false;
        }
        throw new XMLParseError("Invalid boolean attribute");
    }

    public static String getElementProp(Element element, String string) throws XMLParseError {
        String string2 = ParseXML.getProp(element, string);
        if (string2 == null) {
            throw new XMLParseError("Node didn't have expected property " + string);
        }
        return string2;
    }

    public static void verifyElementName(Element element, String string) throws XMLParseError {
        if (!element.getTagName().equals(string)) {
            throw new XMLParseError("Element name '" + element.getTagName() + "' didn't verify against '" + string + "'");
        }
    }

    public static Enumeration getChildren(Element element) {
        return new ChildEnum(element);
    }

    public static int numChildren(Element element) {
        int n = 0;
        Enumeration enumeration = ParseXML.getChildren(element);
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            ++n;
        }
        return n;
    }

    public static Element getOnlyChild(Element element) throws XMLParseError {
        Enumeration enumeration = ParseXML.getChildren(element);
        if (enumeration.hasMoreElements()) {
            Element element2 = (Element)enumeration.nextElement();
            if (enumeration.hasMoreElements()) {
                throw new XMLParseError("Expected node to have exactly one child.");
            }
            return element2;
        }
        throw new XMLParseError("Expected node to have exactly one child.");
    }

    public void dumpDocument(OutputStream outputStream) {
        DOMSource dOMSource = new DOMSource(this.doc);
        StreamResult streamResult = new StreamResult(outputStream);
        transformer.setOutputProperty("omit-xml-declaration", "no");
        try {
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerException transformerException) {}
    }

    public static void dumpNode(Node node, OutputStream outputStream) {
        DOMSource dOMSource = new DOMSource(node);
        StreamResult streamResult = new StreamResult(outputStream);
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        try {
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerException transformerException) {}
    }

    public ProcessingInstruction getPINode() {
        NodeList nodeList = this.doc.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node.getNodeType() == 7) {
                return (ProcessingInstruction)node;
            }
            ++n;
        }
        return null;
    }

    public void verifyPINode() throws XMLParseError {
        ProcessingInstruction processingInstruction = this.getPINode();
        if (processingInstruction == null) {
            throw new XMLParseError("Document has no PI node.");
        }
        if (!processingInstruction.getNodeName().equals("taprats")) {
            throw new XMLParseError("Document is not a Taprats file.");
        }
        System.err.println("Warning -- not verifying Taprats version.");
    }

    public static final void main(String[] stringArray) {
        try {
            ParseXML parseXML = new ParseXML(new FileInputStream(stringArray[0]));
            ProcessingInstruction processingInstruction = parseXML.getPINode();
            System.out.println(processingInstruction.getTarget());
            System.out.println(processingInstruction.getData());
            ParseXML.dumpNode(processingInstruction, System.out);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        try {
            doc_factory = DocumentBuilderFactory.newInstance();
            doc_builder = doc_factory.newDocumentBuilder();
            transformer_factory = TransformerFactory.newInstance();
            transformer = transformer_factory.newTransformer();
        }
        catch (Exception exception) {
            System.err.println("Warning!  Couldn't start XML engine.");
            System.err.println("Reading and writing of files will not work.");
        }
    }
}

