/*
 * Decompiled with CFR 0.152.
 */
package csk.taprats.geometry;

import csk.taprats.general.Loose;
import csk.taprats.geometry.Point;
import csk.taprats.geometry.Transform;

public class Circle {
    Point center;
    double radius;

    public Circle(Point point, double d) {
        this.center = point;
        this.radius = d;
    }

    public final Point getCenter() {
        return this.center;
    }

    public final double getRadius() {
        return this.radius;
    }

    public final Circle applyTransform(Transform transform) {
        Point point = transform.apply(this.center);
        double d = transform.apply(this.center.getX() + this.radius, this.center.getY()).dist(transform.apply(this.center));
        return new Circle(point, d);
    }

    public final void applyTransformD(Transform transform) {
        Point point = transform.apply(this.center);
        double d = transform.apply(this.center.getX() + this.radius, this.center.getY()).dist(transform.apply(this.center));
        this.center = point;
        this.radius = d;
    }

    public final boolean intersects(Circle circle) {
        return Loose.greaterThan(this.radius + circle.radius, this.center.dist(circle.center));
    }
}

