/*
 * Decompiled with CFR 0.152.
 */
package csk.taprats.geometry;

import csk.taprats.geometry.Edge;
import csk.taprats.geometry.Map;
import csk.taprats.geometry.Point;
import csk.taprats.geometry.Vertex;
import csk.taprats.geometry.face_info;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class Faces {
    private static final Vector extractFace(Vertex vertex, Edge edge) {
        Vector<Vertex> vector = new Vector<Vertex>();
        Vertex vertex2 = vertex;
        Edge edge2 = edge;
        do {
            vector.addElement(vertex2);
            Vertex vertex3 = edge2.getOther(vertex2);
            if (vertex3.numNeighbours() < 2) {
                return null;
            }
            Edge[] edgeArray = vertex3.getBeforeAndAfter(edge2);
            vertex2 = vertex3;
            edge2 = edgeArray[0];
        } while (!vertex2.equals(vertex));
        return vector;
    }

    private static final face_info getTwin(face_info face_info2, int n, Hashtable hashtable, Hashtable hashtable2) {
        Vertex vertex;
        Vertex vertex2 = (Vertex)face_info2.face.elementAt(n);
        Edge edge = vertex2.getNeighbour(vertex = (Vertex)face_info2.face.elementAt((n + 1) % face_info2.face.size()));
        if (edge.getV1().equals(vertex2)) {
            return (face_info)hashtable2.get(edge);
        }
        return (face_info)hashtable.get(edge);
    }

    private static final boolean isClockwise(Vector vector) {
        double d = 0.0;
        int n = 0;
        while (n < vector.size()) {
            Point point = ((Vertex)vector.elementAt(n)).getPosition();
            Point point2 = ((Vertex)vector.elementAt((n + 1) % vector.size())).getPosition();
            d += point.getX() * point2.getY() - point2.getX() * point.getY();
            ++n;
        }
        return d < 0.0;
    }

    public static final void handleVertex(Vertex vertex, Edge edge, Hashtable hashtable, Hashtable hashtable2, Vector vector) {
        Faces.handleVertex(vertex, edge, hashtable, hashtable2, vector, true);
    }

    public static final void handleVertex(Vertex vertex, Edge edge, Hashtable hashtable, Hashtable hashtable2, Vector vector, boolean bl) {
        Vector vector2 = Faces.extractFace(vertex, edge);
        if (vector2 == null) {
            return;
        }
        face_info face_info2 = new face_info(vector2, 0);
        if (bl) {
            if (!Faces.isClockwise(vector2)) {
                vector.addElement(face_info2);
            }
        } else {
            vector.addElement(face_info2);
        }
        int n = 0;
        while (n < vector2.size()) {
            Vertex vertex2;
            Vertex vertex3 = (Vertex)vector2.elementAt(n);
            Edge edge2 = vertex3.getNeighbour(vertex2 = (Vertex)vector2.elementAt((n + 1) % vector2.size()));
            if (edge2.getV1().equals(vertex3)) {
                hashtable.put(edge2, face_info2);
            } else {
                hashtable2.put(edge2, face_info2);
            }
            ++n;
        }
    }

    public static final Vector extractFaces(Map map) {
        Object object;
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        Vector vector = new Vector();
        Enumeration enumeration = map.getEdges();
        while (enumeration.hasMoreElements()) {
            object = (Edge)enumeration.nextElement();
            if (!hashtable.containsKey(object)) {
                Faces.handleVertex(((Edge)object).getV1(), (Edge)object, hashtable, hashtable2, vector, true);
            }
            if (hashtable2.containsKey(object)) continue;
            Faces.handleVertex(((Edge)object).getV2(), (Edge)object, hashtable, hashtable2, vector, true);
        }
        object = new Vector();
        int n = 0;
        while (n < vector.size()) {
            face_info face_info2 = (face_info)vector.elementAt(n);
            Vertex[] vertexArray = new Vertex[face_info2.face.size()];
            int n2 = 0;
            while (n2 < face_info2.face.size()) {
                vertexArray[n2] = (Vertex)face_info2.face.elementAt(n2);
                ++n2;
            }
            ((Vector)object).addElement(vertexArray);
            ++n;
        }
        return object;
    }

    public static final void extractFaces(Map map, Vector vector, Vector vector2) {
        int n;
        int n2;
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        Vector vector3 = new Vector();
        Enumeration enumeration = map.getEdges();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            if (!hashtable.containsKey(edge)) {
                Faces.handleVertex(edge.getV1(), edge, hashtable, hashtable2, vector3, true);
            }
            if (hashtable2.containsKey(edge)) continue;
            Faces.handleVertex(edge.getV2(), edge, hashtable, hashtable2, vector3, true);
        }
        int n3 = vector3.size();
        Stack<face_info> stack = new Stack<face_info>();
        face_info face_info2 = (face_info)vector3.elementAt(0);
        stack.push(face_info2);
        face_info2.state = 1;
        while (!stack.empty()) {
            face_info2 = (face_info)stack.pop();
            n2 = face_info2.face.size();
            int n4 = -1;
            n = 0;
            while (n < n2) {
                face_info face_info3 = Faces.getTwin(face_info2, n, hashtable, hashtable2);
                if (face_info3 != null) {
                    switch (face_info3.state) {
                        case 0: {
                            face_info3.state = 1;
                            stack.push(face_info3);
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            if (n4 == 0) {
                                throw new InternalError("Filling problem 1");
                            }
                            n4 = 1;
                            break;
                        }
                        case 3: {
                            if (n4 == 1) {
                                throw new InternalError("Filling problem 2");
                            }
                            n4 = 0;
                        }
                    }
                }
                ++n;
            }
            face_info2.state = n4 == 1 ? 3 : 2;
        }
        n2 = 0;
        while (n2 < vector3.size()) {
            face_info2 = (face_info)vector3.elementAt(n2);
            Point[] pointArray = new Point[face_info2.face.size()];
            n = 0;
            while (n < face_info2.face.size()) {
                pointArray[n] = ((Vertex)face_info2.face.elementAt(n)).getPosition();
                ++n;
            }
            if (face_info2.state == 3) {
                vector2.addElement(pointArray);
            } else if (face_info2.state == 2) {
                vector.addElement(pointArray);
            }
            ++n2;
        }
    }
}

