/*
 * Decompiled with CFR 0.152.
 */
package csk.taprats.geometry;

import csk.taprats.general.Comparison;
import csk.taprats.general.Input;
import csk.taprats.general.Loose;
import csk.taprats.general.ParseXML;
import csk.taprats.general.Sort;
import csk.taprats.general.XMLParseError;
import csk.taprats.geometry.ComparePoints;
import csk.taprats.geometry.Edge;
import csk.taprats.geometry.Intersect;
import csk.taprats.geometry.Point;
import csk.taprats.geometry.Transform;
import csk.taprats.geometry.Vertex;
import csk.taprats.toolkit.Util;
import csk.taprats.ui.MapViewer;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.Element;

public class Map
implements Cloneable {
    private Vector vertices = new Vector();
    private Vector edges = new Vector();

    public int numVertices() {
        return this.vertices.size();
    }

    public Enumeration getVertices() {
        return this.vertices.elements();
    }

    public int numEdges() {
        return this.edges.size();
    }

    public Enumeration getEdges() {
        return this.edges.elements();
    }

    public void removeEdge(Edge edge) {
        edge.getV1().removeEdge(edge);
        edge.getV2().removeEdge(edge);
        this.edges.removeElement(edge);
    }

    public void removeVertex(Vertex vertex) {
        Enumeration enumeration = vertex.neighbours();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            edge.getOther(vertex).removeEdge(edge);
            this.edges.removeElement(edge);
        }
        this.vertices.removeElement(vertex);
    }

    public Object clone() {
        Object object;
        Object object2;
        Map map = new Map();
        Enumeration enumeration = this.vertices.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (Vertex)enumeration.nextElement();
            ((Vertex)object2).copy = object = new Vertex(map, ((Vertex)object2).getPosition());
            map.vertices.addElement(object);
        }
        object2 = this.edges.elements();
        while (object2.hasMoreElements()) {
            object = (Edge)object2.nextElement();
            Edge edge = new Edge(map, ((Edge)object).getV1().copy, ((Edge)object).getV2().copy);
            map.edges.addElement(edge);
            edge.getV1().insertEdge(edge);
            edge.getV2().insertEdge(edge);
        }
        return map;
    }

    private static int lexCompareEdges(double d, double d2) {
        double d3 = d - d2;
        if (Loose.zero(d3)) {
            return 0;
        }
        if (d3 < 0.0) {
            return -1;
        }
        return 1;
    }

    private void sortVertices() {
        Sort.quickSort(this.vertices, 0, this.vertices.size() - 1, ComparePoints.getVertexComparator());
    }

    private void sortEdges() {
        Sort.quickSort(this.edges, 0, this.edges.size() - 1, new Comparison(){

            public int compare(Object object, Object object2) {
                Edge edge = (Edge)object;
                Edge edge2 = (Edge)object2;
                return Map.lexCompareEdges(edge.getMinX(), edge2.getMinX());
            }
        });
    }

    final Vertex getVertex_Simple(Point point) {
        Vertex vertex;
        int n = 0;
        while (n < this.vertices.size()) {
            vertex = (Vertex)this.vertices.elementAt(n);
            Point point2 = vertex.getPosition();
            int n2 = ComparePoints.lexComparePoints(point, point2);
            if (n2 == 0) {
                return vertex;
            }
            if (n2 < 0) {
                Vertex vertex2 = new Vertex(this, point);
                this.vertices.insertElementAt(vertex2, n);
                return vertex2;
            }
            ++n;
        }
        vertex = new Vertex(this, point);
        this.vertices.addElement(vertex);
        return vertex;
    }

    final void insertEdge_Simple(Edge edge) {
        double d = edge.getMinX();
        int n = 0;
        while (n < this.edges.size()) {
            Edge edge2 = (Edge)this.edges.elementAt(n);
            double d2 = edge2.getMinX();
            if (Map.lexCompareEdges(d, d2) < 0) {
                this.edges.insertElementAt(edge, n);
                return;
            }
            ++n;
        }
        this.edges.addElement(edge);
    }

    public final Edge insertEdge(Vertex vertex, Vertex vertex2) {
        Edge edge = vertex.getNeighbour(vertex2);
        if (edge != null) {
            return edge;
        }
        edge = new Edge(this, vertex, vertex2);
        this.insertEdge_Simple(edge);
        vertex.insertEdge(edge);
        vertex2.insertEdge(edge);
        return edge;
    }

    final void splitEdgesByVertex(Vertex vertex) {
        Point point = vertex.getPosition();
        double d = point.getX();
        int n = 0;
        while (n < this.edges.size()) {
            Edge edge = (Edge)this.edges.elementAt(n);
            double d2 = edge.getMinX();
            if (Map.lexCompareEdges(d2, d) > 0) {
                return;
            }
            Vertex vertex2 = edge.getV1();
            Vertex vertex3 = edge.getV2();
            if (Loose.zero(point.distToSegment(vertex2.getPosition(), vertex3.getPosition())) && !Loose.zero(point.dist(vertex2.getPosition())) && !Loose.zero(point.dist(vertex3.getPosition()))) {
                Edge edge2 = new Edge(this, vertex, vertex3);
                vertex3.swapEdge(vertex2, edge2);
                edge.v2 = vertex;
                this.edges.removeElementAt(n);
                this.insertEdge_Simple(edge2);
                this.insertEdge_Simple(edge);
                vertex.insertEdge(edge);
                vertex.insertEdge(edge2);
                return;
            }
            ++n;
        }
    }

    final Vertex getVertex_Complex(Point point) {
        Vertex vertex = this.getVertex_Simple(point);
        this.splitEdgesByVertex(vertex);
        return vertex;
    }

    public final Vertex insertVertex(Point point) {
        return this.getVertex_Complex(point);
    }

    void applyTrivialRigidMotion(Transform transform) {
        Enumeration enumeration = this.vertices.elements();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            vertex.pos = transform.apply(vertex.getPosition());
        }
    }

    public void scale(double d) {
        this.applyTrivialRigidMotion(Transform.scale(d));
    }

    public void translate(double d, double d2) {
        this.applyTrivialRigidMotion(Transform.translate(d, d2));
    }

    void applyGeneralRigidMotion(Transform transform) {
        Enumeration enumeration = this.vertices.elements();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            vertex.applyRigidMotion(transform);
        }
        this.sortVertices();
        this.sortEdges();
    }

    public void transformMap(Transform transform) {
        this.applyGeneralRigidMotion(transform);
    }

    public void transformVertex(Vertex vertex, Transform transform) {
        Object object;
        vertex.applyRigidMotion(transform);
        Enumeration enumeration = vertex.neighbours();
        while (enumeration.hasMoreElements()) {
            object = (Edge)enumeration.nextElement();
            Vertex vertex2 = ((Edge)object).getOther(vertex);
            vertex2.removeEdge((Edge)object);
            vertex2.insertEdge((Edge)object);
        }
        this.vertices.removeElement(vertex);
        object = vertex.getPosition();
        int n = 0;
        while (n < this.vertices.size()) {
            Vertex vertex3 = (Vertex)this.vertices.elementAt(n);
            Point point = vertex3.getPosition();
            int n2 = ComparePoints.lexComparePoints((Point)object, point);
            if (n2 < 0) {
                this.vertices.insertElementAt(vertex, n);
                return;
            }
            ++n;
        }
        this.vertices.addElement(vertex);
        this.sortEdges();
    }

    private void mergeVertices(Vector vector) {
        Vector vector2 = this.vertices;
        int n = vector2.size();
        int n2 = vector.size();
        this.vertices = new Vector(n + n2);
        int n3 = 0;
        int n4 = 0;
        while (true) {
            Vertex vertex;
            Vertex vertex2;
            if (n3 == n) {
                if (n4 == n2) {
                    return;
                }
                vertex2 = (Vertex)vector.elementAt(n4);
                vertex = new Vertex(this, vertex2.getPosition());
                this.vertices.addElement(vertex);
                vertex2.copy = vertex;
                ++n4;
                continue;
            }
            if (n4 == n2) {
                this.vertices.addElement(vector2.elementAt(n3));
                ++n3;
                continue;
            }
            vertex2 = (Vertex)vector2.elementAt(n3);
            vertex = (Vertex)vector.elementAt(n4);
            int n5 = ComparePoints.lexComparePoints(vertex2.getPosition(), vertex.getPosition());
            if (n5 < 0) {
                this.vertices.addElement(vertex2);
                ++n3;
                continue;
            }
            if (n5 == 0) {
                this.vertices.addElement(vertex2);
                vertex.copy = vertex2;
                ++n3;
                ++n4;
                continue;
            }
            if (n5 <= 0) continue;
            Vertex vertex3 = new Vertex(this, vertex.getPosition());
            this.vertices.addElement(vertex3);
            vertex.copy = vertex3;
            ++n4;
        }
    }

    public void mergeMap(Map map, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (!bl) {
            map = (Map)map.clone();
        }
        Vector<Point> vector = new Vector<Point>();
        Enumeration enumeration = map.getEdges();
        block0: while (enumeration.hasMoreElements()) {
            object4 = (Edge)enumeration.nextElement();
            object3 = ((Edge)object4).getV1().getPosition();
            object2 = ((Edge)object4).getV2().getPosition();
            double d = Math.max(((Point)object3).getX(), ((Point)object2).getX());
            object = this.getEdges();
            while (object.hasMoreElements()) {
                Edge edge = (Edge)object.nextElement();
                Point point = edge.getV1().getPosition();
                Point point2 = edge.getV2().getPosition();
                if (Map.lexCompareEdges(edge.getMinX(), d) > 0) continue block0;
                Point point3 = Intersect.getTrueIntersection((Point)object3, (Point)object2, point, point2);
                if (point3 == null) continue;
                vector.addElement(point3);
            }
        }
        object4 = vector.elements();
        while (object4.hasMoreElements()) {
            object3 = (Point)object4.nextElement();
            this.getVertex_Complex((Point)object3);
            map.getVertex_Complex((Point)object3);
        }
        this.mergeVertices(map.vertices);
        object3 = map.edges.elements();
        while (object3.hasMoreElements()) {
            object2 = (Edge)object3.nextElement();
            Vertex vertex = ((Edge)object2).getV1().copy;
            Vertex vertex2 = ((Edge)object2).getV2().copy;
            object = new Edge(this, vertex, vertex2);
            this.edges.addElement(object);
            vertex.insertEdge((Edge)object);
            vertex2.insertEdge((Edge)object);
        }
        this.sortEdges();
    }

    public void mergeMap(Map map) {
        this.mergeMap(map, false);
    }

    public void mergeSimple(Map map) {
        this.mergeVertices(map.vertices);
        Enumeration enumeration = map.getEdges();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            Vertex vertex = edge.getV1().copy;
            Vertex vertex2 = edge.getV2().copy;
            Edge edge2 = new Edge(this, vertex, vertex2);
            vertex.insertEdge(edge2);
            vertex2.insertEdge(edge2);
            this.edges.addElement(edge2);
        }
        this.sortEdges();
    }

    public void mergeSimpleMany(Map map, Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            Transform transform = (Transform)enumeration.nextElement();
            Enumeration enumeration2 = map.getVertices();
            while (enumeration2.hasMoreElements()) {
                object = (Vertex)enumeration2.nextElement();
                ((Vertex)object).copy = this.getVertex_Simple(transform.apply(((Vertex)object).getPosition()));
            }
            object = map.getEdges();
            while (object.hasMoreElements()) {
                Edge edge = (Edge)object.nextElement();
                Vertex vertex = edge.getV1().copy;
                Vertex vertex2 = edge.getV2().copy;
                Edge edge2 = new Edge(this, vertex, vertex2);
                vertex.insertEdge(edge2);
                vertex2.insertEdge(edge2);
                this.edges.addElement(edge2);
            }
        }
        this.sortEdges();
    }

    public static Map readXML(ParseXML parseXML, Element element) throws XMLParseError {
        Object object;
        Element element2;
        ParseXML.verifyElementName(element, "map");
        Enumeration enumeration = ParseXML.getChildren(element);
        Map map = new Map();
        if (!enumeration.hasMoreElements()) {
            throw new XMLParseError("Expected map data");
        }
        Element element3 = (Element)enumeration.nextElement();
        ParseXML.verifyElementName(element3, "vertices");
        Enumeration enumeration2 = ParseXML.getChildren(element3);
        while (enumeration2.hasMoreElements()) {
            element2 = (Element)enumeration2.nextElement();
            ParseXML.verifyElementName(element2, "vertex");
            object = new Point(ParseXML.getPropDouble(element2, "x"), ParseXML.getPropDouble(element2, "y"));
            map.vertices.addElement(new Vertex(map, (Point)object));
        }
        if (!enumeration.hasMoreElements()) {
            throw new XMLParseError("Expected map data");
        }
        element2 = (Element)enumeration.nextElement();
        ParseXML.verifyElementName(element2, "edges");
        object = ParseXML.getChildren(element2);
        while (object.hasMoreElements()) {
            Element element4 = (Element)object.nextElement();
            ParseXML.verifyElementName(element4, "edge");
            int n = ParseXML.getPropInt(element4, "v1");
            int n2 = ParseXML.getPropInt(element4, "v2");
            Vertex vertex = (Vertex)map.vertices.elementAt(n);
            Vertex vertex2 = (Vertex)map.vertices.elementAt(n2);
            Edge edge = new Edge(map, vertex, vertex2);
            map.edges.addElement(edge);
            vertex.insertEdge(edge);
            vertex2.insertEdge(edge);
        }
        return map;
    }

    public void writeXML(PrintWriter printWriter, String string) {
        Object object;
        printWriter.println(string + "<map>");
        printWriter.println(string + "  <vertices>");
        int n = 0;
        while (n < this.vertices.size()) {
            Vertex vertex = (Vertex)this.vertices.elementAt(n);
            object = vertex.getPosition();
            printWriter.println(string + "    <vertex x=\"" + ((Point)object).getX() + "\" y =\"" + ((Point)object).getY() + "\"/>");
            ++n;
        }
        printWriter.println(string + "  </vertices>");
        printWriter.println(string + "  <edges>");
        int n2 = 0;
        while (n2 < this.edges.size()) {
            object = (Edge)this.edges.elementAt(n2);
            printWriter.println(string + "    <edge v1=\"" + this.vertices.indexOf(((Edge)object).getV1()) + "\" v2=\"" + this.vertices.indexOf(((Edge)object).getV2()) + "\"/>");
            ++n2;
        }
        printWriter.println(string + "  </edges>");
        printWriter.println(string + "</map>");
    }

    public void dump(PrintStream printStream) {
        Object object;
        printStream.println("" + this.vertices.size() + " vertices.");
        printStream.println("" + this.edges.size() + " edges.\n");
        int n = 0;
        while (n < this.vertices.size()) {
            Vertex vertex = (Vertex)this.vertices.elementAt(n);
            printStream.println("vertex " + n + " at " + vertex.getPosition());
            object = vertex.neighbours();
            while (object.hasMoreElements()) {
                Edge edge = (Edge)object.nextElement();
                printStream.println("\t--> " + this.edges.indexOf(edge));
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.edges.size()) {
            object = (Edge)this.edges.elementAt(n2);
            printStream.println("edge " + n2 + " from " + this.vertices.indexOf(((Edge)object).getV1()) + " to " + this.vertices.indexOf(((Edge)object).getV2()));
            ++n2;
        }
    }

    public void save(PrintWriter printWriter) {
        Object object;
        printWriter.println(this.vertices.size());
        int n = 0;
        while (n < this.vertices.size()) {
            Vertex vertex = (Vertex)this.vertices.elementAt(n);
            object = vertex.getPosition();
            printWriter.println("" + ((Point)object).getX() + " " + ((Point)object).getY());
            ++n;
        }
        printWriter.println(this.edges.size());
        int n2 = 0;
        while (n2 < this.edges.size()) {
            object = (Edge)this.edges.elementAt(n2);
            printWriter.println("" + this.vertices.indexOf(((Edge)object).getV1()) + " " + this.vertices.indexOf(((Edge)object).getV2()));
            ++n2;
        }
    }

    public static Map load(Input input) {
        try {
            Object object;
            Map map = new Map();
            int n = input.readInt();
            Vertex[] vertexArray = new Vertex[n];
            int n2 = 0;
            while (n2 < n) {
                double d = input.readDouble();
                double d2 = input.readDouble();
                object = new Vertex(map, new Point(d, d2));
                map.vertices.addElement(object);
                vertexArray[n2] = object;
                ++n2;
            }
            int n3 = input.readInt();
            int n4 = 0;
            while (n4 < n3) {
                int n5 = input.readInt();
                int n6 = input.readInt();
                object = new Edge(map, vertexArray[n5], vertexArray[n6]);
                map.edges.addElement(object);
                vertexArray[n5].insertEdge((Edge)object);
                vertexArray[n6].insertEdge((Edge)object);
                ++n4;
            }
            return map;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean verify() {
        Object object;
        Edge edge;
        Object object2;
        boolean bl = true;
        int n = 0;
        while (n < this.edges.size()) {
            object2 = (Edge)this.edges.elementAt(n);
            if (((Edge)object2).getV1().equals(((Edge)object2).getV2())) {
                System.err.println("Trivial edge " + n);
                bl = false;
            }
            ++n;
        }
        object2 = this.edges.elements();
        while (object2.hasMoreElements()) {
            Edge edge2 = (Edge)object2.nextElement();
            if (!this.vertices.contains(edge2.getV1())) {
                System.err.println("edge " + this.edges.indexOf(edge2) + " V1 not in vertex list.");
                bl = false;
            }
            if (!this.vertices.contains(edge2.getV2())) {
                System.err.println("edge " + this.edges.indexOf(edge2) + " V2 not in vertex list.");
                bl = false;
            }
            if ((edge = edge2.getV1().getNeighbour(edge2.getV2())) == null) {
                System.err.println("edge " + this.edges.indexOf(edge2) + " not found in vertex v1 neighbours for vertex " + this.vertices.indexOf(edge2.getV1()));
                bl = false;
            }
            if (!edge.equals(edge2)) {
                System.err.println("edge " + this.edges.indexOf(edge2) + " not matched in vertex v1 neighbours for vertex " + this.vertices.indexOf(edge2.getV1()));
                bl = false;
            }
            if ((edge = edge2.getV2().getNeighbour(edge2.getV1())) == null) {
                System.err.println("edge " + this.edges.indexOf(edge2) + " not found in vertex v2 neighbours for vertex " + this.vertices.indexOf(edge2.getV2()));
                bl = false;
            }
            if (edge.equals(edge2)) continue;
            System.err.println("edge " + this.edges.indexOf(edge2) + " not matched in vertex v2 neighbours for vertex " + this.vertices.indexOf(edge2.getV2()));
            bl = false;
        }
        int n2 = 1;
        while (n2 < this.edges.size()) {
            double d;
            edge = (Edge)this.edges.elementAt(n2 - 1);
            object = (Edge)this.edges.elementAt(n2);
            double d2 = edge.getMinX();
            if (d2 > (d = ((Edge)object).getMinX()) + 1.0E-7) {
                System.err.println("Sortedness check failed for edges.");
                bl = false;
            }
            ++n2;
        }
        int n3 = 1;
        while (n3 < this.vertices.size()) {
            object = (Vertex)this.vertices.elementAt(n3 - 1);
            Vertex vertex = (Vertex)this.vertices.elementAt(n3);
            int n4 = ComparePoints.lexComparePoints(((Vertex)object).getPosition(), vertex.getPosition());
            if (n4 == 0) {
                System.err.println("Duplicate vertices.");
                bl = false;
            } else if (n4 > 0) {
                System.err.println("Sortedness check failed for vertices.");
                bl = false;
            }
            ++n3;
        }
        return bl;
    }

    public static final void main(String[] stringArray) {
        try {
            FileReader fileReader = new FileReader(stringArray[0]);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            Map map = Map.load(new Input(bufferedReader));
            MapViewer mapViewer = new MapViewer(-1.0, 1.0, 2.0, map, true);
            Util.openTestFrame((Component)mapViewer);
            char[] cArray = new char[50];
            int n = bufferedReader.read(cArray);
            int n2 = 0;
            while (n2 < n) {
                System.out.print(cArray[n2]);
                ++n2;
            }
            System.out.println();
        }
        catch (IOException iOException) {
            System.err.println("Bleah.");
        }
    }
}

