/*
 * Decompiled with CFR 0.152.
 */
package csk.taprats.geometry;

import csk.taprats.general.Loose;

public class Point
implements Cloneable {
    private static final double TRUNC = 1.0E7;
    public static final Point ORIGIN = new Point(0.0, 0.0);
    public static final Point UNIT_X = new Point(1.0, 0.0);
    public static final Point UNIT_Y = new Point(0.0, 1.0);
    private double x;
    private double y;

    public Point(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public Point() {
        this(0.0, 0.0);
    }

    public final Object clone() {
        return new Point(this.x, this.y);
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final void setX(double d) {
        this.x = d;
    }

    public final void setY(double d) {
        this.y = d;
    }

    public final double[] get() {
        double[] dArray = new double[]{this.x, this.y};
        return dArray;
    }

    public final double mag2() {
        return this.x * this.x + this.y * this.y;
    }

    public final double mag() {
        return Math.sqrt(this.mag2());
    }

    public final double dist2(Point point) {
        double d = this.x - point.x;
        double d2 = this.y - point.y;
        return d * d + d2 * d2;
    }

    public final double dist(Point point) {
        return Math.sqrt(this.dist2(point));
    }

    public final Point normalize() {
        double d = this.mag();
        if (d != 0.0) {
            return this.scale(1.0 / d);
        }
        return this;
    }

    public final void normalizeD() {
        double d = this.mag();
        if (d != 0.0) {
            this.scaleD(1.0 / d);
        }
    }

    public final Point add(Point point) {
        return new Point(this.x + point.x, this.y + point.y);
    }

    public final void addD(Point point) {
        this.x += point.x;
        this.y += point.y;
    }

    public final Point subtract(Point point) {
        return new Point(this.x - point.x, this.y - point.y);
    }

    public final void subtractD(Point point) {
        this.x -= point.x;
        this.y -= point.y;
    }

    public final double dot(Point point) {
        return this.x * point.x + this.y * point.y;
    }

    public final Point scale(double d) {
        return new Point(this.x * d, this.y * d);
    }

    public final Point scale(double d, double d2) {
        return new Point(this.x * d, this.y * d2);
    }

    public final void scaleD(double d) {
        this.x *= d;
        this.y *= d;
    }

    public final Point perp() {
        return new Point(-this.y, this.x);
    }

    public final void perpD() {
        double d = this.x;
        this.x = -this.y;
        this.y = d;
    }

    public final Point convexSum(Point point, double d) {
        double d2 = 1.0 - d;
        return new Point(d2 * this.x + d * point.x, d2 * this.y + d * point.y);
    }

    public final void convexSumD(Point point, double d) {
        double d2 = 1.0 - d;
        this.x = d2 * this.x + d * point.x;
        this.y = d2 * this.y + d * point.y;
    }

    public final double getAngle(Point point) {
        return Math.atan2(point.getY() - this.y, point.getX() - this.x);
    }

    public final double getAngle() {
        return Math.atan2(this.y, this.x);
    }

    public final double cross(Point point) {
        return this.x * point.y - this.y * point.x;
    }

    public final double sweep(Point point, Point point2) {
        double d = this.getAngle(point);
        double d2 = this.getAngle(point2);
        double d3 = d2 - d;
        while (d3 < 0.0) {
            d3 += Math.PI * 2;
        }
        return d3;
    }

    public final double distToSegment(Point point, Point point2) {
        double d = this.parameterizationOnLine(point, point2);
        if (d >= 0.0 && d <= 1.0) {
            double d2 = point.x + d * (point2.x - point.x);
            double d3 = point.y + d * (point2.y - point.y);
            return Math.sqrt((this.x - d2) * (this.x - d2) + (this.y - d3) * (this.y - d3));
        }
        if (d < 0.0) {
            return point.dist(this);
        }
        return point2.dist(this);
    }

    public final double distToLine(Point point, Point point2) {
        return this.dist(this.projectToLine(point, point2));
    }

    public final double parameterizationOnLine(Point point, Point point2) {
        Point point3 = point2.subtract(point);
        return this.subtract(point).dot(point3) / point3.dot(point3);
    }

    public final Point projectToLine(Point point, Point point2) {
        return point.convexSum(point2, this.parameterizationOnLine(point, point2));
    }

    public final String toString() {
        return "[ " + this.x + " " + this.y + " ]";
    }

    public final boolean equals(Object object) {
        if (!(object instanceof Point)) {
            return false;
        }
        return Loose.equals(this, (Point)object);
    }

    public final int hashCode() {
        long l = Double.doubleToLongBits(Math.floor(this.x * 1.0E7));
        long l2 = Double.doubleToLongBits(Math.floor(this.y * 1.0E7));
        return (int)(l ^ l >> 32 ^ (l2 ^ l2 >> 32));
    }

    public static final String toString(Point[] pointArray) {
        int n = pointArray.length;
        if (n == 0) {
            return "";
        }
        if (n == 1) {
            return pointArray[0].toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(pointArray[0].toString());
        int n2 = 1;
        while (n2 < n) {
            stringBuffer.append(" ");
            stringBuffer.append(pointArray[n2]);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static final void main(String[] stringArray) {
        Point point = new Point(new Double(stringArray[0]), new Double(stringArray[1]));
        Point point2 = new Point(new Double(stringArray[2]), new Double(stringArray[3]));
        Point point3 = new Point(new Double(stringArray[4]), new Double(stringArray[5]));
        System.out.println(point.distToSegment(point2, point3));
    }
}

