/*
 * Decompiled with CFR 0.152.
 */
package csk.taprats.geometry;

import csk.taprats.geometry.Point;
import csk.taprats.geometry.Rect;
import csk.taprats.geometry.Transform;

public class Polygon
implements Cloneable {
    Point[] pts;
    int size;
    int total_size;
    int grow;

    public Polygon(int n, int n2) {
        this.total_size = n;
        this.grow = n2;
        this.size = 0;
        this.pts = new Point[this.total_size];
    }

    public Polygon(int n) {
        this(n, 0);
    }

    public Polygon() {
        this(8);
    }

    public Polygon(Point[] pointArray) {
        this.pts = new Point[pointArray.length];
        this.grow = 0;
        this.size = pointArray.length;
        System.arraycopy(pointArray, 0, this.pts, 0, pointArray.length);
    }

    public Polygon(Point[] pointArray, int n, int n2) {
        this.size = n2 - n;
        this.pts = new Point[this.size];
        this.grow = 0;
        System.arraycopy(pointArray, n, this.pts, 0, this.size);
    }

    public Object clone() {
        return new Polygon(this.pts, 0, this.size);
    }

    public final void addVertex(Point point) {
        this.ensureSize(this.size + 1);
        this.pts[this.size] = point;
        ++this.size;
    }

    public final void removeVertex(int n) {
        int n2 = n;
        while (n2 < this.size - 1) {
            this.pts[n2] = this.pts[n2 + 1];
            ++n2;
        }
        --this.size;
    }

    public final void insertVertex(int n, Point point) {
        this.ensureSize(this.size + 1);
        int n2 = this.size;
        while (n2 > n) {
            this.pts[n2] = this.pts[n2 - 1];
            --n2;
        }
        this.pts[n] = point;
        ++this.size;
    }

    public final void setVertex(int n, Point point) {
        this.pts[n] = point;
    }

    public final Point getVertex(int n) {
        return this.pts[n];
    }

    public final int numVertices() {
        return this.size;
    }

    public final void applyTransform(Transform transform) {
        int n = 0;
        while (n < this.size) {
            this.pts[n] = transform.apply(this.pts[n]);
            ++n;
        }
    }

    private final void ensureSize(int n) {
        int n2 = Math.max(this.total_size, 1);
        while (n2 < n) {
            if (this.grow == 0) {
                n2 <<= 1;
                continue;
            }
            n2 += this.grow;
        }
        Point[] pointArray = new Point[n2];
        System.arraycopy(this.pts, 0, pointArray, 0, this.size);
        this.pts = pointArray;
        this.total_size = n2;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        boolean bl = true;
        int n = 0;
        while (n < this.size) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.pts[n]);
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public final double arcLength(boolean bl) {
        double d = 0.0;
        int n = 0;
        while (n < this.size - 1) {
            d += this.pts[n].dist(this.pts[n + 1]);
            ++n;
        }
        if (bl) {
            return d + this.pts[0].dist(this.pts[this.size - 1]);
        }
        return d;
    }

    public final double signedArea() {
        double d = 0.0;
        int n = 0;
        while (n < this.size) {
            d += this.pts[n].getX() * this.pts[(n + 1) % this.size].getY() - this.pts[n].getY() * this.pts[(n + 1) % this.size].getX();
            ++n;
        }
        return d * 0.5;
    }

    public final boolean isCCW() {
        return this.signedArea() > 0.0;
    }

    public final void forceCCW() {
        if (!this.isCCW()) {
            Point point = null;
            int n = 0;
            while (n < this.size / 2) {
                point = this.pts[n];
                this.pts[n] = this.pts[this.size - 1 - n];
                this.pts[this.size - 1 - n] = point;
                ++n;
            }
        }
    }

    public final double area() {
        return Math.abs(this.signedArea());
    }

    public static final boolean pointInPoly(Point[] pointArray, int n, int n2, Point point) {
        int n3 = n2 - n;
        boolean bl = false;
        double d = point.getX();
        double d2 = point.getY();
        Point point2 = pointArray[n];
        double d3 = point2.getX();
        double d4 = point2.getY();
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        int n4 = 0;
        while (n4 < n3) {
            Point point3 = pointArray[(n4 + n + 1) % n3];
            double d9 = point3.getX();
            double d10 = point3.getY();
            if (d3 < d9) {
                d5 = d3;
                d6 = d4;
                d7 = d9;
                d8 = d10;
            } else {
                d5 = d9;
                d6 = d10;
                d7 = d3;
                d8 = d4;
            }
            if (d5 <= d && d < d7 && (d - d5) * (d8 - d6) > (d2 - d6) * (d7 - d5)) {
                bl = !bl;
            }
            point2 = point3;
            d3 = d9;
            d4 = d10;
            ++n4;
        }
        return bl;
    }

    public final boolean containsPoint(Point point) {
        return Polygon.pointInPoly(this.pts, 0, this.size, point);
    }

    public final Rect getBoundingBox() {
        double d = this.pts[0].getX();
        double d2 = this.pts[0].getX();
        double d3 = this.pts[0].getY();
        double d4 = this.pts[0].getY();
        int n = 1;
        while (n < this.size) {
            double d5 = this.pts[n].getX();
            double d6 = this.pts[n].getY();
            d = Math.min(d, d5);
            d2 = Math.max(d2, d5);
            d3 = Math.min(d3, d6);
            d4 = Math.max(d4, d6);
            ++n;
        }
        return new Rect(d, d4, d2 - d, d4 - d3);
    }
}

