/*
 * Decompiled with CFR 0.152.
 */
package csk.taprats.geometry;

import csk.taprats.geometry.Point;
import csk.taprats.geometry.Transform;

public class Rect {
    private double x;
    private double y;
    private double width;
    private double height;

    public Rect(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.width = d3;
        this.height = d4;
    }

    public Rect(Point point, double d, double d2) {
        this.x = point.getX();
        this.y = point.getY();
        this.width = d;
        this.height = d2;
    }

    public Rect(Point point, Point point2) {
        this.x = point.getX();
        this.y = point.getY();
        this.width = point2.getX() - this.x;
        this.height = this.y - point2.getY();
    }

    public final double getX() {
        return this.x;
    }

    public final double getLeft() {
        return this.x;
    }

    public final double getTop() {
        return this.y;
    }

    public final double getY() {
        return this.y;
    }

    public final double getWidth() {
        return this.width;
    }

    public final double getHeight() {
        return this.height;
    }

    public final double getRight() {
        return this.x + this.width;
    }

    public final double getBottom() {
        return this.y - this.height;
    }

    public final Point getTopLeft() {
        return new Point(this.x, this.y);
    }

    public final Point getBottomLeft() {
        return new Point(this.x, this.y - this.height);
    }

    public final Point getTopRight() {
        return new Point(this.x + this.width, this.y);
    }

    public final Point getBottomRight() {
        return new Point(this.x + this.width, this.y - this.height);
    }

    public final Point getCenter() {
        return new Point(this.x + 0.5 * this.width, this.y - 0.5 * this.height);
    }

    public final Rect union(Rect rect) {
        double d = Math.min(this.x, rect.x);
        double d2 = Math.max(this.y, rect.y);
        double d3 = Math.max(this.x + this.width, rect.x + rect.width);
        double d4 = Math.min(this.y - this.height, rect.y - rect.height);
        return new Rect(d, d2, d3 - d, d2 - d4);
    }

    public final Rect intersection(Rect rect) {
        double d = Math.max(this.x, rect.x);
        double d2 = Math.min(this.y, rect.y);
        double d3 = Math.min(this.x + this.width, rect.x + rect.width);
        double d4 = Math.max(this.y - this.height, rect.y - rect.height);
        if (d3 < d || d4 > d2) {
            return null;
        }
        return new Rect(d, d2, d3 - d, d2 - d4);
    }

    public final Rect centralScale(double d) {
        double d2 = this.x + this.width * 0.5;
        double d3 = this.y - this.height * 0.5;
        double d4 = this.width * d;
        double d5 = this.height * d;
        return new Rect(d2 - d4 * 0.5, d3 + d5 * 0.5, d4, d5);
    }

    public final Transform centerInside(Rect rect) {
        double d = rect.width / this.width;
        double d2 = rect.height / this.height;
        double d3 = Math.min(d, d2);
        Transform transform = Transform.scale(d3, d3);
        Point point = new Point(this.x + this.width / 2.0, this.y - this.height / 2.0);
        Point point2 = new Point(rect.x + rect.width / 2.0, rect.y - rect.height / 2.0);
        return Transform.translate(point2).compose(transform).compose(Transform.translate(point.scale(-1.0)));
    }

    public final String toString() {
        return "[ (" + this.x + ", " + this.y + "); (" + this.width + ", " + this.height + ") ]";
    }
}

