/*
 * Decompiled with CFR 0.152.
 */
package csk.taprats.geometry;

import csk.taprats.geometry.Point;

public class Transform
implements Cloneable {
    public static final Transform ZERO = Transform.scale(0.0);
    public static final Transform IDENTITY = Transform.scale(1.0);
    private double a;
    private double b;
    private double c;
    private double d;
    private double e;
    private double f;

    public Transform(double d, double d2, double d3, double d4, double d5, double d6) {
        this.a = d;
        this.b = d2;
        this.c = d3;
        this.d = d4;
        this.e = d5;
        this.f = d6;
    }

    public Transform(double[] dArray) {
        this.a = dArray[0];
        this.b = dArray[1];
        this.c = dArray[2];
        this.d = dArray[2];
        this.e = dArray[4];
        this.f = dArray[5];
    }

    public void get(double[] dArray) {
        dArray[0] = this.a;
        dArray[1] = this.b;
        dArray[2] = this.c;
        dArray[3] = this.d;
        dArray[4] = this.e;
        dArray[5] = this.f;
    }

    public final double getUnitLength() {
        return Math.sqrt(this.a * this.a + this.d * this.d);
    }

    public final Object clone() {
        return new Transform(this.a, this.b, this.c, this.d, this.e, this.f);
    }

    public static final Transform scale(double d) {
        return new Transform(d, 0.0, 0.0, 0.0, d, 0.0);
    }

    public static final Transform scale(double d, double d2) {
        return new Transform(d, 0.0, 0.0, 0.0, d2, 0.0);
    }

    public static final Transform translate(double d, double d2) {
        return new Transform(1.0, 0.0, d, 0.0, 1.0, d2);
    }

    public static final Transform translate(Point point) {
        return new Transform(1.0, 0.0, point.getX(), 0.0, 1.0, point.getY());
    }

    public static final Transform rotate(double d) {
        return new Transform(Math.cos(d), -Math.sin(d), 0.0, Math.sin(d), Math.cos(d), 0.0);
    }

    public static final Transform rotateToPoint(Point point) {
        double d = point.mag();
        double d2 = point.getX() / d;
        double d3 = point.getY() / d;
        return new Transform(d2, -d3, 0.0, d3, d2, 0.0);
    }

    public static final Transform rotateAroundPoint(Point point, double d) {
        return Transform.translate(point).compose(Transform.rotate(d).compose(Transform.translate(-point.getX(), -point.getY())));
    }

    public static final Transform reflectThroughLine(Point point, Point point2) {
        Transform transform = Transform.matchLineSegment(point, point2);
        return transform.compose(Transform.scale(1.0, -1.0).compose(transform.invert()));
    }

    public static final Transform reflectAcrossMidpoint(Point point, Point point2) {
        Point point3 = point.convexSum(point2, 0.5);
        return Transform.reflectThroughLine(point3, point3.add(point2.subtract(point).perp()));
    }

    public final Transform compose(Transform transform) {
        return new Transform(this.a * transform.a + this.b * transform.d, this.a * transform.b + this.b * transform.e, this.a * transform.c + this.b * transform.f + this.c, this.d * transform.a + this.e * transform.d, this.d * transform.b + this.e * transform.e, this.d * transform.c + this.e * transform.f + this.f);
    }

    public final void composeD(Transform transform) {
        double d = this.a * transform.a + this.b * transform.d;
        double d2 = this.a * transform.b + this.b * transform.e;
        double d3 = this.a * transform.c + this.b * transform.f + this.c;
        double d4 = this.d * transform.a + this.e * transform.d;
        double d5 = this.d * transform.b + this.e * transform.e;
        double d6 = this.d * transform.c + this.e * transform.f + this.f;
        this.a = d;
        this.b = d2;
        this.c = d3;
        this.d = d4;
        this.e = d5;
        this.f = d6;
    }

    public final Point apply(Point point) {
        double d = point.getX();
        double d2 = point.getY();
        return new Point(this.a * d + this.b * d2 + this.c, this.d * d + this.e * d2 + this.f);
    }

    public final Point apply(double d, double d2) {
        return new Point(this.a * d + this.b * d2 + this.c, this.d * d + this.e * d2 + this.f);
    }

    public final void applyD(Point point) {
        double d = point.getX();
        double d2 = point.getY();
        point.setX(this.a * d + this.b * d2 + this.c);
        point.setY(this.d * d + this.e * d2 + this.f);
    }

    public final double applyX(double d, double d2) {
        return this.a * d + this.b * d2 + this.c;
    }

    public final double applyY(double d, double d2) {
        return this.d * d + this.e * d2 + this.f;
    }

    public final Point[] apply(Point[] pointArray) {
        int n = pointArray.length;
        Point[] pointArray2 = new Point[n];
        int n2 = 0;
        while (n2 < n) {
            pointArray2[n2] = this.apply(pointArray[n2]);
            ++n2;
        }
        return pointArray2;
    }

    public final void applyD(Point[] pointArray) {
        int n = pointArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.applyD(pointArray[n2]);
            ++n2;
        }
    }

    public final Transform invert() {
        double d = this.a * this.e - this.b * this.d;
        if (d == 0.0) {
            throw new IllegalArgumentException("Non invertible matrix.");
        }
        return new Transform(this.e / d, -this.b / d, (this.b * this.f - this.c * this.e) / d, -this.d / d, this.a / d, (this.c * this.d - this.a * this.f) / d);
    }

    public final void invertD() {
        double d = this.a * this.e - this.b * this.d;
        if (d == 0.0) {
            throw new IllegalArgumentException("Non invertible matrix.");
        }
        double d2 = this.e / d;
        double d3 = -this.b / d;
        double d4 = (this.b * this.f - this.c * this.e) / d;
        double d5 = -this.d / d;
        double d6 = this.a / d;
        double d7 = (this.c * this.d - this.a * this.f) / d;
        this.a = d2;
        this.b = d3;
        this.c = d4;
        this.d = d5;
        this.e = d6;
        this.f = d7;
    }

    public static final Transform matchLineSegment(Point point, Point point2) {
        double d = point.getX();
        double d2 = point.getY();
        double d3 = point2.getX();
        double d4 = point2.getY();
        return new Transform(d3 - d, d2 - d4, d, d4 - d2, d3 - d, d2);
    }

    public static final Transform matchTwoSegments(Point point, Point point2, Point point3, Point point4) {
        Transform transform = Transform.matchLineSegment(point, point2);
        Transform transform2 = Transform.matchLineSegment(point3, point4);
        return transform2.compose(transform.invert());
    }

    public static final Transform basisChange(Point point, Point point2) {
        double d = point.getX();
        double d2 = point.getY();
        double d3 = point2.getX();
        double d4 = point2.getY();
        double d5 = 1.0 / (d * d4 - d3 * d2);
        return new Transform(d4 * d5, -d3 * d5, 0.0, -d2 * d5, d * d5, 0.0);
    }

    public static final Transform basisChange(Point point, Point point2, Point point3) {
        double d = point.getX();
        double d2 = point.getY();
        double d3 = point2.getX() - d;
        double d4 = point2.getY() - d2;
        double d5 = point3.getX() - d;
        double d6 = point3.getY() - d2;
        double d7 = 1.0 / (d3 * d6 - d5 * d4);
        double d8 = d6 * d7;
        double d9 = -d5 * d7;
        double d10 = -d4 * d7;
        double d11 = d3 * d7;
        double d12 = -(d8 * d + d9 * d2);
        double d13 = -(d10 * d + d11 * d2);
        return new Transform(d8, d9, d12, d10, d11, d13);
    }

    public final String toString() {
        return "[ " + this.a + " " + this.b + " " + this.c + " ]\n" + "[ " + this.d + " " + this.e + " " + this.f + " ]\n" + "[ 0 0 1 ]";
    }

    public final boolean equals(Object object) {
        if (!(object instanceof Transform)) {
            return false;
        }
        Transform transform = (Transform)object;
        return this.a == transform.a && this.b == transform.b && this.c == transform.c && this.d == transform.d && this.e == transform.e && this.f == transform.f;
    }

    public final int hashCode() {
        return new Double(this.a).hashCode() ^ new Double(this.b).hashCode() ^ new Double(this.c).hashCode() ^ new Double(this.d).hashCode() ^ new Double(this.e).hashCode() ^ new Double(this.f).hashCode();
    }

    public final boolean flips() {
        return this.a * this.e - this.b * this.d < 0.0;
    }
}

